/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.network.server.SPSetSkillValue;
import yesman.epicfight.network.server.SPSkillExecutionFeedback;
import yesman.epicfight.skill.ChargeableSkill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillCancelEvent;

public abstract class Skill {
    private final Map<Attribute, AttributeModifier> attributes = Maps.newHashMap();
    protected final ResourceLocation registryName;
    protected final SkillCategory category;
    protected final ActivateType activateType;
    protected final Resource resource;
    protected float consumption;
    protected int maxDuration;
    protected int maxStackSize;
    protected int requiredXp;

    public static Builder<Skill> createBuilder() {
        return new Builder<Skill>();
    }

    public static Builder<Skill> createIdentityBuilder() {
        return new Builder().setCategory(SkillCategories.IDENTITY).setResource(Resource.NONE);
    }

    public static Builder<Skill> createMoverBuilder() {
        return new Builder().setCategory(SkillCategories.MOVER).setResource(Resource.STAMINA);
    }

    public Skill(Builder<? extends Skill> builder) {
        if (builder.registryName == null) {
            IllegalArgumentException e = new IllegalArgumentException("No registry name is given for " + this.getClass().getCanonicalName());
            e.printStackTrace();
        }
        this.registryName = builder.registryName;
        this.category = builder.category;
        this.activateType = builder.activateType;
        this.resource = builder.resource;
    }

    public void setParams(CompoundTag parameters) {
        this.consumption = parameters.m_128457_("consumption");
        this.maxDuration = parameters.m_128451_("max_duration");
        this.maxStackSize = parameters.m_128441_("max_stacks") ? parameters.m_128451_("max_stacks") : 1;
        this.requiredXp = parameters.m_128451_("xp_requirement");
        this.attributes.clear();
        if (parameters.m_128441_("attribute_modifiers")) {
            ListTag attributeList = parameters.m_128437_("attribute_modifiers", 10);
            for (Tag tag : attributeList) {
                CompoundTag comp = (CompoundTag)tag;
                String attribute = comp.m_128461_("attribute");
                Attribute attr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attribute));
                AttributeModifier modifier = ParseUtil.toAttributeModifier(comp);
                this.attributes.put(attr, modifier);
            }
        }
    }

    public boolean isExecutableState(PlayerPatch<?> executor) {
        return !((Player)executor.getOriginal()).m_5833_() && !executor.isInAir() && executor.getEntityState().canUseSkill();
    }

    public boolean canExecute(PlayerPatch<?> executor) {
        return this.checkExecuteCondition(executor);
    }

    public boolean checkExecuteCondition(PlayerPatch<?> executor) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void validationFeedback(LocalPlayerPatch playerpatch) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(LocalPlayerPatch executor, FriendlyByteBuf args) {
        return new CPExecuteSkill(executor.getSkill(this).getSlotId(), CPExecuteSkill.WorkType.ACTIVATE, args);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FriendlyByteBuf gatherArguments(LocalPlayerPatch executor, ControllEngine controllEngine) {
        return null;
    }

    public void executeOnServer(ServerPlayerPatch executor, FriendlyByteBuf args) {
        SPSkillExecutionFeedback feedbackPacket = SPSkillExecutionFeedback.executed(executor.getSkill(this).getSlotId());
        if (executor.isChargingSkill()) {
            Skill skill = this;
            if (skill instanceof ChargeableSkill) {
                ChargeableSkill chargingSkill = (ChargeableSkill)((Object)skill);
                feedbackPacket.getBuffer().writeInt(executor.getAccumulatedChargeAmount());
                chargingSkill.castSkill(executor, executor.getSkill(this), executor.getAccumulatedChargeAmount(), feedbackPacket, false);
                executor.resetSkillCharging();
                EpicFightNetworkManager.sendToPlayer(feedbackPacket, (ServerPlayer)executor.getOriginal());
            }
        } else {
            executor.getSkill(this).activate();
            EpicFightNetworkManager.sendToPlayer(feedbackPacket, (ServerPlayer)executor.getOriginal());
        }
    }

    public void cancelOnServer(ServerPlayerPatch executor, FriendlyByteBuf args) {
        SkillCancelEvent skillCancelEvent = new SkillCancelEvent(executor, executor.getSkill(this));
        executor.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CANCEL_EVENT, skillCancelEvent);
        EpicFightNetworkManager.sendToPlayer(SPSkillExecutionFeedback.expired(executor.getSkill(this).getSlotId()), (ServerPlayer)executor.getOriginal());
    }

    public final float getDefaultConsumptionAmount(PlayerPatch<?> executer) {
        switch (this.resource) {
            case STAMINA: {
                return executer.getModifiedStaminaConsume(this.consumption);
            }
            case WEAPON_CHARGE: {
                return 1.0f;
            }
            case COOLDOWN: {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void executeOnClient(LocalPlayerPatch executor, FriendlyByteBuf args) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void cancelOnClient(LocalPlayerPatch executor, FriendlyByteBuf args) {
        SkillCancelEvent skillCancelEvent = new SkillCancelEvent(executor, executor.getSkill(this));
        executor.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CANCEL_EVENT, skillCancelEvent);
    }

    public void onInitiate(SkillContainer container) {
        container.maxDuration = this.maxDuration;
        for (Map.Entry<Attribute, AttributeModifier> stat : this.attributes.entrySet()) {
            AttributeInstance attr = ((Player)container.getExecuter().getOriginal()).m_21051_(stat.getKey());
            if (attr.m_22109_(stat.getValue())) continue;
            attr.m_22118_(stat.getValue());
        }
    }

    public void onRemoved(SkillContainer container) {
        for (Map.Entry<Attribute, AttributeModifier> stat : this.attributes.entrySet()) {
            AttributeInstance attr = ((Player)container.getExecuter().getOriginal()).m_21051_(stat.getKey());
            if (!attr.m_22109_(stat.getValue())) continue;
            attr.m_22130_(stat.getValue());
        }
    }

    public void onReset(SkillContainer container) {
    }

    public void setConsumption(SkillContainer container, float value) {
        container.resource = Math.min(Math.max(value, 0.0f), container.getMaxResource());
        if (value >= container.getMaxResource()) {
            if (container.stack < this.maxStackSize) {
                ++container.stack;
                container.resource = 0.0f;
                container.prevResource = 0.0f;
            } else {
                container.resource = container.getMaxResource();
                container.prevResource = container.getMaxResource();
            }
        } else if (value == 0.0f && container.stack > 0) {
            --container.stack;
        }
    }

    public void updateContainer(SkillContainer container) {
        PlayerPatch<?> executer = container.getExecuter();
        container.prevResource = container.resource;
        container.prevDuration = container.duration;
        if (this.resource == Resource.COOLDOWN && container.stack < this.maxStackSize) {
            container.setResource(container.resource + this.getCooldownRegenPerSecond(executer) * 0.05f);
        }
        if (container.isActivated()) {
            if (this.activateType == ActivateType.DURATION) {
                --container.duration;
            }
            boolean isEnd = false;
            if (this.activateType == ActivateType.TOGGLE) {
                if (container.stack <= 0 && !((Player)executer.getOriginal()).m_7500_()) {
                    isEnd = true;
                }
            } else if (container.duration <= 0) {
                isEnd = true;
            }
            if (isEnd) {
                if (!container.getExecuter().isLogicalClient() && this.activateType != ActivateType.CHARGING) {
                    this.cancelOnServer((ServerPlayerPatch)executer, null);
                }
                container.deactivate();
            }
        }
        if (this.activateType == ActivateType.CHARGING && container.getExecuter().getChargingSkill() == this) {
            ChargeableSkill chargingSkill = (ChargeableSkill)((Object)this);
            chargingSkill.chargingTick(executer);
            if (!container.getExecuter().isLogicalClient()) {
                container.getExecuter().resetActionTick();
                if (container.getExecuter().getSkillChargingTicks(1.0f) > (float)chargingSkill.getAllowedMaxChargingTicks()) {
                    SPSkillExecutionFeedback feedbackPacket = SPSkillExecutionFeedback.executed(executer.getSkill(this).getSlotId());
                    feedbackPacket.getBuffer().writeInt(executer.getAccumulatedChargeAmount());
                    chargingSkill.castSkill((ServerPlayerPatch)executer, container, container.getExecuter().getAccumulatedChargeAmount(), feedbackPacket, true);
                    container.getExecuter().resetSkillCharging();
                    EpicFightNetworkManager.sendToPlayer(feedbackPacket, (ServerPlayer)container.getExecuter().getOriginal());
                }
            }
        }
    }

    public void setConsumptionSynchronize(ServerPlayerPatch executer, float amount) {
        Skill.setConsumptionSynchronize(executer, this, amount);
    }

    public void setMaxDurationSynchronize(ServerPlayerPatch executer, int amount) {
        Skill.setMaxDurationSynchronize(executer, this, amount);
    }

    public void setDurationSynchronize(ServerPlayerPatch executer, int amount) {
        Skill.setDurationSynchronize(executer, this, amount);
    }

    public void setStackSynchronize(ServerPlayerPatch executer, int amount) {
        Skill.setStackSynchronize(executer, this, amount);
    }

    public void setMaxResourceSynchronize(ServerPlayerPatch executer, float amount) {
        Skill.setMaxResourceSynchronize(executer, this, amount);
    }

    public static void setConsumptionSynchronize(ServerPlayerPatch executer, Skill skill, float amount) {
        SkillContainer skillContainer = executer.getSkill(skill);
        skillContainer.setResource(amount);
        EpicFightNetworkManager.sendToPlayer(new SPSetSkillValue(SPSetSkillValue.Target.RESOURCE, skillContainer.getSlotId(), amount, false), (ServerPlayer)executer.getOriginal());
    }

    public static void setDurationSynchronize(ServerPlayerPatch executer, Skill skill, int amount) {
        SkillContainer skillContainer = executer.getSkill(skill);
        skillContainer.setDuration(amount);
        EpicFightNetworkManager.sendToPlayer(new SPSetSkillValue(SPSetSkillValue.Target.DURATION, skillContainer.getSlotId(), amount, false), (ServerPlayer)executer.getOriginal());
    }

    public static void setMaxDurationSynchronize(ServerPlayerPatch executer, Skill skill, int amount) {
        SkillContainer skillContainer = executer.getSkill(skill);
        skillContainer.setMaxDuration(amount);
        EpicFightNetworkManager.sendToPlayer(new SPSetSkillValue(SPSetSkillValue.Target.MAX_DURATION, skillContainer.getSlotId(), amount, false), (ServerPlayer)executer.getOriginal());
    }

    public static void setStackSynchronize(ServerPlayerPatch executer, Skill skill, int amount) {
        SkillContainer skillContainer = executer.getSkill(skill);
        skillContainer.setStack(amount);
        EpicFightNetworkManager.sendToPlayer(new SPSetSkillValue(SPSetSkillValue.Target.STACK, skillContainer.getSlotId(), amount, false), (ServerPlayer)executer.getOriginal());
    }

    public static void setMaxResourceSynchronize(ServerPlayerPatch executer, Skill skill, float amount) {
        SkillContainer skillContainer = executer.getSkill(skill);
        skillContainer.setMaxResource(amount);
        EpicFightNetworkManager.sendToPlayer(new SPSetSkillValue(SPSetSkillValue.Target.MAX_RESOURCE, skillContainer.getSlotId(), amount, false), (ServerPlayer)executer.getOriginal());
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public String getTranslationKey() {
        return String.format("skill.%s.%s", this.getRegistryName().m_135827_(), this.getRegistryName().m_135815_());
    }

    public float getCooldownRegenPerSecond(PlayerPatch<?> player) {
        return 1.0f;
    }

    public SkillCategory getCategory() {
        return this.category;
    }

    public int getMaxStack() {
        return this.maxStackSize;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public float getConsumption() {
        return this.consumption;
    }

    public int getRequiredXp() {
        return this.requiredXp;
    }

    public Set<Map.Entry<Attribute, AttributeModifier>> getModfierEntry() {
        return this.attributes.entrySet();
    }

    public boolean resourcePredicate(PlayerPatch<?> playerpatch) {
        return playerpatch.consumeForSkill(this, this.resource);
    }

    public boolean shouldDeactivateAutomatically(PlayerPatch<?> executer) {
        return !((Player)executer.getOriginal()).m_7500_();
    }

    public ActivateType getActivateType() {
        return this.activateType;
    }

    public Resource getResourceType() {
        return this.resource;
    }

    public Skill getPriorSkill() {
        return null;
    }

    public Skill registerPropertiesToAnimation() {
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onScreen(LocalPlayerPatch playerpatch, float resolutionX, float resolutionY) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        return Lists.newArrayList();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getSkillTexture() {
        ResourceLocation name = this.getRegistryName();
        return new ResourceLocation(name.m_135827_(), "textures/gui/skills/" + name.m_135815_() + ".png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return false;
    }

    public String toString() {
        return this.getRegistryName().toString();
    }

    public Component getDisplayName() {
        return Component.m_237115_((String)String.format("%s.%s.%s", "skill", this.getRegistryName().m_135827_(), this.getRegistryName().m_135815_()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<WeaponCategory> getAvailableWeaponCategories() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean getCustomConsumptionTooltips(SkillBookScreen.AttributeIconList consumeIconList) {
        return false;
    }

    public static class Builder<T extends Skill> {
        protected ResourceLocation registryName;
        protected SkillCategory category;
        protected ActivateType activateType;
        protected Resource resource;
        protected CreativeModeTab tab;

        public Builder<T> setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public Builder<T> setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder<T> setActivateType(ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder<T> setResource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder<T> setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }
    }

    public static enum Resource {
        NONE((skill, playerpatch, amount) -> true, (skill, playerpatch, amount) -> {}),
        WEAPON_CHARGE((skill, playerpatch, amount) -> (float)playerpatch.getSkill(skill).getStack() >= amount, (skill, playerpatch, amount) -> skill.setStackSynchronize(playerpatch, playerpatch.getSkill(skill).getStack() - 1)),
        COOLDOWN((skill, playerpatch, amount) -> (float)playerpatch.getSkill(skill).getStack() >= amount, (skill, playerpatch, amount) -> skill.setStackSynchronize(playerpatch, playerpatch.getSkill(skill).getStack() - 1)),
        STAMINA((skill, playerpatch, amount) -> playerpatch.hasStamina(amount), (skill, playerpatch, amount) -> {
            playerpatch.resetActionTick();
            playerpatch.setStamina(playerpatch.getStamina() - amount);
        }),
        HEALTH((skill, playerpatch, amount) -> ((Player)playerpatch.getOriginal()).m_21223_() > amount, (skill, playerpatch, amount) -> ((ServerPlayer)playerpatch.getOriginal()).m_21153_(((ServerPlayer)playerpatch.getOriginal()).m_21223_() - amount));

        public final ResourcePredicate predicate;
        public final ResourceConsumer consumer;

        private Resource(ResourcePredicate predicate, ResourceConsumer consumer) {
            this.predicate = predicate;
            this.consumer = consumer;
        }

        @FunctionalInterface
        public static interface ResourcePredicate {
            public boolean canExecute(Skill var1, PlayerPatch<?> var2, float var3);
        }

        @FunctionalInterface
        public static interface ResourceConsumer {
            public void consume(Skill var1, ServerPlayerPatch var2, float var3);
        }
    }

    public static enum ActivateType {
        ONE_SHOT,
        DURATION,
        DURATION_INFINITE,
        TOGGLE,
        CHARGING;

    }
}

