/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.weaponinnate;

import java.util.List;
import java.util.Map;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.StaticAnimationProvider;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.projectile.ThrownTridentPatch;

public class EverlastingAllegiance
extends WeaponInnateSkill {
    private StaticAnimationProvider callingAnimation = () -> Animations.EVERLASTING_ALLEGIANCE_CALL;

    public static void setThrownTridentEntityId(ServerPlayer serverPlayer, SkillContainer skillContainer, int entityId) {
        skillContainer.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.THROWN_TRIDENT_ENTITY_ID.get(), Integer.valueOf(entityId), serverPlayer);
    }

    public static int getThrownTridentEntityId(SkillContainer skillContainer) {
        return (Integer)skillContainer.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.THROWN_TRIDENT_ENTITY_ID.get());
    }

    public EverlastingAllegiance(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
    }

    @Override
    public boolean checkExecuteCondition(PlayerPatch<?> executer) {
        return (Integer)executer.getSkill(this).getDataManager().getDataValue((SkillDataKey)SkillDataKeys.THROWN_TRIDENT_ENTITY_ID.get()) >= 0;
    }

    @Override
    public boolean canExecute(PlayerPatch<?> executer) {
        return this.checkExecuteCondition(executer);
    }

    @Override
    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        super.executeOnServer(executer, args);
        Entity entity = ((ServerPlayer)executer.getOriginal()).m_9236_().m_6815_(((Integer)executer.getSkill(this).getDataManager().getDataValue((SkillDataKey)SkillDataKeys.THROWN_TRIDENT_ENTITY_ID.get())).intValue());
        if (entity instanceof ThrownTrident) {
            ThrownTrident trident = (ThrownTrident)entity;
            ThrownTridentPatch tridentPatch = EpicFightCapabilities.getEntityPatch((Entity)trident, ThrownTridentPatch.class);
            tridentPatch.recalledBySkill();
            executer.playAnimationSynchronized(this.callingAnimation.get(), 0.0f);
            this.cancelOnServer(executer, args);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void cancelOnClient(LocalPlayerPatch executer, FriendlyByteBuf args) {
        super.cancelOnClient(executer, args);
        Entity entity = ((LocalPlayer)executer.getOriginal()).m_9236_().m_6815_(((Integer)executer.getSkill(this).getDataManager().getDataValue((SkillDataKey)SkillDataKeys.THROWN_TRIDENT_ENTITY_ID.get())).intValue());
        if (entity instanceof ThrownTrident) {
            ThrownTrident trident = (ThrownTrident)entity;
            ThrownTridentPatch tridentPatch = EpicFightCapabilities.getEntityPatch((Entity)trident, ThrownTridentPatch.class);
            tridentPatch.recalledBySkill();
        }
    }

    @Override
    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        int thrownTrident = (Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.THROWN_TRIDENT_ENTITY_ID.get());
        if (container.isDisabled() && thrownTrident >= 0) {
            container.setDisabled(false);
        } else if (!container.isDisabled() && thrownTrident < 0) {
            container.setDisabled(true);
        }
    }

    @Override
    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List<Component> list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Returning Trident:");
        return list;
    }

    @Override
    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }
}

