/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import com.mojang.datafixers.util.Pair;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.behavior.AnimatedCombatBehavior;
import yesman.epicfight.world.entity.ai.behavior.MoveToTargetSinkStopInaction;
import yesman.epicfight.world.entity.ai.brain.BrainRecomposer;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class CustomHumanoidMobPatch<T extends PathfinderMob>
extends HumanoidMobPatch<T> {
    private final MobPatchReloadListener.CustomHumanoidMobPatchProvider provider;

    public CustomHumanoidMobPatch(Faction faction, MobPatchReloadListener.CustomHumanoidMobPatchProvider provider) {
        super(faction);
        this.provider = provider;
        this.weaponLivingMotions = this.provider.getHumanoidWeaponMotions();
        this.weaponAttackMotions = this.provider.getHumanoidCombatBehaviors();
    }

    @Override
    public void setAIAsInfantry(boolean holdingRanedWeapon) {
        CombatBehaviors.Builder<HumanoidMobPatch<?>> builder;
        boolean useBrain;
        boolean bl = useBrain = !((PathfinderMob)this.original).m_6274_().f_21845_.isEmpty();
        if (useBrain) {
            if (!holdingRanedWeapon) {
                CombatBehaviors.Builder<HumanoidMobPatch<?>> builder2 = this.getHoldingItemWeaponMotionBuilder();
                BrainRecomposer.recomposeBrainByType(((PathfinderMob)this.original).m_6095_(), ((PathfinderMob)this.original).m_6274_(), builder2 != null ? new AnimatedCombatBehavior<CustomHumanoidMobPatch>(this, builder2.build(this)) : null, new MoveToTargetSinkStopInaction());
            }
        } else if (!holdingRanedWeapon && (builder = this.getHoldingItemWeaponMotionBuilder()) != null) {
            ((PathfinderMob)this.original).f_21345_.m_25352_(0, new AnimatedAttackGoal<CustomHumanoidMobPatch>(this, builder.build(this)));
            ((PathfinderMob)this.original).f_21345_.m_25352_(1, (Goal)new TargetChasingGoal(this, (PathfinderMob)this.getOriginal(), this.provider.getChasingSpeed(), true));
        }
    }

    @Override
    protected void setWeaponMotions() {
        if (this.weaponAttackMotions == null) {
            super.setWeaponMotions();
        }
    }

    public void initAttributes() {
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22100_(this.provider.getAttributeValues().getDouble(EpicFightAttributes.MAX_STRIKES.get()));
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22100_(this.provider.getAttributeValues().getDouble(EpicFightAttributes.ARMOR_NEGATION.get()));
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22100_(this.provider.getAttributeValues().getDouble(EpicFightAttributes.IMPACT.get()));
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.STUN_ARMOR.get()).m_22100_(this.provider.getAttributeValues().getDouble(EpicFightAttributes.STUN_ARMOR.get()));
        if (this.provider.getAttributeValues().containsKey((Object)Attributes.f_22281_)) {
            ((PathfinderMob)this.original).m_21051_(Attributes.f_22281_).m_22100_(this.provider.getAttributeValues().getDouble((Object)Attributes.f_22281_));
        }
    }

    @Override
    public void initAnimator(Animator clientAnimator) {
        for (Pair<LivingMotion, StaticAnimation> pair : this.provider.getDefaultAnimations()) {
            clientAnimator.addLivingAnimation((LivingMotion)pair.getFirst(), (StaticAnimation)pair.getSecond());
        }
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveMobUpdateMotion(considerInaction);
        if (((PathfinderMob)this.original).m_6117_()) {
            CapabilityItem activeItem = this.getHoldingItemCapability(((PathfinderMob)this.original).m_7655_());
            UseAnim useAnim = ((PathfinderMob)this.original).m_21120_(((PathfinderMob)this.original).m_7655_()).m_41780_();
            UseAnim secondUseAnim = activeItem.getUseAnimation(this);
            this.currentCompositeMotion = useAnim == UseAnim.BLOCK || secondUseAnim == UseAnim.BLOCK ? (activeItem.getWeaponCategory() == CapabilityItem.WeaponCategories.SHIELD ? LivingMotions.BLOCK_SHIELD : LivingMotions.BLOCK) : (useAnim == UseAnim.BOW || useAnim == UseAnim.SPEAR ? LivingMotions.AIM : (useAnim == UseAnim.CROSSBOW ? LivingMotions.RELOAD : this.currentLivingMotion));
        } else {
            this.currentCompositeMotion = CrossbowItem.m_40932_((ItemStack)((PathfinderMob)this.original).m_21205_()) ? LivingMotions.AIM : (this.getClientAnimator().getCompositeLayer((Layer.Priority)Layer.Priority.MIDDLE).animationPlayer.getAnimation().isReboundAnimation() ? LivingMotions.NONE : (((PathfinderMob)this.original).f_20911_ && ((PathfinderMob)this.original).m_21257_().isEmpty() ? LivingMotions.DIGGING : this.currentLivingMotion));
            if (this.getClientAnimator().isAiming() && this.currentCompositeMotion != LivingMotions.AIM) {
                this.playReboundAnimation();
            }
        }
    }

    @Override
    public StaticAnimation getHitAnimation(StunType stunType) {
        return this.provider.getStunAnimations().get((Object)stunType);
    }

    @Override
    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        CapabilityItem itemCap = this.getAdvancedHoldingItemCapability(hand);
        if (itemCap.isEmpty()) {
            return this.provider.getHitSound();
        }
        return itemCap.getHitSound();
    }

    @Override
    public SoundEvent getSwingSound(InteractionHand hand) {
        CapabilityItem itemCap = this.getAdvancedHoldingItemCapability(hand);
        if (itemCap.isEmpty()) {
            return this.provider.getSwingSound();
        }
        return itemCap.getSmashingSound();
    }

    @Override
    public HitParticleType getWeaponHitParticle(InteractionHand hand) {
        CapabilityItem itemCap = this.getAdvancedHoldingItemCapability(hand);
        if (itemCap.isEmpty()) {
            return this.provider.getHitParticle();
        }
        return itemCap.getHitParticle();
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float scale = this.provider.getScale();
        return super.getModelMatrix(partialTicks).scale(scale, scale, scale);
    }
}

