/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import io.netty.buffer.ByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;

public abstract class EntityPatch<T extends Entity> {
    protected T original;
    protected boolean initialized = false;

    public void tick(LivingEvent.LivingTickEvent event) {
        if (this.isLogicalClient()) {
            this.clientTick(event);
        } else {
            this.serverTick(event);
        }
    }

    protected void clientTick(LivingEvent.LivingTickEvent event) {
    }

    protected void serverTick(LivingEvent.LivingTickEvent event) {
    }

    public abstract boolean overrideRender();

    public void onStartTracking(ServerPlayer trackingPlayer) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processSpawnData(ByteBuf buf) {
    }

    public void onConstructed(T entityIn) {
        this.original = entityIn;
    }

    public void onJoinWorld(T entityIn, EntityJoinLevelEvent event) {
        this.initialized = true;
    }

    public void onDeath(LivingDeathEvent event) {
    }

    public final T getOriginal() {
        return this.original;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isLogicalClient() {
        return this.original.m_9236_().m_5776_();
    }

    public OpenMatrix4f getMatrix(float partialTicks) {
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, ((Entity)this.original).f_19860_, this.original.m_146909_(), ((Entity)this.original).f_19859_, this.original.m_146908_(), partialTicks, 1.0f, 1.0f, 1.0f);
    }

    public double getAngleTo(Entity entityIn) {
        Vec3 a = this.original.m_20154_();
        Vec3 b = new Vec3(entityIn.m_20185_() - this.original.m_20185_(), entityIn.m_20186_() - this.original.m_20186_(), entityIn.m_20189_() - this.original.m_20189_()).m_82541_();
        double cos = a.f_82479_ * b.f_82479_ + a.f_82480_ * b.f_82480_ + a.f_82481_ * b.f_82481_;
        return Math.toDegrees(Math.acos(cos));
    }

    public double getAngleToHorizontal(Entity entityIn) {
        Vec3 a = this.original.m_20154_();
        Vec3 b = new Vec3(entityIn.m_20185_() - this.original.m_20185_(), 0.0, entityIn.m_20189_() - this.original.m_20189_()).m_82541_();
        double cos = a.f_82479_ * b.f_82479_ + a.f_82480_ * b.f_82480_ + a.f_82481_ * b.f_82481_;
        return Math.toDegrees(Math.acos(cos));
    }

    public abstract OpenMatrix4f getModelMatrix(float var1);
}

