/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.player;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.Event;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.forgeevent.BattleModeSustainableEvent;
import yesman.epicfight.api.forgeevent.ChangePlayerModeEvent;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.skill.ChargeableSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.eventlistener.AttackSpeedModifyEvent;
import yesman.epicfight.world.entity.eventlistener.FallEvent;
import yesman.epicfight.world.entity.eventlistener.ModifyBaseDamageEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillConsumeEvent;
import yesman.epicfight.world.gamerule.EpicFightGamerules;

public abstract class PlayerPatch<T extends Player>
extends LivingEntityPatch<T> {
    public static EntityDataAccessor<Float> STAMINA;
    protected static final UUID PLAYER_EVENT_UUID;
    protected static final float PLAYER_SCALE = 0.9375f;
    protected PlayerEventListener eventListeners;
    protected PlayerMode playerMode = PlayerMode.MINING;
    protected boolean battleModeRestricted;
    protected float modelYRotO;
    protected float modelYRot;
    protected boolean useModelYRot;
    protected int tickSinceLastAction;
    protected int lastChargingTick;
    protected int chargingAmount;
    protected ChargeableSkill chargingSkill;
    protected double xo;
    protected double yo;
    protected double zo;
    public double dx;
    public double dz;

    public static void initPlayerDataAccessor() {
        STAMINA = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    }

    public static void createSyncedEntityData(LivingEntity livingentity) {
        livingentity.m_20088_().m_135372_(STAMINA, (Object)Float.valueOf(0.0f));
    }

    public PlayerPatch() {
        this.eventListeners = new PlayerEventListener(this);
    }

    @Override
    public void onJoinWorld(T entity, EntityJoinLevelEvent event) {
        super.onJoinWorld(entity, event);
        CapabilitySkill skillCapability = this.getSkillCapability();
        skillCapability.skillContainers[SkillSlots.BASIC_ATTACK.universalOrdinal()].setSkill(EpicFightSkills.BASIC_ATTACK);
        skillCapability.skillContainers[SkillSlots.AIR_ATTACK.universalOrdinal()].setSkill(EpicFightSkills.AIR_ATTACK);
        skillCapability.skillContainers[SkillSlots.KNOCKDOWN_WAKEUP.universalOrdinal()].setSkill(EpicFightSkills.KNOCKDOWN_WAKEUP);
        this.tickSinceLastAction = 0;
        this.eventListeners.addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, PLAYER_EVENT_UUID, playerEvent -> this.resetActionTick());
    }

    @Override
    public void initAnimator(Animator animator) {
        animator.addLivingAnimation(LivingMotions.IDLE, Animations.BIPED_IDLE);
        animator.addLivingAnimation(LivingMotions.WALK, Animations.BIPED_WALK);
        animator.addLivingAnimation(LivingMotions.RUN, Animations.BIPED_RUN);
        animator.addLivingAnimation(LivingMotions.SNEAK, Animations.BIPED_SNEAK);
        animator.addLivingAnimation(LivingMotions.SWIM, Animations.BIPED_SWIM);
        animator.addLivingAnimation(LivingMotions.FLOAT, Animations.BIPED_FLOAT);
        animator.addLivingAnimation(LivingMotions.KNEEL, Animations.BIPED_KNEEL);
        animator.addLivingAnimation(LivingMotions.FALL, Animations.BIPED_FALL);
        animator.addLivingAnimation(LivingMotions.MOUNT, Animations.BIPED_MOUNT);
        animator.addLivingAnimation(LivingMotions.SIT, Animations.BIPED_SIT);
        animator.addLivingAnimation(LivingMotions.FLY, Animations.BIPED_FLYING);
        animator.addLivingAnimation(LivingMotions.DEATH, Animations.BIPED_DEATH);
        animator.addLivingAnimation(LivingMotions.JUMP, Animations.BIPED_JUMP);
        animator.addLivingAnimation(LivingMotions.CLIMB, Animations.BIPED_CLIMBING);
        animator.addLivingAnimation(LivingMotions.SLEEP, Animations.BIPED_SLEEPING);
        animator.addLivingAnimation(LivingMotions.CREATIVE_FLY, Animations.BIPED_CREATIVE_FLYING);
        animator.addLivingAnimation(LivingMotions.CREATIVE_IDLE, Animations.BIPED_CREATIVE_IDLE);
        animator.addLivingAnimation(LivingMotions.DIGGING, Animations.BIPED_DIG);
        animator.addLivingAnimation(LivingMotions.AIM, Animations.BIPED_BOW_AIM);
        animator.addLivingAnimation(LivingMotions.SHOT, Animations.BIPED_BOW_SHOT);
        animator.addLivingAnimation(LivingMotions.DRINK, Animations.BIPED_DRINK);
        animator.addLivingAnimation(LivingMotions.EAT, Animations.BIPED_EAT);
        animator.addLivingAnimation(LivingMotions.SPECTATE, Animations.BIPED_SPYGLASS_USE);
    }

    public void copySkillsFrom(PlayerPatch<?> old) {
        CapabilitySkill oldSkill = old.getSkillCapability();
        CapabilitySkill newSkill = this.getSkillCapability();
        int i = 0;
        for (SkillContainer container : newSkill.skillContainers) {
            container.setExecuter(this);
            Skill oldone = oldSkill.skillContainers[i].getSkill();
            if (oldone != null && oldone.getCategory().learnable()) {
                container.setSkill(oldSkill.skillContainers[i].getSkill());
            }
            ++i;
        }
        for (SkillCategory skillCategory : SkillCategory.ENUM_MANAGER.universalValues()) {
            if (!oldSkill.hasCategory(skillCategory)) continue;
            for (Skill learnedSkill : oldSkill.getLearnedSkills(skillCategory)) {
                newSkill.addLearnedSkill(learnedSkill);
            }
        }
    }

    public void setModelYRot(float rotDeg, boolean sendPacket) {
        this.useModelYRot = true;
        this.modelYRot = rotDeg;
    }

    public void disableModelYRot(boolean sendPacket) {
        this.useModelYRot = false;
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float yRot;
        float oYRot;
        float scale = (((Player)this.original).m_6162_() ? 0.5f : 1.0f) * 0.9375f;
        Entity entity = ((Player)this.original).m_20202_();
        if (entity instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)entity;
            oYRot = ridingEntity.f_20884_;
            yRot = ridingEntity.f_20883_;
        } else {
            oYRot = this.modelYRotO;
            yRot = this.modelYRot;
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, oYRot, yRot, partialTicks, scale, scale, scale);
    }

    @Override
    public void serverTick(LivingEvent.LivingTickEvent event) {
        super.serverTick(event);
        if (this.state.canBasicAttack()) {
            ++this.tickSinceLastAction;
        }
        float stamina = this.getStamina();
        float maxStamina = this.getMaxStamina();
        float staminaRegen = (float)((Player)this.original).m_21133_((Attribute)EpicFightAttributes.STAMINA_REGEN.get());
        int regenStandbyTime = 900 / (int)(30.0f * staminaRegen);
        if (stamina < maxStamina && this.tickSinceLastAction > regenStandbyTime) {
            float staminaFactor = 1.0f + (float)Math.pow(stamina / (maxStamina - stamina * 0.5f), 2.0);
            this.setStamina(stamina + maxStamina * 0.01f * staminaFactor * staminaRegen);
        }
        if (maxStamina < stamina) {
            this.setStamina(maxStamina);
        }
        this.xo = ((Player)this.original).m_20185_();
        this.yo = ((Player)this.original).m_20186_();
        this.zo = ((Player)this.original).m_20189_();
    }

    @Override
    public void tick(LivingEvent.LivingTickEvent event) {
        if (this.playerMode == PlayerMode.BATTLE || this.battleModeRestricted) {
            SkillContainer[] battleModeSustainableEvent = new BattleModeSustainableEvent(this);
            MinecraftForge.EVENT_BUS.post((Event)battleModeSustainableEvent);
            if (battleModeSustainableEvent.isCanceled()) {
                if (this.playerMode == PlayerMode.BATTLE) {
                    this.toMiningMode(false);
                    this.battleModeRestricted = true;
                }
            } else if (this.battleModeRestricted) {
                this.battleModeRestricted = false;
                this.toBattleMode(false);
            }
        }
        if (((Player)this.original).m_20202_() == null) {
            for (SkillContainer container : this.getSkillCapability().skillContainers) {
                if (container == null) continue;
                container.update();
            }
        }
        super.tick(event);
        this.modelYRotO = this.modelYRot;
        if (this.getEntityState().turningLocked()) {
            if (!this.useModelYRot) {
                this.setModelYRot(((Player)this.original).m_146908_(), false);
            }
        } else if (this.useModelYRot) {
            this.disableModelYRot(false);
        }
        if (this.getEntityState().inaction() && ((Player)this.original).m_275832_() == null) {
            ((Player)this.original).f_20883_ = ((Player)this.original).m_146908_();
            ((Player)this.original).f_20885_ = ((Player)this.original).m_146908_();
        }
        if (!this.useModelYRot) {
            float originalYRot = this.isLogicalClient() ? ((Player)this.original).f_20883_ : ((Player)this.original).m_146908_();
            this.modelYRot += Mth.m_14036_((float)Mth.m_14177_((float)(originalYRot - this.modelYRot)), (float)-45.0f, (float)45.0f);
        }
    }

    public SkillContainer getSkill(Skill skill) {
        if (skill == null) {
            return null;
        }
        return this.getSkillCapability().getSkillContainer(skill);
    }

    public SkillContainer getSkill(SkillSlot slot) {
        return this.getSkill(slot.universalOrdinal());
    }

    public SkillContainer getSkill(int slotIndex) {
        return this.getSkillCapability().skillContainers[slotIndex];
    }

    public CapabilitySkill getSkillCapability() {
        return (CapabilitySkill)((Player)this.original).getCapability(EpicFightCapabilities.CAPABILITY_SKILL).orElse((Object)CapabilitySkill.EMPTY);
    }

    public PlayerEventListener getEventListener() {
        return this.eventListeners;
    }

    @Override
    public float getModifiedBaseDamage(float baseDamage) {
        ModifyBaseDamageEvent<PlayerPatch> event = new ModifyBaseDamageEvent<PlayerPatch>(this, baseDamage);
        this.getEventListener().triggerEvents(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, event);
        return event.getDamage();
    }

    public float getAttackSpeed(InteractionHand hand) {
        float baseSpeed = hand == InteractionHand.MAIN_HAND ? (float)((Player)this.original).m_21133_(Attributes.f_22283_) : (float)(this.isOffhandItemValid() ? ((Player)this.original).m_21133_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get()) : ((Player)this.original).m_21172_(Attributes.f_22283_));
        return this.getModifiedAttackSpeed(this.getAdvancedHoldingItemCapability(hand), baseSpeed);
    }

    public float getModifiedAttackSpeed(CapabilityItem itemCapability, float baseSpeed) {
        AttackSpeedModifyEvent event = new AttackSpeedModifyEvent(this, itemCapability, baseSpeed);
        this.eventListeners.triggerEvents(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, event);
        float weight = this.getWeight();
        if (weight > 40.0f) {
            float attenuation = (float)Mth.m_14045_((int)((Player)this.getOriginal()).m_9236_().m_46469_().m_46215_(EpicFightGamerules.WEIGHT_PENALTY), (int)0, (int)100) / 100.0f;
            return event.getAttackSpeed() + -0.1f * (weight / 40.0f) * Math.max(event.getAttackSpeed() - 0.8f, 0.0f) * attenuation;
        }
        return event.getAttackSpeed();
    }

    public double getWeaponAttribute(Attribute attribute, ItemStack itemstack) {
        AttributeInstance attrInstance = new AttributeInstance(attribute, ai -> {});
        Set<AttributeModifier> itemModifiers = Set.copyOf(CapabilityItem.getAttributeModifiers(attribute, EquipmentSlot.MAINHAND, itemstack, this));
        Set<AttributeModifier> mainhandModifiers = Set.copyOf(CapabilityItem.getAttributeModifiers(attribute, EquipmentSlot.MAINHAND, ((Player)this.original).m_21205_(), this));
        double baseValue = ((Player)this.original).m_21051_(attribute) == null ? attribute.m_22082_() : ((Player)this.original).m_21051_(attribute).m_22115_();
        attrInstance.m_22100_(baseValue);
        for (AttributeModifier modifier : ((Player)this.original).m_21051_(attribute).m_22122_()) {
            if (itemModifiers.contains(modifier) || mainhandModifiers.contains(modifier)) continue;
            attrInstance.m_22118_(modifier);
        }
        for (AttributeModifier modifier : itemModifiers) {
            if (attrInstance.m_22109_(modifier)) continue;
            attrInstance.m_22118_(modifier);
        }
        CapabilityItem itemCapability = EpicFightCapabilities.getItemStackCapabilityOr(itemstack, null);
        if (itemCapability != null) {
            for (AttributeModifier modifier : itemCapability.getAttributeModifiers(EquipmentSlot.MAINHAND, this).get((Object)attribute)) {
                if (attrInstance.m_22109_(modifier)) continue;
                attrInstance.m_22118_(modifier);
            }
        }
        return attrInstance.m_22135_();
    }

    @Override
    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        float fallDist = ((Player)this.original).f_19789_;
        boolean onGround = ((Player)this.original).f_19861_;
        boolean offhandValid = this.isOffhandItemValid();
        ItemStack mainHandItem = ((Player)this.getOriginal()).m_21205_();
        ItemStack offHandItem = ((Player)this.getOriginal()).m_21206_();
        List<AttributeModifier> mainHandAttributes = CapabilityItem.getAttributeModifiers(Attributes.f_22281_, EquipmentSlot.MAINHAND, ((Player)this.original).m_21205_(), this);
        Set<AttributeModifier> offHandAttributes = this.isOffhandItemValid() ? CapabilityItem.getAttributeModifiers(Attributes.f_22281_, EquipmentSlot.MAINHAND, ((Player)this.original).m_21206_(), this) : Set.of();
        this.epicFightDamageSource = damageSource;
        ((Player)this.original).f_20922_ = Integer.MAX_VALUE;
        ((Player)this.original).f_19789_ = 0.0f;
        ((Player)this.original).f_19861_ = false;
        this.setOffhandDamage(hand, mainHandItem, offHandItem, offhandValid, mainHandAttributes, offHandAttributes);
        ((Player)this.original).m_5706_(target);
        this.recoverMainhandDamage(hand, mainHandItem, offHandItem, mainHandAttributes, offHandAttributes);
        this.epicFightDamageSource = null;
        ((Player)this.original).f_19789_ = fallDist;
        ((Player)this.original).f_19861_ = onGround;
        return super.attack(damageSource, target, hand);
    }

    @Override
    public EpicFightDamageSource getDamageSource(StaticAnimation animation, InteractionHand hand) {
        EpicFightDamageSources damageSources = EpicFightDamageSources.of(((Player)this.original).m_9236_());
        EpicFightDamageSource damagesource = damageSources.playerAttack((Player)this.original).setAnimation(animation);
        damagesource.setImpact(this.getImpact(hand));
        damagesource.setArmorNegation(this.getArmorNegation(hand));
        damagesource.setHurtItem(((Player)this.getOriginal()).m_21120_(hand));
        damagesource.setBasicAttack((Boolean)this.getSkill(SkillSlots.BASIC_ATTACK).getDataManager().getDataValue((SkillDataKey)SkillDataKeys.BASIC_ATTACK_ACTIVATE.get()));
        return damagesource;
    }

    @Override
    public void cancelAnyAction() {
        super.cancelAnyAction();
        this.resetSkillCharging();
    }

    public float getMaxStamina() {
        AttributeInstance maxStamina = ((Player)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STAMINA.get());
        return (float)(maxStamina == null ? 0.0 : maxStamina.m_22135_());
    }

    public float getStamina() {
        return this.getMaxStamina() <= 0.0f ? 0.0f : (((Player)this.original).m_20088_().m_285897_(STAMINA) ? ((Float)((Player)this.original).m_20088_().m_135370_(STAMINA)).floatValue() : 0.0f);
    }

    public float getModifiedStaminaConsume(float amount) {
        float attenuation = (float)Mth.m_14045_((int)((Player)this.original).m_9236_().m_46469_().m_46215_(EpicFightGamerules.WEIGHT_PENALTY), (int)0, (int)100) / 100.0f;
        float weight = this.getWeight();
        return ((weight / 40.0f - 1.0f) * attenuation + 1.0f) * amount;
    }

    public boolean hasStamina(float amount) {
        return this.getStamina() > amount;
    }

    public void setStamina(float value) {
        if (((Player)this.original).m_20088_().m_285897_(STAMINA)) {
            float f1 = Mth.m_14036_((float)value, (float)0.0f, (float)this.getMaxStamina());
            ((Player)this.original).m_20088_().m_135381_(STAMINA, (Object)Float.valueOf(f1));
        }
    }

    public boolean consumeForSkill(Skill skill, Skill.Resource consumeResource) {
        return this.consumeForSkill(skill, consumeResource, skill.getDefaultConsumptionAmount(this));
    }

    public boolean consumeForSkill(Skill skill, Skill.Resource consumeResource, float amount) {
        return this.consumeForSkill(skill, consumeResource, amount, false);
    }

    public boolean consumeForSkill(Skill skill, Skill.Resource consumeResource, float amount, boolean activateConsumeForce) {
        SkillConsumeEvent skillConsumeEvent = new SkillConsumeEvent(this, skill, consumeResource, amount);
        this.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, skillConsumeEvent);
        if (skillConsumeEvent.isCanceled()) {
            return false;
        }
        if (skillConsumeEvent.getResourceType().predicate.canExecute(skill, this, amount)) {
            if (!this.isLogicalClient()) {
                skillConsumeEvent.getResourceType().consumer.consume(skill, (ServerPlayerPatch)this, amount);
            }
            return true;
        }
        if (activateConsumeForce && !this.isLogicalClient()) {
            skillConsumeEvent.getResourceType().consumer.consume(skill, (ServerPlayerPatch)this, amount);
        }
        return false;
    }

    public void resetActionTick() {
        this.tickSinceLastAction = 0;
    }

    public int getTickSinceLastAction() {
        return this.tickSinceLastAction;
    }

    public void startSkillCharging(ChargeableSkill chargingSkill) {
        chargingSkill.startCharging(this);
        this.lastChargingTick = ((Player)this.original).f_19797_;
        this.chargingSkill = chargingSkill;
    }

    public void resetSkillCharging() {
        if (this.chargingSkill != null) {
            this.chargingAmount = 0;
            this.chargingSkill.resetCharging(this);
            this.chargingSkill = null;
        }
    }

    public boolean isChargingSkill() {
        return this.chargingSkill != null;
    }

    public boolean isChargingSkill(Skill chargingSkill) {
        return this.chargingSkill == chargingSkill;
    }

    public int getLastChargingTick() {
        return this.lastChargingTick;
    }

    public void setChargingAmount(int amount) {
        this.chargingAmount = this.isChargingSkill() ? Math.min(amount, this.getChargingSkill().getMaxChargingTicks()) : 0;
    }

    public int getChargingAmount() {
        return this.chargingAmount;
    }

    public float getSkillChargingTicks(float partialTicks) {
        return this.isChargingSkill() ? (float)(((Player)this.original).f_19797_ - this.getLastChargingTick()) - 1.0f + partialTicks : 0.0f;
    }

    public int getSkillChargingTicks() {
        return this.isChargingSkill() ? Math.min(((Player)this.original).f_19797_ - this.getLastChargingTick(), this.chargingSkill.getMaxChargingTicks()) : 0;
    }

    public int getAccumulatedChargeAmount() {
        return this.getChargingSkill() != null ? this.getChargingSkill().getChargingAmount(this) : 0;
    }

    public ChargeableSkill getChargingSkill() {
        return this.chargingSkill;
    }

    public boolean isInAir() {
        return ((Player)this.original).m_21255_() || this.currentLivingMotion == LivingMotions.FALL;
    }

    @Override
    public boolean shouldMoveOnCurrentSide(ActionAnimation actionAnimation) {
        return this.isLogicalClient();
    }

    public void openSkillBook(ItemStack itemstack, InteractionHand hand) {
    }

    @Override
    public void onFall(LivingFallEvent event) {
        FallEvent fallEvent = new FallEvent(this, event);
        this.getEventListener().triggerEvents(PlayerEventListener.EventType.FALL_EVENT, fallEvent);
        super.onFall(event);
        this.setAirborneState(false);
    }

    public void toggleMode() {
        switch (this.playerMode) {
            case MINING: {
                this.toBattleMode(true);
                break;
            }
            case BATTLE: {
                this.toMiningMode(true);
            }
        }
    }

    public void toMode(PlayerMode playerMode, boolean synchronize) {
        switch (playerMode) {
            case MINING: {
                this.toMiningMode(synchronize);
                break;
            }
            case BATTLE: {
                this.toBattleMode(synchronize);
            }
        }
    }

    public PlayerMode getPlayerMode() {
        return this.playerMode;
    }

    public void toMiningMode(boolean synchronize) {
        ChangePlayerModeEvent prepareModelEvent;
        if (this.playerMode == PlayerMode.MINING) {
            return;
        }
        if (this.battleModeRestricted) {
            this.battleModeRestricted = false;
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)(prepareModelEvent = new ChangePlayerModeEvent(this, PlayerMode.MINING)))) {
            this.playerMode = prepareModelEvent.getPlayerMode();
        }
    }

    public void toBattleMode(boolean synchronize) {
        if (this.playerMode == PlayerMode.BATTLE) {
            return;
        }
        ChangePlayerModeEvent prepareModelEvent = new ChangePlayerModeEvent(this, PlayerMode.BATTLE);
        if (!MinecraftForge.EVENT_BUS.post((Event)prepareModelEvent)) {
            this.playerMode = prepareModelEvent.getPlayerMode();
        }
    }

    public boolean isBattleMode() {
        return this.playerMode == PlayerMode.BATTLE;
    }

    @Override
    public double getXOld() {
        return this.xo;
    }

    @Override
    public double getYOld() {
        return this.yo;
    }

    @Override
    public double getZOld() {
        return this.zo;
    }

    @Override
    public float getYRot() {
        return this.modelYRot;
    }

    @Override
    public void setYRot(float yRot) {
        if (this.useModelYRot) {
            this.setModelYRot(yRot, true);
        } else {
            ((Player)this.original).m_146922_(yRot);
        }
    }

    @Override
    public float getYRotLimit() {
        return 180.0f;
    }

    @Override
    public StaticAnimation getHitAnimation(StunType stunType) {
        if (((Player)this.original).m_20202_() != null) {
            return Animations.BIPED_HIT_ON_MOUNT;
        }
        return switch (stunType) {
            case StunType.LONG -> Animations.BIPED_HIT_LONG;
            case StunType.SHORT, StunType.HOLD -> Animations.BIPED_HIT_SHORT;
            case StunType.KNOCKDOWN -> Animations.BIPED_KNOCKDOWN;
            case StunType.NEUTRALIZE -> Animations.BIPED_COMMON_NEUTRALIZED;
            case StunType.FALL -> Animations.BIPED_LANDING;
            case StunType.NONE -> null;
            default -> null;
        };
    }

    static {
        PLAYER_EVENT_UUID = UUID.fromString("e6beeac4-77d2-11eb-9439-0242ac130002");
    }

    public static enum PlayerMode {
        MINING,
        BATTLE;

    }
}

