/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fairtrade.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.fairtrade.FairTradeMod;
import net.mcreator.fairtrade.procedures.DeincrementCurrencyValueProcedure;
import net.mcreator.fairtrade.procedures.IncrementCurrencyValueProcedure;
import net.mcreator.fairtrade.procedures.Minus100CurrencyValueProcedure;
import net.mcreator.fairtrade.procedures.Minus10CurrencyValueProcedure;
import net.mcreator.fairtrade.procedures.Plus100CurrencyValueProcedure;
import net.mcreator.fairtrade.procedures.Plus10CurrencyValueProcedure;
import net.mcreator.fairtrade.procedures.ResetTotalValueProcedure;
import net.mcreator.fairtrade.world.inventory.MoneyCounterGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MoneyCounterGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public MoneyCounterGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public MoneyCounterGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(MoneyCounterGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(MoneyCounterGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            MoneyCounterGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = MoneyCounterGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ResetTotalValueProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            Plus100CurrencyValueProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            Minus100CurrencyValueProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            Plus10CurrencyValueProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            Minus10CurrencyValueProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            DeincrementCurrencyValueProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            IncrementCurrencyValueProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        FairTradeMod.addNetworkMessage(MoneyCounterGUIButtonMessage.class, MoneyCounterGUIButtonMessage::buffer, MoneyCounterGUIButtonMessage::new, MoneyCounterGUIButtonMessage::handler);
    }
}

