/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.events;

import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import xyz.apex.forge.fantasyfurniture.AllParticleTypes;
import xyz.apex.forge.fantasyfurniture.core.ModInitializer;
import xyz.apex.forge.fantasyfurniture.core.data.ParticleProvider;
import xyz.apex.forge.fantasyfurniture.core.net.C2SSyncSelectedResultPacket;

@Mod.EventBusSubscriber(modid="fantasyfurniture", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class CommonModEvents {
    private static final String OPTIFINE_ID = "optifine";

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        ModInitializer.NETWORK.registerPacket(C2SSyncSelectedResultPacket.class);
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        boolean includeClient = event.includeClient();
        generator.addProvider(includeClient, (DataProvider)new ParticleProvider(generator.getPackOutput(), event.getLookupProvider(), event.getExistingFileHelper()){

            @Override
            public void registerParticleDefs() {
                this.definition((ParticleType)AllParticleTypes.SMALL_SOUL_FLAME.get()).texture((ParticleType<?>)ParticleTypes.f_123745_);
                this.definition((ParticleType)AllParticleTypes.NECROLORD_FLAME.get()).texture((ParticleType)AllParticleTypes.NECROLORD_FLAME.get());
                this.definition((ParticleType)AllParticleTypes.SMALL_NECROLORD_FLAME.get()).texture((ParticleType)AllParticleTypes.NECROLORD_FLAME.get());
            }
        });
    }

    @SubscribeEvent
    public static void onRegisterPackFinders(AddPackFindersEvent event) {
        CommonModEvents.registerBuiltInPack(event, "ctm");
        CommonModEvents.registerBuiltInPack(event, "xycraft_core");
    }

    private static void registerBuiltInPack(AddPackFindersEvent event, String modId) {
        boolean modLoaded;
        boolean bl = modLoaded = modId.equals(OPTIFINE_ID) ? CommonModEvents.isOptifineInstalled() : ModList.get().isLoaded(modId);
        if (modLoaded) {
            event.addRepositorySource(consumer -> consumer.accept(Pack.m_245429_((String)"%s:builtin/mod_support/%s".formatted("fantasyfurniture", modId), (Component)Component.m_237113_((String)"Fantasy's Furniture Mod-Support-Pack"), (boolean)false, path -> new PathPackResources(path, ModList.get().getModFileById("fantasyfurniture").getFile().findResource(new String[]{"mod_support", modId}), true), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_)));
        }
    }

    private static boolean isOptifineInstalled() {
        if (ModList.get().isLoaded(OPTIFINE_ID)) {
            return true;
        }
        try {
            Class.forName("net.optifine.ConnectedTextures");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

