/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.food;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import dev.xkmc.fruitsdelight.content.cauldrons.CauldronDispenseBehavior;
import dev.xkmc.fruitsdelight.content.cauldrons.CauldronRecipe;
import dev.xkmc.fruitsdelight.content.cauldrons.CauldronRenderHandler;
import dev.xkmc.fruitsdelight.content.cauldrons.FDCauldronBlock;
import dev.xkmc.fruitsdelight.content.cauldrons.FDCauldronInteraction;
import dev.xkmc.fruitsdelight.content.cauldrons.FruitCauldronBlock;
import dev.xkmc.fruitsdelight.content.cauldrons.JellyCauldronBlock;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.food.FDFood;
import dev.xkmc.fruitsdelight.init.food.FruitType;
import dev.xkmc.fruitsdelight.init.registrate.FDItems;
import java.util.Locale;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.ItemModelBuilder;

public class FDCauldrons {
    public static final BlockEntry<FDCauldronBlock> LEMON = FDCauldrons.simple("lemonade_cauldron", FDCauldronBlock::new);
    public static final BlockEntry<FruitCauldronBlock>[] FRUIT;
    public static final BlockEntry<JellyCauldronBlock>[] JELLY;
    public static final BlockEntry<JellyCauldronBlock>[] JELLO;
    public static final ItemEntry<Item> FAKE_CAULDRON;

    public static void register() {
    }

    public static void init() {
        CauldronRecipe.create(CauldronInteraction.f_175607_, (Item)FAKE_CAULDRON.get(), (Item)FDFood.LEMON_SLICE.item.get(), FDCauldronInteraction.of(state -> (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3 ? ((FDCauldronBlock)((Object)((Object)LEMON.get()))).m_49966_() : null), ((FDCauldronBlock)((Object)LEMON.get())).m_5456_());
        IntegerProperty fruitProp = FruitCauldronBlock.LEVEL;
        IntegerProperty jellyProp = JellyCauldronBlock.LEVEL;
        int max = 12;
        for (FruitType type : FruitType.values()) {
            int level = 4 / type.jellyCost;
            int index = type.ordinal();
            FruitCauldronBlock fruit = (FruitCauldronBlock)((Object)FRUIT[index].get());
            JellyCauldronBlock jelly = (JellyCauldronBlock)((Object)JELLY[index].get());
            JellyCauldronBlock jello = (JellyCauldronBlock)((Object)JELLO[index].get());
            CauldronRecipe.create(CauldronInteraction.f_175607_, (Item)FAKE_CAULDRON.get(), type.getJelly(), 3, FDCauldronInteraction.of(state -> (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3 ? (BlockState)fruit.m_49966_().m_61124_((Property)fruitProp, (Comparable)Integer.valueOf(4)) : null), fruit.m_5456_());
            CauldronRecipe.create((FDCauldronBlock)((Object)LEMON.get()), type.getFruit(), 12 / level, FDCauldronInteraction.withHeat(state -> (BlockState)fruit.m_49966_().m_61124_((Property)fruitProp, (Comparable)Integer.valueOf(level))), fruit.m_5456_());
            fruit.getInteractions().put(type.getFruit(), FDCauldronInteraction.withHeat(state -> (Integer)state.m_61143_((Property)fruitProp) == max ? null : (BlockState)state.m_61124_((Property)fruitProp, (Comparable)Integer.valueOf(Math.min(max, (Integer)state.m_61143_((Property)fruitProp) + level)))));
            fruit.getInteractions().put(type.getJelly(), FDCauldronInteraction.of(state -> (Integer)state.m_61143_((Property)fruitProp) == max ? null : (BlockState)state.m_61124_((Property)fruitProp, (Comparable)Integer.valueOf(Math.min(max, (Integer)state.m_61143_((Property)fruitProp) + 4)))));
            CauldronRecipe.create(fruit, Items.f_42501_, 1, FDCauldronInteraction.withHeat(state -> (Integer)state.m_61143_((Property)fruitProp) == max ? jelly.m_49966_() : null), jelly.m_5456_());
            CauldronRecipe.create(jelly, Items.f_42518_, 1, FDCauldronInteraction.withHeat(state -> (BlockState)jello.m_49966_().m_61124_((Property)jellyProp, (Comparable)((Integer)state.m_61143_((Property)jellyProp)))), jello.m_5456_());
            CauldronRecipe.empty(jelly, Items.f_42590_, 3, FDCauldronInteraction.of(state -> (Integer)state.m_61143_((Property)jellyProp) == 1 ? Blocks.f_50256_.m_49966_() : (BlockState)state.m_61124_((Property)jellyProp, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)jellyProp) - 1)), type.getJelly().m_7968_(), SoundEvents.f_11770_), Items.f_42544_);
            CauldronRecipe.empty(jello, Items.f_42399_, 3, FDCauldronInteraction.of(state -> (Integer)state.m_61143_((Property)jellyProp) == 1 ? Blocks.f_50256_.m_49966_() : (BlockState)state.m_61124_((Property)jellyProp, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)jellyProp) - 1)), type.getJello().m_7968_(), SoundEvents.f_11770_), Items.f_42544_);
            DispenserBlock.m_52672_((ItemLike)type.getJelly(), (DispenseItemBehavior)new CauldronDispenseBehavior());
        }
        DispenserBlock.m_52672_((ItemLike)((ItemLike)FDFood.LEMON_SLICE.item.get()), (DispenseItemBehavior)new CauldronDispenseBehavior());
    }

    private static <T extends FDCauldronBlock> BlockEntry<T> simple(String id, NonNullFunction<BlockBehaviour.Properties, T> factory) {
        return ((BlockBuilder)FruitsDelight.REGISTRATE.block(id, p -> (FDCauldronBlock)((Object)((Object)factory.apply((Object)BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152476_))))).blockstate((ctx, pvd) -> ((FDCauldronBlock)((Object)((Object)ctx.get()))).build(ctx, (RegistrateBlockstateProvider)pvd)).loot((pvd, block) -> pvd.m_246125_((Block)block, (ItemLike)Items.f_42544_)).color(() -> () -> CauldronRenderHandler::getBlockColor).item().removeTab(FruitsDelight.TAB.getKey()).color(() -> () -> CauldronRenderHandler::getItemColor).build()).lang(FDItems.toEnglishName(id).replaceAll("Jelly", "Jam")).tag(new TagKey[]{BlockTags.f_144269_}).register();
    }

    static {
        int size = FruitType.values().length;
        FRUIT = new BlockEntry[size];
        JELLY = new BlockEntry[size];
        JELLO = new BlockEntry[size];
        for (int i = 0; i < size; ++i) {
            FruitType type = FruitType.values()[i];
            String name = type.name().toLowerCase(Locale.ROOT);
            FDCauldrons.FRUIT[i] = FDCauldrons.simple(name + "_cauldron", properties -> new FruitCauldronBlock((BlockBehaviour.Properties)properties, type));
            FDCauldrons.JELLY[i] = FDCauldrons.simple(name + "_jelly_cauldron", properties -> new JellyCauldronBlock((BlockBehaviour.Properties)properties, type));
            FDCauldrons.JELLO[i] = FDCauldrons.simple(name + "_jello_cauldron", properties -> new JellyCauldronBlock((BlockBehaviour.Properties)properties, type));
        }
        FAKE_CAULDRON = FruitsDelight.REGISTRATE.item("dummy_cauldron", Item::new).lang("Water Cauldron").model((ctx, pvd) -> CauldronRenderHandler.gui((ItemModelBuilder)pvd.withExistingParent(ctx.getName(), "block/water_cauldron_full"))).color(() -> () -> CauldronRenderHandler::getItemColor).removeTab(FruitsDelight.TAB.getKey()).register();
    }
}

