/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.food;

import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.fruitsdelight.content.item.FDFoodItem;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.data.TagGen;
import dev.xkmc.fruitsdelight.init.food.EffectEntry;
import dev.xkmc.fruitsdelight.init.food.FoodType;
import dev.xkmc.fruitsdelight.init.food.FruitType;
import dev.xkmc.fruitsdelight.init.food.IFDFood;
import dev.xkmc.fruitsdelight.init.registrate.FDItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.registry.ModEffects;

public enum FDFood implements IFDFood
{
    BLUEBERRY_CUSTARD(FruitType.BLUEBERRY, FoodType.CREAM, new EffectEntry[0]),
    BLUEBERRY_MUFFIN(FruitType.BLUEBERRY, FoodType.DESSERT, new EffectEntry[0]),
    CRANBERRY_MUFFIN(FruitType.CRANBERRY, FoodType.DESSERT, new EffectEntry[0]),
    FIG_PUDDING_SLICE(FruitType.FIG, FoodType.ROLL, new EffectEntry[0]),
    HAMIMELON_POPSICLE(FruitType.HAMIMELON, FoodType.STICK, new EffectEntry[0]),
    KIWI_POPSICLE(FruitType.KIWI, FoodType.STICK, new EffectEntry[0]),
    HAMIMELON_SHAVED_ICE(FruitType.HAMIMELON, FoodType.JUICE, new EffectEntry[0]),
    HAWBERRY_ROLL(FruitType.HAWBERRY, FoodType.ROLL, 0),
    HAWBERRY_SHEET(FruitType.HAWBERRY, FoodType.SHEET, new EffectEntry[0]),
    HAWBERRY_STICK(FruitType.HAWBERRY, FoodType.STICK, new EffectEntry[0]),
    ORANGE_SLICE(FruitType.ORANGE, FoodType.SLICE, new EffectEntry[0]),
    LEMON_SLICE(FruitType.LEMON, FoodType.SLICE, new EffectEntry[0]),
    DURIAN_FLESH(FruitType.DURIAN, FoodType.DURIAN_FLESH, new EffectEntry[0]),
    BAKED_PEAR(FruitType.PEAR, FoodType.FRUIT, new EffectEntry[0]),
    BAKED_DURIAN(FruitType.DURIAN, FoodType.FRUIT, new EffectEntry[0]),
    PINEAPPLE_PIE(FruitType.PINEAPPLE, FoodType.DESSERT, new EffectEntry[0]),
    DURIAN_PIE(FruitType.DURIAN, FoodType.DESSERT, new EffectEntry[0]),
    LEMON_TART(FruitType.LEMON, FoodType.DESSERT, new EffectEntry[0]),
    FIG_TART(FruitType.FIG, FoodType.DESSERT, new EffectEntry[0]),
    MANGO_MILKSHAKE(FruitType.MANGO, FoodType.JUICE, new EffectEntry[0]),
    MANGO_SALAD(FruitType.MANGO, FoodType.BOWL, 0),
    DRIED_PERSIMMON(FruitType.PERSIMMON, FoodType.FRUIT, new EffectEntry[0]),
    PERSIMMON_COOKIE(FruitType.PERSIMMON, FoodType.COOKIE, new EffectEntry[0]),
    LEMON_COOKIE(FruitType.LEMON, FoodType.COOKIE, new EffectEntry[0]),
    CRANBERRY_COOKIE(FruitType.CRANBERRY, FoodType.COOKIE, new EffectEntry[0]),
    BAYBERRY_COOKIE(FruitType.BAYBERRY, FoodType.COOKIE, new EffectEntry[0]),
    MANGOSTEEN_CAKE(FoodType.MANGOSTEEN_CAKE, FruitType.MANGOSTEEN, new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 1200)),
    PEAR_WITH_ROCK_SUGAR(FruitType.PEAR, FoodType.BOWL, new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 1200)),
    ORANGE_CHICKEN(FruitType.ORANGE, FoodType.MEAL, new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600)),
    FIG_CHICKEN_STEW(FruitType.FIG, FoodType.MEAL, new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600)),
    ORANGE_MARINATED_PORK(FruitType.ORANGE, FoodType.MEAL, new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600)),
    BOWL_OF_PINEAPPLE_FRIED_RICE(FruitType.PINEAPPLE, FoodType.STAPLE, new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 6000)),
    PINEAPPLE_MARINATED_PORK(FruitType.PINEAPPLE, FoodType.MEAL, new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600)),
    LYCHEE_CHICKEN(FruitType.LYCHEE, FoodType.MEAL, new EffectEntry((Supplier<MobEffect>)ModEffects.NOURISHMENT, 3600)),
    JELLY_BREAD(FruitType.SWEETBERRY, FoodType.SWEET, 1);

    private final String name;
    public final FruitType fruit;
    public final FoodType type;
    public final ItemEntry<Item> item;
    public final EffectEntry[] effs;

    private FDFood(boolean allowJelly, int overlay, @Nullable FruitType fruit, FoodType food, String str, EffectEntry ... effs) {
        this.fruit = fruit;
        this.type = food;
        this.name = this.name().toLowerCase(Locale.ROOT);
        this.item = ((ItemBuilder)FruitsDelight.REGISTRATE.item(this.name, p -> food.build((Item.Properties)p, this)).transform(b -> food.model(b, overlay, fruit))).lang(str != null ? str : FDItems.toEnglishName(this.name)).tag(this.getTags(allowJelly, food.tags)).register();
        this.effs = effs;
    }

    private FDFood(FruitType fruit, FoodType food, EffectEntry ... effs) {
        this(false, 0, fruit, food, null, effs);
    }

    private FDFood(FoodType food, FruitType fruit, EffectEntry ... effs) {
        this.fruit = fruit;
        this.type = food;
        this.name = this.name().toLowerCase(Locale.ROOT);
        this.item = ((ItemBuilder)FruitsDelight.REGISTRATE.item(this.name, p -> food.build((Item.Properties)p, this)).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx)).setData(ProviderType.LANG, NonNullBiConsumer.noop())).tag(this.getTags(false, food.tags)).register();
        this.effs = effs;
    }

    private FDFood(FruitType fruit, FoodType food, String str) {
        this(false, 0, fruit, food, str, new EffectEntry[0]);
    }

    private FDFood(FruitType fruit, FoodType food, int overlay) {
        this(true, overlay, fruit, food, null, new EffectEntry[0]);
    }

    private TagKey<Item>[] getTags(boolean allowJelly, TagKey<Item>[] tags) {
        ArrayList<TagKey<Item>> ans = new ArrayList<TagKey<Item>>(Arrays.stream(tags).toList());
        if (allowJelly) {
            ans.add(TagGen.ALLOW_JELLY);
        }
        return (TagKey[])ans.toArray(TagKey[]::new);
    }

    public static void register() {
    }

    public Ingredient getFruitTag() {
        return this.fruit.getFruitTag();
    }

    public FDFoodItem get() {
        return (FDFoodItem)this.item.get();
    }

    @Override
    public FruitType fruit() {
        return this.fruit;
    }

    @Override
    public FoodType getType() {
        return this.type;
    }

    @Override
    public EffectEntry[] getEffects() {
        return this.effs;
    }

    public Item getFruit() {
        return this.fruit.getFruit();
    }
}

