/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.plants;

import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.fruitsdelight.content.block.BaseBushBlock;
import dev.xkmc.fruitsdelight.content.block.BushFruitItem;
import dev.xkmc.fruitsdelight.content.block.FruitBushBlock;
import dev.xkmc.fruitsdelight.content.item.FDFoodItem;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.plants.FDBushType;
import dev.xkmc.fruitsdelight.init.plants.FruitPlant;
import dev.xkmc.fruitsdelight.init.plants.PlantDataEntry;
import dev.xkmc.l2library.util.data.LootTableTemplate;
import java.util.List;
import java.util.Locale;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;

public enum FDBushes implements FruitPlant<FDBushes>
{
    BLUEBERRY(2, 0.3f, true, 32, FDBushType.BLOCK),
    LEMON(4, 0.3f, false, 32, FDBushType.TALL),
    CRANBERRY(2, 0.3f, true, 32, FDBushType.CROSS);

    private final BlockEntry<? extends BushBlock> bush;
    private final ItemEntry<BushFruitItem> seedItem;
    private final ItemEntry<FDFoodItem> mid;
    private final int rarity;
    private final FDBushType type;
    public final ResourceKey<ConfiguredFeature<?, ?>> configKey;
    public final ResourceKey<PlacedFeature> placementKey;

    private FDBushes(int food, float sat, boolean fast, int rarity, FDBushType type) {
        String name = this.name().toLowerCase(Locale.ROOT);
        String suffix = type == FDBushType.TALL ? "tree" : "bush";
        this.configKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("fruitsdelight", name + "_" + suffix));
        this.placementKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("fruitsdelight", name + "_" + suffix));
        this.rarity = rarity;
        this.type = type;
        this.bush = type.build(name + "_" + suffix, this);
        if (type == FDBushType.TALL) {
            this.mid = ((ItemBuilder)FruitsDelight.REGISTRATE.item(name, p -> new FDFoodItem(p.m_41489_(FDBushes.food(food, sat, fast)), null)).transform(b -> PlantDataEntry.addFruitTags(name, b))).register();
            this.seedItem = FruitsDelight.REGISTRATE.item(name + "_seeds", p -> new BushFruitItem((Block)this.getBush(), (Item.Properties)p)).register();
        } else {
            this.mid = null;
            this.seedItem = ((ItemBuilder)FruitsDelight.REGISTRATE.item(name, p -> new BushFruitItem((Block)this.getBush(), p.m_41489_(FDBushes.food(food, sat, fast)))).transform(b -> PlantDataEntry.addFruitTags(name, b))).register();
        }
    }

    @Override
    public void registerComposter() {
        if (this.type == FDBushType.TALL) {
            ComposterBlock.f_51914_.put((Object)((ItemLike)this.mid.get()), 0.35f);
        }
        ComposterBlock.f_51914_.put((Object)((ItemLike)this.seedItem.get()), 0.15f);
        if (this.type != FDBushType.CROSS) {
            ComposterBlock.f_51914_.put((Object)this.getBush().m_5456_(), 0.65f);
        }
    }

    @Override
    public void registerConfigs(BootstapContext<ConfiguredFeature<?, ?>> ctx) {
        BlockState state = (BlockState)this.getBush().m_49966_().m_61124_((Property)BaseBushBlock.AGE, (Comparable)Integer.valueOf(4));
        FeatureUtils.m_254977_(ctx, this.configKey, (Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state)), List.of(Blocks.f_50440_), (int)20));
    }

    @Override
    public void registerPlacements(BootstapContext<PlacedFeature> ctx) {
        ctx.m_255272_(this.placementKey, (Object)new PlacedFeature((Holder)ctx.m_255420_(Registries.f_256911_).m_255043_(this.configKey), List.of(RarityFilter.m_191900_((int)this.rarity), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
    }

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public ResourceKey<PlacedFeature> getPlacementKey() {
        return this.placementKey;
    }

    @Override
    public void genRecipe(RegistrateRecipeProvider pvd) {
        if (this.mid != null) {
            pvd.singleItem(DataIngredient.items((ItemLike)((FDFoodItem)this.mid.get()), (ItemLike[])new FDFoodItem[0]), RecipeCategory.MISC, this.seedItem, 1, 1);
        }
    }

    public void buildLoot(RegistrateBlockLootTables pvd, BushBlock block) {
        LootPool.Builder pool;
        LootTable.Builder table = LootTable.m_79147_();
        if (this.type != FDBushType.CROSS) {
            pool = LootPool.m_79043_().m_79076_(((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)this.getBush().m_5456_()).m_79080_(LootTableTemplate.silk((boolean)false))).m_79080_(LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)FruitBushBlock.AGE, 0)).m_285888_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)FruitBushBlock.AGE, 1))).m_81807_())).m_79080_(ExplosionCondition.m_81661_());
            table.m_79161_(pool);
        }
        pool = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)this.getFruit()).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)FruitBushBlock.AGE, 4)))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)1))).m_79080_(ExplosionCondition.m_81661_());
        if (this.type == FDBushType.TALL) {
            pool.m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER)));
        }
        table.m_79161_(pool);
        pvd.m_247577_((Block)block, table);
    }

    public BushBlock getBush() {
        return (BushBlock)this.bush.get();
    }

    @Override
    public Item getFruit() {
        return this.type == FDBushType.TALL ? (Item)this.mid.get() : (Item)this.seedItem.get();
    }

    public Item getSeed() {
        return (Item)this.seedItem.get();
    }

    public void buildBushModel(DataGenContext<Block, ? extends BushBlock> ctx, RegistrateBlockstateProvider pvd) {
        if (this.type == FDBushType.CROSS) {
            pvd.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
                int age = (Integer)state.m_61143_((Property)FruitBushBlock.AGE);
                Object id = ctx.getName();
                if (age == 1) {
                    return ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("block/" + (String)id + "_0"))).build();
                }
                id = (String)id + "_" + (age == 0 ? 0 : age - 1);
                BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)pvd.models().cross((String)id, pvd.modLoc("block/" + (String)id))).renderType("cutout");
                return ConfiguredModel.builder().modelFile((ModelFile)model).build();
            });
            return;
        }
        boolean tall = this.type == FDBushType.TALL;
        pvd.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)FruitBushBlock.AGE);
            Object id = ctx.getName();
            if (tall && state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)pvd.models().withExistingParent((String)id + "_upper", pvd.mcLoc("block/air"))).texture("particle", pvd.modLoc("block/" + (String)id + "_top"))).build();
            }
            Object parent = "bush";
            if (tall) {
                parent = "tall_" + (String)parent;
            }
            if (age == 0) {
                id = (String)id + "_small";
                parent = (String)parent + "_small";
            }
            if (age == 1) {
                if (tall) {
                    id = (String)id + "_mid";
                    parent = (String)parent + "_mid";
                } else {
                    return ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("block/" + (String)id + "_small"))).build();
                }
            }
            if (age == 3) {
                id = (String)id + "_flowers";
            }
            if (age == 4) {
                id = (String)id + "_fruits";
            }
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder((String)id)).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("block/" + (String)parent)));
            model.texture("face", "block/" + (String)id + "_face");
            model.texture("cross", "block/" + (String)id + "_cross");
            if (tall) {
                model.texture("top", "block/" + (String)id + "_top");
            }
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
    }

    private static FoodProperties food(int food, float sat, boolean fast) {
        FoodProperties.Builder ans = new FoodProperties.Builder().m_38760_(food).m_38758_(sat);
        if (fast) {
            ans.m_38766_();
        }
        return ans.m_38767_();
    }

    public static void register() {
    }
}

