/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.block;

import com.mojang.datafixers.util.Pair;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import dev.xkmc.fruitsdelight.content.block.BaseLeavesBlock;
import dev.xkmc.fruitsdelight.content.block.PassableLeavesBlock;
import dev.xkmc.fruitsdelight.init.data.FDModConfig;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;

public class PeachLeavesBlock
extends PassableLeavesBlock {
    public static final BooleanProperty FERTILE = BooleanProperty.m_61465_((String)"fertile");

    public PeachLeavesBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FERTILE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FERTILE});
        super.m_7926_(builder);
    }

    private List<BlockPos> scanLeaves(Level level, BlockPos pos) {
        ArrayList<BlockPos> ans = new ArrayList<BlockPos>();
        BlockState state = level.m_8055_(pos);
        if (!state.m_60713_((Block)this)) {
            return ans;
        }
        int dist = (Integer)state.m_61143_((Property)f_54418_);
        if (dist > 1) {
            return ans;
        }
        BlockState log = level.m_8055_(pos = pos.m_7495_());
        if (!log.m_204336_(BlockTags.f_13106_)) {
            return ans;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        queue.add(Pair.of((Object)-1, (Object)pos));
        while (!queue.isEmpty()) {
            Pair e = (Pair)queue.poll();
            for (Direction dir : Direction.values()) {
                int ndis;
                BlockPos npos = ((BlockPos)e.getSecond()).m_121945_(dir);
                if (visited.contains(npos)) continue;
                visited.add(npos);
                BlockState nst = level.m_8055_(npos);
                if (!nst.m_60713_((Block)this) || ((Boolean)nst.m_61143_((Property)f_54419_)).booleanValue() || (ndis = ((Integer)nst.m_61143_((Property)f_54418_)).intValue()) < (Integer)e.getFirst()) continue;
                queue.add(Pair.of((Object)ndis, (Object)npos));
                ans.add(npos);
            }
        }
        return ans;
    }

    @Override
    public boolean m_6724_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)f_54419_)).booleanValue()) {
            return false;
        }
        if (state.m_61143_((Property)STATE) == PassableLeavesBlock.State.FRUITS) {
            return true;
        }
        if (((Boolean)state.m_61143_((Property)FERTILE)).booleanValue() && (Integer)state.m_61143_((Property)f_54418_) == 1) {
            return true;
        }
        return (Integer)state.m_61143_((Property)f_54418_) == 7;
    }

    @Override
    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)f_54419_)).booleanValue() && !this.m_221385_(state)) {
            boolean grow;
            PassableLeavesBlock.State st = (PassableLeavesBlock.State)((Object)state.m_61143_((Property)STATE));
            if (st == PassableLeavesBlock.State.LEAVES && ((Boolean)state.m_61143_((Property)FERTILE)).booleanValue() && (Integer)state.m_61143_((Property)f_54418_) == 1) {
                boolean bl = grow = random.m_188500_() < (Double)FDModConfig.COMMON.peachGrowChance.get();
                if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (boolean)grow)) {
                    List<BlockPos> list = this.scanLeaves((Level)level, pos);
                    for (BlockPos e : list) {
                        BlockState est = level.m_8055_(e);
                        est = (BlockState)est.m_61124_((Property)STATE, (Comparable)((Object)PassableLeavesBlock.State.FLOWERS));
                        level.m_46597_(e, est);
                    }
                    ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                    return;
                }
            }
            if (st == PassableLeavesBlock.State.FLOWERS) {
                boolean bl = grow = random.m_188500_() < (Double)FDModConfig.COMMON.peachGrowChance.get();
                if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (boolean)grow)) {
                    List<BlockPos> list = this.scanLeaves((Level)level, pos);
                    for (BlockPos e : list) {
                        BlockState est = level.m_8055_(e);
                        if (est.m_61143_((Property)STATE) == PassableLeavesBlock.State.FRUITS) {
                            this.doDropFruit(est, level, e);
                        }
                        if ((Integer)(est = random.m_188500_() < (Double)FDModConfig.COMMON.peachFruitChance.get() ? (BlockState)est.m_61124_((Property)STATE, (Comparable)((Object)PassableLeavesBlock.State.FRUITS)) : (BlockState)est.m_61124_((Property)STATE, (Comparable)((Object)PassableLeavesBlock.State.LEAVES))).m_61143_((Property)f_54418_) > 1 || e.equals((Object)pos) && random.m_188500_() < (Double)FDModConfig.COMMON.flowerDecayChance.get()) {
                            est = (BlockState)est.m_61124_((Property)FERTILE, (Comparable)Boolean.valueOf(false));
                        }
                        level.m_46597_(e, est);
                    }
                    ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                }
                return;
            }
            if (st == PassableLeavesBlock.State.FRUITS) {
                if (random.m_188500_() < (Double)FDModConfig.COMMON.fruitsDropChance.get()) {
                    this.dropFruit(state, level, pos, random);
                }
                return;
            }
        }
        super.m_213898_(state, level, pos, random);
    }

    @Override
    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean client) {
        return (Boolean)state.m_61143_((Property)f_54419_);
    }

    @Override
    public void buildLeavesModel(DataGenContext<Block, ? extends BaseLeavesBlock> ctx, RegistrateBlockstateProvider pvd, String name) {
        pvd.getVariantBuilder((Block)ctx.get()).forAllStatesExcept(state -> this.buildModel(pvd, name, (BlockState)state), new Property[]{f_54418_, f_54419_, f_221367_, FERTILE});
    }
}

