/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.events;

import dev.xkmc.fruitsdelight.content.effects.EffectRemovalEffect;
import dev.xkmc.fruitsdelight.init.registrate.FDEffects;
import java.util.Set;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fruitsdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EffectHandlers {
    @SubscribeEvent
    public static void onEntitySize(EntityEvent.Size event) {
        Player le;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (le = (Player)entity).isAddedToWorld() && le.m_6144_() && le.m_21023_((MobEffect)FDEffects.SHRINKING.get())) {
            event.setNewSize(event.getNewSize().m_20388_(0.5f), true);
        }
    }

    @SubscribeEvent
    public static void onItemStartUse(LivingEntityUseItemEvent.Start event) {
        MobEffectInstance ins = event.getEntity().m_21124_((MobEffect)FDEffects.LOZENGE.get());
        if (ins != null && EffectHandlers.isEatOrDrink(event.getItem())) {
            event.setDuration(event.getDuration() >> 1 + ins.m_19564_());
        }
    }

    @SubscribeEvent
    public static void onEffectTest(MobEffectEvent.Applicable event) {
        for (MobEffectInstance old : event.getEntity().m_21220_()) {
            MobEffect mobEffect = old.m_19544_();
            if (!(mobEffect instanceof EffectRemovalEffect)) continue;
            EffectRemovalEffect eff = (EffectRemovalEffect)mobEffect;
            if (!((Set)eff.set.get()).contains(event.getEffectInstance().m_19544_())) continue;
            event.setResult(Event.Result.DENY);
            return;
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        LivingEntity le;
        Projectile proj;
        Entity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof Projectile && (entity = (proj = (Projectile)entity2).m_19749_()) instanceof LivingEntity && (le = (LivingEntity)entity).m_21023_((MobEffect)FDEffects.LEAF_PIERCING.get())) {
            proj.m_20049_(FDEffects.LEAF_PIERCING.getId().toString());
        }
    }

    public static boolean isEatOrDrink(ItemStack stack) {
        if (stack.m_41614_()) {
            return true;
        }
        try {
            UseAnim anim = stack.m_41780_();
            if (anim == UseAnim.EAT || anim == UseAnim.DRINK) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static float getFriction(LivingEntity le, float ans) {
        if (le.m_21023_((MobEffect)FDEffects.ASTRINGENT.get())) {
            return Math.min(0.6f, ans);
        }
        return ans;
    }

    public static float getBoatFriction(Boat boat, float ans) {
        for (Entity e : boat.m_20197_()) {
            LivingEntity le;
            if (!(e instanceof LivingEntity) || !(le = (LivingEntity)e).m_21023_((MobEffect)FDEffects.SLIDING.get())) continue;
            return Math.max(0.98f, ans);
        }
        return ans;
    }
}

