/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.food;

import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.fruitsdelight.content.item.FDFoodItem;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.data.RecipeGen;
import dev.xkmc.fruitsdelight.init.entries.FruitFluid;
import dev.xkmc.fruitsdelight.init.food.EffectEntry;
import dev.xkmc.fruitsdelight.init.food.FoodType;
import dev.xkmc.fruitsdelight.init.food.FruitType;
import dev.xkmc.fruitsdelight.init.food.IFDFood;
import dev.xkmc.fruitsdelight.init.registrate.FDFluids;
import dev.xkmc.fruitsdelight.init.registrate.FDItems;
import dev.xkmc.l2library.serial.ingredients.PotionIngredient;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.data.builder.CookingPotRecipeBuilder;

public enum FDJuice implements IFDFood
{
    HAMIMELON_JUICE(FruitType.HAMIMELON, Type.JUICE, new EffectEntry[0]),
    HAWBERRY_TEA(FruitType.HAWBERRY, Type.TEA, new EffectEntry[0]),
    ORANGE_JUICE(FruitType.ORANGE, Type.SWEETENED, new EffectEntry[0]),
    LEMON_JUICE(FruitType.LEMON, Type.SWEETENED, new EffectEntry[0]),
    PEAR_JUICE(FruitType.PEAR, Type.SWEETENED, new EffectEntry[0]),
    MANGO_TEA(FruitType.MANGO, Type.TEA, new EffectEntry[0]),
    PEACH_TEA(FruitType.PEACH, Type.TEA, new EffectEntry[0]),
    LYCHEE_CHERRY_TEA(FruitType.LYCHEE, Type.CHERRY, new EffectEntry[0]),
    MANGOSTEEN_TEA(FruitType.MANGOSTEEN, Type.TEA, new EffectEntry[0]),
    BAYBERRY_SOUP(FruitType.BAYBERRY, Type.SOUP, new EffectEntry[0]),
    KIWI_JUICE(FruitType.KIWI, Type.JUICE, new EffectEntry[0]),
    BELLINI_COCKTAIL(FruitType.PEACH, Type.COCKTAIL, new EffectEntry(() -> MobEffects.f_19604_, 100));

    private final String name;
    public final FruitType fruit;
    public final Type type;
    public final ItemEntry<Item> item;
    public final EffectEntry[] effs;

    private FDJuice(@Nullable FruitType fruit, Type type, String str, EffectEntry ... effs) {
        this.fruit = fruit;
        this.type = type;
        FoodType food = FoodType.JUICE;
        this.name = this.name().toLowerCase(Locale.ROOT);
        this.item = ((ItemBuilder)FruitsDelight.REGISTRATE.item(this.name, p -> food.build((Item.Properties)p, this)).transform(b -> food.model(b, 0, fruit))).lang(str != null ? str : FDItems.toEnglishName(this.name)).tag(food.tags).register();
        this.effs = effs;
    }

    private FDJuice(FruitType fruit, Type type, EffectEntry ... effs) {
        this(fruit, type, (String)null, effs);
    }

    public static void register() {
    }

    public Ingredient getFruitTag() {
        return this.fruit.getFruitTag();
    }

    public Item getFruit() {
        return this.fruit.getFruit();
    }

    public FDFoodItem get() {
        return (FDFoodItem)this.item.get();
    }

    public FruitFluid getFluid() {
        return (FruitFluid)((Object)FDFluids.JUICE[this.ordinal()].get());
    }

    @Override
    public FruitType fruit() {
        return this.fruit;
    }

    @Override
    public FoodType getType() {
        return FoodType.JUICE;
    }

    @Override
    public EffectEntry[] getEffects() {
        return this.effs;
    }

    public void recipe(RegistrateRecipeProvider pvd) {
        int count = this.fruit.jellyCost;
        if (this.type.category.cook) {
            CookingPotRecipeBuilder e = CookingPotRecipeBuilder.cookingPotRecipe(this.item, (int)1, (int)200, (float)0.1f, (ItemLike)Items.f_42590_);
            this.type.list.forEach(arg_0 -> ((CookingPotRecipeBuilder)e).addIngredient(arg_0));
            e.addIngredient(this.getFruitTag(), count);
            e.build((Consumer)pvd);
        } else {
            ShapelessRecipeBuilder e = RecipeGen.unlock(pvd, (arg_0, arg_1) -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, this.item)).m_126132_(arg_0, arg_1), this.getFruit());
            if (this.type.category.waterCraft) {
                e.m_126184_((Ingredient)new PotionIngredient(Potions.f_43599_));
            }
            this.type.list.forEach(arg_0 -> ((ShapelessRecipeBuilder)e).m_126184_(arg_0));
            e.m_126186_(this.getFruitTag(), count);
            e.m_176498_((Consumer)pvd);
        }
    }

    public static enum Type {
        JUICE(Category.PLAIN, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_})),
        SWEETENED(Category.RINSE, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42501_})),
        BOILED(Category.BOIL, new Ingredient[0]),
        SOUP(Category.SOUP, new Ingredient[0]),
        TEA(Category.BOIL, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42501_}), Ingredient.m_204132_((TagKey)ItemTags.f_13143_)),
        ICED(Category.COLD_COOK, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42501_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41980_})),
        COCKTAIL(Category.COLD_COOK, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42501_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41980_})),
        CHERRY(Category.BOIL, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42501_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_271517_}));

        public final Category category;
        public final List<Ingredient> list;

        private Type(Category category, Ingredient ... list) {
            this.category = category;
            this.list = List.of(list);
        }

        public FoodType getType() {
            return this == COCKTAIL ? FoodType.COCKTAIL : FoodType.JUICE;
        }
    }

    public static enum Category {
        PLAIN(false, false, false, false),
        RINSE(false, false, true, true),
        BOIL(true, true, false, true),
        SOUP(true, true, true, true),
        COLD_COOK(true, false, false, false);

        public final boolean cook;
        public final boolean heated;
        public final boolean waterCraft;
        public final boolean waterMix;

        private Category(boolean cook, boolean heated, boolean waterCraft, boolean waterMix) {
            this.cook = cook;
            this.heated = heated;
            this.waterCraft = waterCraft;
            this.waterMix = waterMix;
        }
    }
}

