/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.owl;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="hexerei")
public class OwlLoadedChunksSavedData
extends SavedData {
    protected static final String DATA_NAME = "hexerei_owl_loaded_chunks";
    Map<ResourceKey<Level>, Map<ChunkPos, List<UUID>>> chunkData = new HashMap<ResourceKey<Level>, Map<ChunkPos, List<UUID>>>();
    Map<ResourceKey<Level>, Set<ChunkPos>> selfLoadedChunks = new HashMap<ResourceKey<Level>, Set<ChunkPos>>();

    public OwlLoadedChunksSavedData addOwlLoading(ServerLevel level, OwlEntity owl, Set<ChunkPos> newChunks) {
        Map<ResourceKey<Level>, Set<ChunkPos>> lastChunksMap = owl.messagingController.getLastCheckedChunks();
        if (!this.chunkData.containsKey(level.m_46472_())) {
            this.chunkData.put((ResourceKey<Level>)level.m_46472_(), new HashMap());
        }
        for (ChunkPos chunkPos : newChunks) {
            List<Object> list = this.chunkData.get(level.m_46472_()).containsKey(chunkPos) ? this.chunkData.get(level.m_46472_()).get(chunkPos) : new ArrayList();
            if (list.contains(owl.m_20148_())) continue;
            list.add(owl.m_20148_());
            this.chunkData.get(level.m_46472_()).put(chunkPos, list);
        }
        lastChunksMap.forEach((key, lastChunks) -> {
            for (ChunkPos chunkPos : lastChunks) {
                if (newChunks.contains(chunkPos) || !key.equals(level.m_46472_()) || !this.chunkData.get(key).containsKey(chunkPos)) continue;
                List<UUID> list = this.chunkData.get(key).get(chunkPos);
                list.remove(owl.m_20148_());
                if (!list.isEmpty()) continue;
                this.chunkData.get(key).remove(chunkPos);
                if (!this.selfLoadedChunks.containsKey(key)) {
                    this.selfLoadedChunks.put((ResourceKey<Level>)key, new HashSet());
                }
                if (!this.selfLoadedChunks.get(key).contains(chunkPos)) continue;
                level.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, false);
                this.selfLoadedChunks.get(key).remove(chunkPos);
            }
        });
        this.m_77762_();
        return this;
    }

    public void clearOwl(ServerLevel serverLevel, OwlEntity owl) {
        HashMap<ResourceKey, Set> _to_remove = new HashMap<ResourceKey, Set>();
        this.chunkData.forEach((dimension, data) -> data.forEach((chunkPos, uuids) -> {
            List list = (List)data.get(chunkPos);
            list.remove(owl.m_20148_());
            if (list.isEmpty()) {
                if (!_to_remove.containsKey(dimension)) {
                    _to_remove.put((ResourceKey)dimension, new HashSet());
                }
                ((Set)_to_remove.get(dimension)).add(chunkPos);
                if (!this.selfLoadedChunks.containsKey(dimension)) {
                    this.selfLoadedChunks.put((ResourceKey<Level>)dimension, new HashSet());
                }
                if (this.selfLoadedChunks.get(dimension).contains(chunkPos)) {
                    ServerLevel level = serverLevel.m_7654_().m_129880_(dimension);
                    if (level != null) {
                        level.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, false);
                    }
                    this.selfLoadedChunks.get(dimension).remove(chunkPos);
                }
            }
        }));
        _to_remove.forEach((dim, posSet) -> {
            for (ChunkPos pos : posSet) {
                if (!this.chunkData.containsKey(dim)) continue;
                this.chunkData.get(dim).remove(pos);
            }
        });
        this.m_77762_();
    }

    public void tick(ServerLevel serverLevel) {
        this.chunkData.forEach((dimension, data) -> data.forEach((chunkPos, uuids) -> {
            ServerLevel level = serverLevel.m_7654_().m_129880_(dimension);
            if (level != null) {
                LongSet forcedChunks = level.m_8902_();
                if (!this.selfLoadedChunks.containsKey(dimension)) {
                    this.selfLoadedChunks.put((ResourceKey<Level>)dimension, new HashSet());
                }
                if (!this.selfLoadedChunks.get(dimension).contains(chunkPos) && !forcedChunks.contains(chunkPos.m_45588_())) {
                    level.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, true);
                    this.selfLoadedChunks.get(dimension).add((ChunkPos)chunkPos);
                    this.m_77762_();
                }
            }
        }));
    }

    @SubscribeEvent
    public static void serverTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            OwlLoadedChunksSavedData.get(event.getServer().m_129783_()).tick(event.getServer().m_129783_());
        }
    }

    private static OwlLoadedChunksSavedData create(CompoundTag tag) {
        OwlLoadedChunksSavedData data = new OwlLoadedChunksSavedData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag pCompoundTag) {
        this.selfLoadedChunks.clear();
        if (pCompoundTag.m_128441_("selfLoadedChunks")) {
            CompoundTag selfLoadedChunksTag = pCompoundTag.m_128469_("selfLoadedChunks");
            for (String key : selfLoadedChunksTag.m_128431_()) {
                ListTag chunkListTag = selfLoadedChunksTag.m_128437_(key, 10);
                ResourceKey levelKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(key));
                HashSet<ChunkPos> chunkPosSet = new HashSet<ChunkPos>();
                for (int i = 0; i < chunkListTag.size(); ++i) {
                    CompoundTag chunkTag = chunkListTag.m_128728_(i);
                    int x = chunkTag.m_128451_("x");
                    int z = chunkTag.m_128451_("z");
                    chunkPosSet.add(new ChunkPos(x, z));
                }
                this.selfLoadedChunks.put((ResourceKey<Level>)levelKey, chunkPosSet);
            }
        }
        CompoundTag dataTag = pCompoundTag.m_128469_("chunkData");
        dataTag.m_128431_().forEach(resourceKeyString -> {
            ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(resourceKeyString));
            CompoundTag resourceTag = dataTag.m_128469_(resourceKeyString);
            HashMap chunkMap = new HashMap();
            resourceTag.m_128431_().forEach(chunkPosString -> {
                CompoundTag chunkTag = resourceTag.m_128469_(chunkPosString);
                int x = chunkTag.m_128451_("x");
                int z = chunkTag.m_128451_("z");
                ChunkPos chunkPos = new ChunkPos(x, z);
                ListTag uuidTagList = chunkTag.m_128437_("UUIDs", 8);
                ArrayList uuidList = new ArrayList();
                uuidTagList.forEach(uuidTag -> uuidList.add(UUID.fromString(uuidTag.m_7916_())));
                chunkMap.put(chunkPos, uuidList);
            });
            this.chunkData.put((ResourceKey<Level>)resourceKey, chunkMap);
        });
    }

    public CompoundTag m_7176_(CompoundTag pCompoundTag) {
        CompoundTag compoundTag = new CompoundTag();
        this.selfLoadedChunks.forEach((resourceKey, chunkSet) -> {
            ListTag chunkListTag = new ListTag();
            chunkSet.forEach(chunkPos -> {
                CompoundTag chunkNBT = new CompoundTag();
                chunkNBT.m_128405_("x", chunkPos.f_45578_);
                chunkNBT.m_128405_("z", chunkPos.f_45579_);
                chunkListTag.add((Object)chunkNBT);
            });
            compoundTag.m_128365_(resourceKey.m_135782_().toString(), (Tag)chunkListTag);
        });
        pCompoundTag.m_128365_("selfLoadedChunks", (Tag)compoundTag);
        CompoundTag dataTag = new CompoundTag();
        this.chunkData.forEach((resourceKey, chunkMap) -> {
            CompoundTag resourceTag = new CompoundTag();
            chunkMap.forEach((chunkPos, uuidList) -> {
                CompoundTag chunkTag = new CompoundTag();
                chunkTag.m_128405_("x", chunkPos.f_45578_);
                chunkTag.m_128405_("z", chunkPos.f_45579_);
                ListTag uuidTagList = new ListTag();
                uuidList.forEach(uuid -> uuidTagList.add((Object)StringTag.m_129297_((String)uuid.toString())));
                chunkTag.m_128365_("UUIDs", (Tag)uuidTagList);
                resourceTag.m_128365_(chunkPos.f_45578_ + "," + chunkPos.f_45579_, (Tag)chunkTag);
            });
            dataTag.m_128365_(resourceKey.m_135782_().toString(), (Tag)resourceTag);
        });
        pCompoundTag.m_128365_("chunkData", (Tag)dataTag);
        return pCompoundTag;
    }

    public static OwlLoadedChunksSavedData get(ServerLevel world) {
        return (OwlLoadedChunksSavedData)world.m_7654_().m_129783_().m_8895_().m_164861_(OwlLoadedChunksSavedData::create, OwlLoadedChunksSavedData::new, DATA_NAME);
    }

    public static OwlLoadedChunksSavedData get() {
        return (OwlLoadedChunksSavedData)ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_().m_164861_(OwlLoadedChunksSavedData::create, OwlLoadedChunksSavedData::new, DATA_NAME);
    }
}

