/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import java.util.List;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.custom.ConnectingCarpetDyed;
import net.joefoxe.hexerei.block.custom.ConnectingCarpetStairs;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.CleaningClothItem;
import net.joefoxe.hexerei.item.custom.WaxBlendItem;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class WaxingKitItem
extends Item {
    boolean isCreative;

    public WaxingKitItem(Item.Properties pProperties, boolean isCreative) {
        super(pProperties);
        this.isCreative = isCreative;
    }

    public boolean m_142522_(ItemStack pStack) {
        return true;
    }

    public int m_142159_(ItemStack pStack) {
        if (this.isCreative) {
            return 0xFF55FF;
        }
        if (pStack.m_41782_() && pStack.m_41784_().m_128441_("waxCount") && pStack.m_41784_().m_128451_("waxCount") > 0) {
            float f = Math.max(0.0f, (float)this.m_142158_(pStack) / 13.0f);
            return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
        }
        return 0x353838;
    }

    public int m_142158_(ItemStack pStack) {
        if (pStack.m_41782_() && pStack.m_41784_().m_128441_("waxCount") && pStack.m_41784_().m_128451_("waxCount") > 0) {
            CompoundTag tag = new CompoundTag();
            if (pStack.m_41782_()) {
                tag = pStack.m_41784_();
            }
            if (tag.m_128441_("waxCount")) {
                return (int)((float)tag.m_128451_("waxCount") / 256.0f * 13.0f);
            }
            return 0;
        }
        return 13;
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        Player player = pContext.m_43723_();
        ItemStack itemstack = pContext.m_43722_();
        InteractionResult result = InteractionResult.PASS;
        if (this.isCreative || itemstack.m_41782_() && itemstack.m_41784_().m_128441_("waxCount") && itemstack.m_41784_().m_128451_("waxCount") > 0) {
            result = WaxBlendItem.getWaxed(blockstate).map(newBlockstate -> {
                if (blockstate.m_61138_(ConnectingCarpetDyed.COLOR)) {
                    newBlockstate.m_61124_(ConnectingCarpetDyed.COLOR, (Comparable)((DyeColor)blockstate.m_61143_(ConnectingCarpetDyed.COLOR)));
                }
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, itemstack);
                }
                if (!this.isCreative) {
                    itemstack.m_41784_().m_128405_("waxCount", itemstack.m_41784_().m_128451_("waxCount") - 1);
                }
                if (blockstate.m_60734_() instanceof CrossCollisionBlock) {
                    BlockState changeTo = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)newBlockstate.m_61124_((Property)CrossCollisionBlock.f_52309_, (Comparable)((Boolean)blockstate.m_61143_((Property)CrossCollisionBlock.f_52309_)))).m_61124_((Property)CrossCollisionBlock.f_52311_, (Comparable)((Boolean)blockstate.m_61143_((Property)CrossCollisionBlock.f_52311_)))).m_61124_((Property)CrossCollisionBlock.f_52310_, (Comparable)((Boolean)blockstate.m_61143_((Property)CrossCollisionBlock.f_52310_)))).m_61124_((Property)CrossCollisionBlock.f_52312_, (Comparable)((Boolean)blockstate.m_61143_((Property)CrossCollisionBlock.f_52312_)))).m_61124_((Property)CrossCollisionBlock.f_52313_, (Comparable)((Boolean)blockstate.m_61143_((Property)CrossCollisionBlock.f_52313_)));
                    if (blockstate.m_61138_(ConnectingCarpetDyed.COLOR)) {
                        changeTo.m_61124_(ConnectingCarpetDyed.COLOR, (Comparable)((DyeColor)blockstate.m_61143_(ConnectingCarpetDyed.COLOR)));
                    }
                    level.m_46597_(blockpos, changeTo);
                } else {
                    level.m_7731_(blockpos, newBlockstate, 11);
                }
                level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)newBlockstate));
                level.m_5898_(player, 3003, blockpos, 0);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }).orElse(InteractionResult.PASS);
        }
        if (result == InteractionResult.PASS) {
            BlockState cleanedState = CleaningClothItem.getCleanedState(blockstate);
            if (cleanedState != null) {
                level.m_5594_(player, blockpos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5898_(player, 3004, blockpos, 0);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, itemstack);
                }
                if (blockstate.m_61138_(ConnectingCarpetStairs.COLOR)) {
                    cleanedState = (BlockState)cleanedState.m_263224_(ConnectingCarpetStairs.COLOR, (Comparable)((DyeColor)blockstate.m_61143_(ConnectingCarpetStairs.COLOR)));
                }
                level.m_7731_(blockpos, cleanedState, 11);
                level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)cleanedState));
                if (player != null) {
                    itemstack.m_41622_(1, (LivingEntity)player, p_150686_ -> p_150686_.m_21190_(pContext.m_43724_()));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        }
        return result;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237110_((String)"<%s>", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAA6600)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            MutableComponent wax_blend = Component.m_237115_((String)((Item)ModItems.WAX_BLEND.get()).m_41466_().getString()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)7035654)));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.hexerei.waxing_kit", (Object[])new Object[]{wax_blend}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.waxing_kit_2").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"[%s]", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAA00)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
        }
        int count = 0;
        if (stack.m_41782_() && stack.m_41784_().m_128441_("waxCount")) {
            count = stack.m_41784_().m_128451_("waxCount");
        }
        if (!this.isCreative) {
            tooltip.add((Component)Component.m_237110_((String)("%s: " + count + " / 256"), (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.wax").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x99AE99)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.infinite_wax").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x99AE99))));
        }
        super.m_7373_(stack, world, tooltip, flagIn);
    }
}

