/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_optimization;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.conczin.immersive_optimization.Constants;
import net.conczin.immersive_optimization.config.Config;
import net.conczin.immersive_optimization.mixin.EntityTickListAccessor;
import net.conczin.immersive_optimization.mixin.ServerLevelAccessor;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class TickScheduler {
    public static TickScheduler INSTANCE = new TickScheduler();
    public static final int THREAD_SLEEP = 500;
    public static final int MAX_STRESS_TICKS = 600;
    public static final int CLEAR_BLOCK_ENTITIES_INTERVAL = 207;
    public static final int CLEAR_ENTITIES_INTERVAL = 12007;
    public MinecraftServer server;
    public FrustumProxy frustum;
    public final Map<ResourceLocation, LevelData> levelData = new ConcurrentHashMap<ResourceLocation, LevelData>();

    public static void setServer(MinecraftServer server) {
        TickScheduler.INSTANCE.server = server;
        INSTANCE.reset();
        Thread worker = new Thread((Runnable)new Worker(INSTANCE, server), "Immersive Optimization Worker");
        worker.setPriority(1);
        worker.setDaemon(true);
        worker.start();
    }

    @Nullable
    public LevelData getLevelData(Level level) {
        return this.levelData.get(level.m_46472_().m_135782_());
    }

    public void reset() {
        this.levelData.clear();
        this.frustum = null;
    }

    public void startLevelTick(ServerLevel level) {
        boolean stressed;
        LevelData data = this.getLevelData((Level)level);
        if (data == null) {
            return;
        }
        int stressedThreshold = Config.getInstance().stressedThreshold;
        boolean bl = stressed = stressedThreshold > 0 && this.server.m_129903_() > (float)stressedThreshold;
        if (data.outOfBudget || stressed) {
            data.stressedTicks = Math.min(600, data.stressedTicks + 2);
            if (stressed) {
                ++data.lifeTimeStressedTicks;
            }
            if (data.outOfBudget) {
                ++data.lifeTimeBudgetTicks;
            }
            data.outOfBudget = false;
        } else {
            data.stressedTicks = Math.max(0, data.stressedTicks - 1);
        }
        ++data.tick;
        data.time = System.nanoTime();
    }

    void tick() {
        int totalEntities = 0;
        for (LevelData data : this.levelData.values()) {
            totalEntities += data.stats.entities;
        }
        for (LevelData data : this.levelData.values()) {
            double budget = Config.getInstance().entityTickBudget;
            data.budget = budget > 0.0 ? (long)(Math.max(0.1, ((double)data.stats.entities + 1.0) / ((double)totalEntities + 1.0)) * budget * 1000000.0) : 0L;
        }
    }

    void tickLevel(ServerLevel level) {
        LevelData data = this.levelData.computeIfAbsent(level.m_46472_().m_135782_(), LevelData::new);
        long tick = level.m_46467_();
        Stats previousStats = data.previousStats;
        data.previousStats = data.stats;
        data.stats = previousStats;
        data.stats.reset();
        if (tick % 12007L == 0L) {
            data.budgeted.clear();
        }
        if (tick % 207L == 0L) {
            data.blockEntityPriorities.clear();
        }
        if (!Config.getInstance().enableEntities) {
            data.priorities.clear();
            return;
        }
        Int2IntOpenHashMap newPriorities = new Int2IntOpenHashMap();
        Int2ObjectMap<Entity> entities = ((EntityTickListAccessor)((ServerLevelAccessor)level).getEntityTickList()).getActive();
        entities.values().forEach(entity -> {
            if (entity != null) {
                int priority = this.getPriority(data, level, (Entity)entity);
                if (priority > 0) {
                    newPriorities.put(entity.m_19879_(), priority);
                }
                data.stats.tickRate += 1.0 / (double)Math.max(1, priority);
                ++data.stats.entities;
            }
        });
        data.priorities = newPriorities;
    }

    public boolean shouldTick(Entity entity) {
        if (entity.f_19811_ || INSTANCE == null) {
            return true;
        }
        LevelData data = this.getLevelData(entity.m_9236_());
        if (data == null) {
            return true;
        }
        int priority = data.priorities.getOrDefault(entity.m_19879_(), 0);
        if (priority <= 1) {
            return true;
        }
        if (data.outOfBudget) {
            data.budgeted.put(entity.m_19879_(), data.budgeted.getOrDefault(entity.m_19879_(), 0) + 1);
            return false;
        }
        long delta = System.nanoTime() - data.time;
        if (data.budget > 0L && delta > data.budget) {
            data.outOfBudget = true;
        }
        int budgeted = data.budgeted.getOrDefault(entity.m_19879_(), 0);
        if ((data.tick + (long)entity.m_19879_()) % (long)Math.max(1, priority - budgeted) == 0L) {
            if (budgeted > 0) {
                data.budgeted.put(entity.m_19879_(), budgeted - 1);
            }
            return true;
        }
        return false;
    }

    public int getPriority(LevelData data, ServerLevel level, Entity entity) {
        boolean integratedAndSinglePlayer;
        Config config = Config.getInstance();
        ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_());
        if (!config.entities.getOrDefault(id.toString(), true).booleanValue()) {
            return 0;
        }
        if (!config.entities.getOrDefault(id.m_135827_(), true).booleanValue()) {
            return 0;
        }
        double minDistance = 999999.0;
        for (Player player : level.m_6907_()) {
            minDistance = Math.min(minDistance, player.m_20280_(entity));
        }
        AABB box = entity.m_20191_();
        int blocksPerLevel = config.blocksPerLevel;
        boolean bl = integratedAndSinglePlayer = !level.m_7654_().m_6982_() && level.m_6907_().size() == 1;
        if (config.enableDistanceCulling && integratedAndSinglePlayer && !entity.m_6783_(minDistance)) {
            blocksPerLevel = config.blocksPerLevelDistanceCulled;
            ++data.stats.distanceCulledEntities;
        }
        if (config.enableTrackingCulling && blocksPerLevel > config.blocksPerLevelTrackingCulled) {
            int trackingRange = entity.m_6095_().m_20681_();
            int scaledTrackingDistance = level.m_7654_().m_7186_(trackingRange * 16);
            if (minDistance > (double)(scaledTrackingDistance * scaledTrackingDistance)) {
                blocksPerLevel = config.blocksPerLevelTrackingCulled;
                ++data.stats.trackingCulledEntities;
            }
        }
        if (config.enableViewportCulling && blocksPerLevel > config.blocksPerLevelViewportCulled && integratedAndSinglePlayer && this.frustum != null && !this.frustum.isVisible(box)) {
            blocksPerLevel = config.blocksPerLevelViewportCulled;
            ++data.stats.viewportCulledEntities;
        }
        double antiStress = 1.0 - (double)data.stressedTicks / 600.0;
        int finalBlocksPerLevel = (int)((double)blocksPerLevel * antiStress);
        int distanceLevel = (int)((Math.sqrt(minDistance) - (double)config.minDistance) / (double)Math.max(2, finalBlocksPerLevel));
        return Math.min(config.maxLevel, Math.max(1, distanceLevel + 1));
    }

    public boolean shouldTick(Level level, long pos) {
        if (!Config.getInstance().enableBlockEntities) {
            return true;
        }
        LevelData data = this.getLevelData(level);
        if (data == null) {
            return true;
        }
        int priority = data.blockEntityPriorities.computeIfAbsent(pos, p -> this.getBlockEntityPriority(level, (long)p));
        return priority < 1 || (level.m_46467_() + pos) % (long)priority == 0L;
    }

    private int getBlockEntityPriority(Level level, long p) {
        int x = ChunkPos.m_45592_((long)p);
        int z = ChunkPos.m_45602_((long)p);
        double minDistance = Double.MAX_VALUE;
        for (Player player : level.m_6907_()) {
            double dz;
            double dx = SectionPos.m_235865_((double)player.m_20185_()) - x;
            double distance = dx * dx + (dz = (double)(SectionPos.m_235865_((double)player.m_20189_()) - z)) * dz;
            if (!(distance < minDistance)) continue;
            minDistance = distance;
        }
        return Math.min((int)((Math.sqrt(minDistance * 16.0) - (double)Config.getInstance().minDistance) / (double)Config.getInstance().blocksPerLevelBlockEntities) + 1, Config.getInstance().maxLevel);
    }

    public static class Worker
    implements Runnable {
        TickScheduler scheduler;
        MinecraftServer server;

        public Worker(TickScheduler scheduler, MinecraftServer server) {
            this.scheduler = scheduler;
            this.server = server;
        }

        @Override
        public void run() {
            while (this.server.m_130010_()) {
                try {
                    this.scheduler.tick();
                    for (ServerLevel level : this.server.m_129785_()) {
                        this.scheduler.tickLevel(level);
                    }
                    Thread.sleep(500L);
                }
                catch (ArrayIndexOutOfBoundsException | ConcurrentModificationException runtimeException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Constants.LOG.info("Shutting down Immersive Optimization worker");
        }
    }

    public static class LevelData {
        public boolean active;
        public long tick = 0L;
        public long time = 0L;
        public long budget = 50000000L;
        public boolean outOfBudget = false;
        public Stats stats = new Stats();
        public Stats previousStats = new Stats();
        public int stressedTicks = 0;
        public int lifeTimeStressedTicks = 0;
        public int lifeTimeBudgetTicks = 0;
        public Map<Integer, Integer> budgeted = new ConcurrentHashMap<Integer, Integer>();
        public Int2IntOpenHashMap priorities = new Int2IntOpenHashMap();
        public Map<Long, Integer> blockEntityPriorities = new ConcurrentHashMap<Long, Integer>();

        public LevelData(ResourceLocation location) {
            this.active = Config.getInstance().dimensions.getOrDefault(location.toString(), true);
        }

        public String toLog() {
            return "Rate %2.1f%%, %d entities, %d stress, %d stressed, %d budgeted | culled %2.1f%% distance, %2.1f%% tracking, %2.1f%% viewport".formatted(this.previousStats.tickRate / (double)this.previousStats.entities * 100.0, this.previousStats.entities, this.stressedTicks, this.lifeTimeStressedTicks, this.lifeTimeBudgetTicks, Float.valueOf((float)this.previousStats.distanceCulledEntities / (float)this.previousStats.entities * 100.0f), Float.valueOf((float)this.previousStats.trackingCulledEntities / (float)this.previousStats.entities * 100.0f), Float.valueOf((float)this.previousStats.viewportCulledEntities / (float)this.previousStats.entities * 100.0f));
        }
    }

    public static interface FrustumProxy {
        public boolean isVisible(AABB var1);
    }

    public static class Stats {
        public double tickRate = 0.0;
        public int entities = 0;
        public int distanceCulledEntities = 0;
        public int trackingCulledEntities = 0;
        public int viewportCulledEntities = 0;

        public void reset() {
            this.tickRate = 0.0;
            this.entities = 0;
            this.distanceCulledEntities = 0;
            this.trackingCulledEntities = 0;
            this.viewportCulledEntities = 0;
        }
    }
}

