/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivelanterns;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector4f;
import toni.immersivelanterns.BaseLanternRenderer;
import toni.immersivelanterns.foundation.config.AllConfigs;
import toni.immersivelanterns.foundation.mixin.ModelPartAccessor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class LanternCurioRenderer
extends BaseLanternRenderer
implements ICurioRenderer {
    public static void register() {
        CuriosRendererRegistry.register((Item)Items.f_42778_, LanternCurioRenderer::new);
        CuriosRendererRegistry.register((Item)Items.f_42779_, LanternCurioRenderer::new);
    }

    public static boolean isEquipped(Player player) {
        LazyOptional curios = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (!curios.isPresent()) {
            return false;
        }
        return ((ICuriosItemHandler)curios.resolve().get()).isEquipped((T stack) -> stack.m_41720_() == Items.f_42778_ || stack.m_41720_() == Items.f_42779_);
    }

    public static ItemStack getEquipped(Player player) {
        if (!LanternCurioRenderer.isEquipped(player)) {
            return null;
        }
        return ((SlotResult)((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).resolve().get()).findFirstCurio(stack -> stack.m_41720_() == Items.f_42778_ || stack.m_41720_() == Items.f_42779_).get()).stack();
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrices, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            livingEntity = renderLayerParent.m_7200_();
            if (livingEntity instanceof PlayerModel) {
                float xOffset;
                PlayerModel playerModel = (PlayerModel)livingEntity;
                boolean isWearingArmor = false;
                for (ItemStack armor : player.m_6168_()) {
                    ArmorItem armorItem;
                    Item item = armor.m_41720_();
                    if (!(item instanceof ArmorItem) || (armorItem = (ArmorItem)item).m_40402_() != EquipmentSlot.LEGS && armorItem.m_40402_() != EquipmentSlot.CHEST) continue;
                    isWearingArmor = true;
                    break;
                }
                float lanternTop = 0.6875f;
                matrices.m_85836_();
                float f = xOffset = (Boolean)AllConfigs.client().leftHandedLanterns.get() != false ? 0.1f : 2.0f;
                float zOffset = ((Boolean)AllConfigs.client().backLanterns.get()).booleanValue() ? (isWearingArmor ? -3.1f : -3.0f) : -1.0f;
                Vec3 hipOffset = isWearingArmor ? new Vec3((double)(xOffset + 0.05f), -1.25, (double)(zOffset + 0.05f)) : new Vec3((double)(xOffset - 0.1f), -1.25, (double)(zOffset - 0.1f));
                LanternCurioRenderer.transformToModelPart(matrices, playerModel.f_102810_, hipOffset.f_82479_, hipOffset.f_82480_, hipOffset.f_82481_);
                matrices.m_252880_(0.5f, lanternTop, 0.5f);
                Vector4f localPosition = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
                localPosition.mulTranspose((Matrix4fc)matrices.m_85850_().m_252922_());
                Vec3 hipPosition = new Vec3((double)localPosition.x(), (double)localPosition.y(), (double)localPosition.z());
                hipPosition = hipPosition.m_82549_(player.m_20318_(partialTicks));
                Vec3 update = Minecraft.m_91087_().f_91080_ == null && (Boolean)AllConfigs.client().enablePhysics.get() != false ? this.updatePendulum(player, hipPosition, partialTicks) : Vec3.f_82478_;
                double xRot = update.f_82481_;
                xRot += (double)(Math.min(0.0f, playerModel.f_102813_.f_104203_ / 3.0f) - ((Boolean)AllConfigs.client().backLanterns.get() != false ? -0.1f : 0.1f));
                matrices.m_252781_(new Quaternionf().rotationZYX((float)update.f_82479_, 0.0f, (float)(xRot -= (double)playerModel.f_102810_.f_104203_)));
                matrices.m_252880_(-0.5f, -lanternTop, -0.5f);
                BlockState blockstate = Block.m_49814_((Item)stack.m_41720_()).m_49966_();
                Minecraft.m_91087_().m_91289_().m_110912_(blockstate, matrices, multiBufferSource, light, OverlayTexture.f_118083_);
                matrices.m_85849_();
            }
        }
    }

    static void transformToModelPart(PoseStack poseStack, ModelPart part, Number xPercent, Number yPercent, Number zPercent) {
        part.m_104299_(poseStack);
        Pair<Vec3, Vec3> aabb = LanternCurioRenderer.getAABB(part);
        poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        poseStack.m_85837_(xPercent != null ? Mth.m_14139_((double)((-xPercent.doubleValue() + 1.0) / 2.0), (double)((Vec3)aabb.getFirst()).f_82479_, (double)((Vec3)aabb.getSecond()).f_82479_) : 0.0, yPercent != null ? Mth.m_14139_((double)((-yPercent.doubleValue() + 1.0) / 2.0), (double)((Vec3)aabb.getFirst()).f_82480_, (double)((Vec3)aabb.getSecond()).f_82480_) : 0.0, zPercent != null ? Mth.m_14139_((double)((-zPercent.doubleValue() + 1.0) / 2.0), (double)((Vec3)aabb.getFirst()).f_82481_, (double)((Vec3)aabb.getSecond()).f_82481_) : 0.0);
        poseStack.m_85841_(8.0f, 8.0f, 8.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
    }

    private static Pair<Vec3, Vec3> getAABB(ModelPart part) {
        Vec3 min = new Vec3(0.0, 0.0, 0.0);
        Vec3 max = new Vec3(0.0, 0.0, 0.0);
        if (part.getClass().getSimpleName().contains("EMFModelPart")) {
            ArrayList<ModelPart> parts = new ArrayList<ModelPart>();
            parts.add(part);
            parts.addAll(((ModelPartAccessor)part).getChildren().values());
            for (ModelPart modelPart : parts) {
                for (ModelPart.Cube cube : ((ModelPartAccessor)modelPart).getCubes()) {
                    min = new Vec3(Math.min(min.f_82479_, (double)Math.min(cube.f_104335_ + modelPart.f_104200_, cube.f_104338_ + modelPart.f_104200_)), Math.min(min.f_82480_, (double)Math.min(cube.f_104336_ + modelPart.f_104201_, cube.f_104339_ + modelPart.f_104201_)), Math.min(min.f_82481_, (double)Math.min(cube.f_104337_ + modelPart.f_104202_, cube.f_104340_ + modelPart.f_104202_)));
                    max = new Vec3(Math.max(max.f_82479_, (double)Math.max(cube.f_104335_ + modelPart.f_104200_, cube.f_104338_ + modelPart.f_104200_)), Math.max(max.f_82480_, (double)Math.max(cube.f_104336_ + modelPart.f_104201_, cube.f_104339_ + modelPart.f_104201_)), Math.max(max.f_82481_, (double)Math.max(cube.f_104337_ + modelPart.f_104202_, cube.f_104340_ + modelPart.f_104202_)));
                }
            }
        } else {
            for (ModelPart.Cube cube : ((ModelPartAccessor)part).getCubes()) {
                min = new Vec3(Math.min(min.f_82479_, (double)Math.min(cube.f_104335_, cube.f_104338_)), Math.min(min.f_82480_, (double)Math.min(cube.f_104336_, cube.f_104339_)), Math.min(min.f_82481_, (double)Math.min(cube.f_104337_, cube.f_104340_)));
                max = new Vec3(Math.max(max.f_82479_, (double)Math.max(cube.f_104335_, cube.f_104338_)), Math.max(max.f_82480_, (double)Math.max(cube.f_104336_, cube.f_104339_)), Math.max(max.f_82481_, (double)Math.max(cube.f_104337_, cube.f_104340_)));
            }
        }
        return Pair.of((Object)min, (Object)max);
    }
}

