/*
 * Decompiled with CFR 0.152.
 */
package stepsword.jousting.item;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import stepsword.jousting.JoustingMod;
import stepsword.jousting.item.ItemBase;
import stepsword.jousting.render.LanceRenderer;

public class ItemLance
extends ItemBase {
    private Supplier<Double> attackDamage;
    private Supplier<Double> weight;
    private Supplier<Integer> durability;
    public static final UUID speedlance = UUID.fromString("91AEAA56-377B-4498-936B-2E8F20080635");

    public ItemLance(Supplier<Integer> getDurability, Supplier<Double> getDamage, Supplier<Double> getWeight) {
        super(new Item.Properties().m_41503_(getDurability.get().intValue()));
        this.attackDamage = getDamage;
        this.weight = getWeight;
        this.durability = getDurability;
    }

    public ItemLance(String name, CreativeModeTab group, Supplier<Integer> getDurability, Supplier<Double> getDamage, Supplier<Double> getWeight) {
        super(new Item.Properties().m_41503_(getDurability.get().intValue()));
        this.attackDamage = getDamage;
        this.weight = getWeight;
        this.durability = getDurability;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand handIn) {
        player.m_6672_(handIn);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(handIn));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            LanceRenderer renderer = new LanceRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public void m_5929_(Level level, LivingEntity player, ItemStack stack, int count) {
        if (count <= 4 && player.m_9236_().f_46443_ && player instanceof Player) {
            JoustingMod.proxy.stopUsing((Player)player);
        }
        if (!player.m_9236_().f_46443_ && player.m_20202_() != null) {
            double motion = 1.0;
            if (player.m_20202_() instanceof LivingEntity) {
                float z = (float)this.m_8105_(stack) - (float)count;
                double w = this.getWeight(stack);
                ItemLance.addspeed((LivingEntity)player.m_20202_(), true, (1.0f + z / 120.0f) * (1.0f + z / 120.0f) / 2.0f);
                AttributeInstance attr = ((LivingEntity)player.m_20202_()).m_21051_(Attributes.f_22279_);
                if (attr != null) {
                    motion = attr.m_22135_();
                }
            }
            AABB aabb = player.m_20191_();
            aabb = aabb.m_82367_(player.m_20202_().m_20191_()).m_82400_(motion);
            List entities = player.m_9236_().m_6249_((Entity)player, aabb, a -> a instanceof LivingEntity && a != player.m_20202_());
            Vec3 v = player.m_20154_();
            double len = motion;
            v = v.m_82541_();
            ArrayList<AABB> lst = new ArrayList<AABB>();
            Vec3 ppos = player.m_20182_();
            int m = 0;
            while ((double)m < len) {
                Vec3 r = ppos.m_82549_(v.m_82490_((double)m));
                float d = 1.0f;
                lst.add(new AABB(r.f_82479_ - (double)d, r.f_82480_ - (double)(d * 2.0f), r.f_82481_ - (double)d, r.f_82479_ + (double)d, r.f_82480_ + (double)(d * 2.0f), r.f_82481_ + (double)d));
                ++m;
            }
            for (Entity e : entities) {
                if (!(e instanceof LivingEntity)) continue;
                AABB bb = e.m_20191_();
                boolean intersects = false;
                player.m_20182_();
                for (int m2 = 0; m2 < lst.size(); ++m2) {
                    AABB q = (AABB)lst.get(m2);
                    if (!q.m_82381_(bb)) continue;
                    intersects = true;
                }
                if (!intersects) continue;
                if (!(((LivingEntity)e).m_21211_().m_41720_() instanceof ShieldItem)) {
                    if (player instanceof Player) {
                        this.attackTargetEntityWithCurrentItem(e, (Player)player);
                        kv = player.m_20154_().m_82541_();
                        ((LivingEntity)e).m_147240_((double)((float)this.getWeight(stack)), -kv.f_82479_, -kv.f_82481_);
                    } else {
                        e.m_6469_(player.m_269291_().m_269333_(player), (float)this.getAttackDamage(stack));
                        kv = player.m_20154_().m_82541_();
                        ((LivingEntity)e).m_147240_((double)((float)this.getWeight(stack)), -kv.f_82479_, -kv.f_82481_);
                    }
                    stack.m_41622_(1, player, a -> {});
                } else {
                    stack.m_41622_(30, player, a -> {});
                }
                if (e.m_20202_() != null) {
                    if (((LivingEntity)e).m_21205_().m_41720_() instanceof ItemLance) {
                        ItemLance.joust((LivingEntity)e, player);
                    } else {
                        e.m_6038_();
                    }
                }
                for (Entity passenger : e.m_146897_()) {
                    if (((LivingEntity)passenger).m_21205_().m_41720_() instanceof ItemLance && ((LivingEntity)passenger).m_21211_().m_41720_() instanceof ItemLance) {
                        ItemLance.joust((LivingEntity)passenger, player);
                        continue;
                    }
                    passenger.m_6038_();
                }
            }
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return this.durability.get();
    }

    public void m_5551_(ItemStack p_77615_1_, Level p_77615_2_, LivingEntity player, int p_77615_4_) {
        if (!player.m_9236_().f_46443_) {
            if (player.m_20202_() instanceof LivingEntity) {
                double w = this.getWeight(player.m_21205_());
                ItemLance.addspeed((LivingEntity)player.m_20202_(), false, (float)(1.0 + 1.0 / w));
            }
            if (player instanceof Player) {
                ((Player)player).m_36335_().m_41524_(p_77615_1_.m_41720_(), 40);
            }
        }
        super.m_5551_(p_77615_1_, p_77615_2_, player, p_77615_4_);
    }

    public static void joust(LivingEntity e1, LivingEntity e2) {
        if (e1.m_21205_().m_41720_() instanceof ItemLance && e2.m_21205_().m_41720_() instanceof ItemLance) {
            ItemLance lance1 = (ItemLance)e1.m_21205_().m_41720_();
            ItemLance lance2 = (ItemLance)e2.m_21205_().m_41720_();
            if (e1.m_20202_() instanceof LivingEntity && e2.m_20202_() instanceof LivingEntity) {
                double horse1 = ((LivingEntity)e1.m_20202_()).m_21051_(Attributes.f_22279_).m_22135_();
                double horse2 = ((LivingEntity)e1.m_20202_()).m_21051_(Attributes.f_22279_).m_22135_();
                double val1 = horse1 * 2.0 + lance1.getAttackDamage(e1.m_21205_()) / 4.0;
                double val2 = horse2 * 2.0 + lance2.getAttackDamage(e2.m_21205_()) / 4.0;
                if (e2.m_21206_().m_41720_() instanceof ShieldItem) {
                    e1.m_21205_().m_41622_(50, e1, a -> {});
                    val1 -= lance1.getAttackDamage(e1.m_21205_()) / 8.0;
                }
                if (e1.m_21206_().m_41720_() instanceof ShieldItem) {
                    e2.m_21205_().m_41622_(50, e2, a -> {});
                    val2 -= lance2.getAttackDamage(e1.m_21205_()) / 8.0;
                }
                if (val1 > val2) {
                    e2.m_6038_();
                } else if (val2 > val1) {
                    e1.m_6038_();
                } else if (e1.m_217043_().m_188499_()) {
                    e1.m_6038_();
                } else {
                    e2.m_6038_();
                }
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        Item item = stack.m_41720_();
        if (item instanceof ItemLance) {
            ItemLance lance = (ItemLance)item;
            DecimalFormat df = new DecimalFormat("#.#");
            String w = df.format(this.getWeight(stack));
            String a = df.format(this.getAttackDamage(stack));
            tooltip.add((Component)Component.m_237115_((String)"jousting.lance.weight").m_130946_(":" + w).m_130940_(ChatFormatting.DARK_PURPLE));
            tooltip.add((Component)Component.m_237115_((String)"jousting.lance.attackdamage").m_130946_(":" + a).m_130940_(ChatFormatting.BLUE));
        }
    }

    public static void addspeed(LivingEntity living, boolean add, float s) {
        AttributeModifier a = new AttributeModifier(speedlance, "lance_speed", (double)s, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeInstance attr = living.m_21051_(Attributes.f_22279_);
        if (attr != null) {
            boolean hasSpeed = attr.m_22109_(a);
            attr.m_22127_(speedlance);
            if (add) {
                attr.m_22125_(a);
            }
        }
    }

    public double getAttackDamage(ItemStack stack) {
        return this.attackDamage.get();
    }

    public double getWeight(ItemStack stack) {
        return this.weight.get();
    }

    public int m_8105_(ItemStack stack) {
        return (int)(120.0 / this.getWeight(stack));
    }

    public UseAnim m_6164_(ItemStack p_77661_1_) {
        return UseAnim.NONE;
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 3;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.canApplyAtEnchantingTable(new ItemStack((ItemLike)Items.f_42388_));
    }

    public void attackTargetEntityWithCurrentItem(Entity targetEntity, Player player) {
        if (!ForgeHooks.onPlayerAttackTarget((Player)player, (Entity)targetEntity)) {
            return;
        }
        if (targetEntity.m_6097_() && !targetEntity.m_7313_((Entity)player)) {
            float f = (float)this.getAttackDamage(player.m_21205_());
            float f1 = targetEntity instanceof LivingEntity ? EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)((LivingEntity)targetEntity).m_6336_()) : EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)MobType.f_21640_);
            player.m_36334_();
            if (f > 0.0f || f1 > 0.0f) {
                int i = 0;
                i += EnchantmentHelper.m_44894_((LivingEntity)player);
                f += f1;
                boolean flag3 = false;
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.m_44914_((LivingEntity)player);
                if (targetEntity instanceof LivingEntity) {
                    f4 = ((LivingEntity)targetEntity).m_21223_();
                    if (j > 0 && !targetEntity.m_6060_()) {
                        flag4 = true;
                        targetEntity.m_20254_(1);
                    }
                }
                Vec3 Vec32 = targetEntity.m_20184_();
                boolean flag5 = targetEntity.m_6469_(player.m_269291_().m_269075_(player), f);
                if (flag5) {
                    if (i > 0 && targetEntity instanceof LivingEntity) {
                        Vec3 kv = player.m_20182_().m_82546_(targetEntity.m_20182_());
                        ((LivingEntity)targetEntity).m_147240_((double)((float)this.getWeight(player.m_21205_())), kv.f_82479_, kv.f_82481_);
                    }
                    if (targetEntity instanceof ServerPlayer && targetEntity.f_19864_) {
                        ((ServerPlayer)targetEntity).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(targetEntity));
                        targetEntity.f_19864_ = false;
                        targetEntity.m_20256_(Vec32);
                    }
                    if (!flag3) {
                        player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12316_, player.m_5720_(), 1.0f, 1.0f);
                    }
                    player.m_21335_(targetEntity);
                    if (targetEntity instanceof LivingEntity) {
                        EnchantmentHelper.m_44823_((LivingEntity)((LivingEntity)targetEntity), (Entity)player);
                    }
                    EnchantmentHelper.m_44896_((LivingEntity)player, (Entity)targetEntity);
                    ItemStack itemstack1 = player.m_21205_();
                    Entity entity = targetEntity;
                    if (targetEntity instanceof EnderDragonPart) {
                        entity = ((EnderDragonPart)targetEntity).f_31010_;
                    }
                    if (!player.m_9236_().f_46443_ && !itemstack1.m_41619_() && entity instanceof LivingEntity) {
                        ItemStack copy = itemstack1.m_41777_();
                        itemstack1.m_41640_((LivingEntity)entity, player);
                        if (itemstack1.m_41619_()) {
                            ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)InteractionHand.MAIN_HAND);
                            player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                        }
                    }
                    if (targetEntity instanceof LivingEntity) {
                        float f5 = f4 - ((LivingEntity)targetEntity).m_21223_();
                        player.m_36222_(Stats.f_12928_, Math.round(f5 * 10.0f));
                        if (j > 0) {
                            targetEntity.m_20254_(j * 4);
                        }
                        if (player.m_9236_() instanceof ServerLevel && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123798_, targetEntity.m_20185_(), targetEntity.m_20227_(0.5), targetEntity.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    player.m_36399_(0.1f);
                } else {
                    player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12315_, player.m_5720_(), 1.0f, 1.0f);
                    if (flag4) {
                        targetEntity.m_20095_();
                    }
                }
            }
        }
    }
}

