/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod(value="killmobs")
public class MainMod {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final int TICKS_PER_MINUTE = 1200;
    private static final int TICKS_PER_30_MINUTES = 36000;
    private static final int WARNING_TIME = 30000;
    private static final int CHUNK_SIZE = 100;
    private AtomicInteger tickCounter = new AtomicInteger(0);
    private AtomicInteger warningCounter = new AtomicInteger(0);

    public MainMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            int ticks = this.tickCounter.incrementAndGet();
            int warningTicks = this.warningCounter.incrementAndGet();
            if (ticks >= 36000) {
                this.tickCounter.set(0);
                this.executeMobAndItemCleanup(event.getServer());
            }
            if (warningTicks >= 30000 && warningTicks < 30100) {
                this.sendWarningMessages(event.getServer(), 5 - (warningTicks - 30000) / 20);
            }
        }
    }

    private void executeMobAndItemCleanup(MinecraftServer server) {
        for (ServerLevel level : server.m_129785_()) {
            ArrayList<Entity> entitiesToRemove = new ArrayList<Entity>();
            ArrayList<ItemEntity> itemsToRemove = new ArrayList<ItemEntity>();
            for (Entity entity : level.m_142646_().m_142273_()) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (livingEntity instanceof TamableAnimal || livingEntity.m_8077_() || livingEntity.m_6095_().m_20674_() == MobCategory.CREATURE || livingEntity instanceof ServerPlayer || livingEntity.m_6095_().equals(EntityType.f_20496_) || livingEntity.m_6095_().equals(EntityType.f_20565_)) continue;
                    entitiesToRemove.add(entity);
                    continue;
                }
                if (!(entity instanceof ItemEntity)) continue;
                ItemEntity itemEntity = (ItemEntity)entity;
                itemsToRemove.add(itemEntity);
            }
            this.cleanupEntitiesInChunks(level, entitiesToRemove);
            this.cleanupItemsInChunks(level, itemsToRemove);
        }
    }

    private void cleanupEntitiesInChunks(ServerLevel level, List<Entity> entitiesToRemove) {
        int chunkCount = Math.min(100, entitiesToRemove.size());
        for (int i = 0; i < chunkCount; ++i) {
            Entity entity = entitiesToRemove.get(i);
            try {
                if (!(entity instanceof LivingEntity)) continue;
                ((LivingEntity)entity).m_6074_();
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Failed to kill entity: {}", (Object)entity.m_7755_().getString(), (Object)e);
            }
        }
        if (entitiesToRemove.size() > chunkCount) {
            LOGGER.info("There are more entities to clean up. Continuing in the next tick.");
        }
    }

    private void cleanupItemsInChunks(ServerLevel level, List<ItemEntity> itemsToRemove) {
        int chunkCount = Math.min(100, itemsToRemove.size());
        for (int i = 0; i < chunkCount; ++i) {
            ItemEntity itemEntity = itemsToRemove.get(i);
            try {
                itemEntity.m_146870_();
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Failed to remove item entity: {}", (Object)itemEntity.m_32055_().m_41786_().getString(), (Object)e);
            }
        }
        if (itemsToRemove.size() > chunkCount) {
            LOGGER.info("There are more items to clean up. Continuing in the next tick.");
        }
    }

    private void sendWarningMessages(MinecraftServer server, int countdown) {
        String countdownMessage = "Cleanup in " + countdown + " seconds!";
        for (ServerLevel level : server.m_129785_()) {
            level.m_6907_().forEach(player -> player.m_213846_((Component)Component.m_237113_((String)countdownMessage)));
        }
        if (countdown == 0) {
            this.sendCountdownAndExecuteCleanup(server);
        }
    }

    private void sendCountdownAndExecuteCleanup(MinecraftServer server) {
        String[] countdownMessages;
        for (String message : countdownMessages = new String[]{"5", "4", "3", "2", "1"}) {
            for (ServerLevel level : server.m_129785_()) {
                level.m_6907_().forEach(player -> player.m_213846_((Component)Component.m_237113_((String)message)));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("Countdown sleep interrupted.", (Throwable)e);
            }
        }
        this.executeMobAndItemCleanup(server);
    }
}

