/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.knightsnmages.item.perk;

import com.google.common.collect.Multimap;
import com.hollingsworth.arsnouveau.api.perk.IEffectResolvePerk;
import com.hollingsworth.arsnouveau.api.perk.Perk;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class NoblePerk
extends Perk
implements IEffectResolvePerk {
    public static NoblePerk INSTANCE = new NoblePerk(new ResourceLocation("knightsnmages", "thread_noble"));
    public static final UUID PERK_UUID = UUID.fromString("e49748e8-d0c4-497a-b35c-a943b4113003");

    public NoblePerk(ResourceLocation key) {
        super(key);
    }

    public String getLangDescription() {
        return "The incoming damage is decreased for a small amount.";
    }

    public String getLangName() {
        return "Noble";
    }

    public PerkSlot minimumSlot() {
        return PerkSlot.THREE;
    }

    public void onPreResolve(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver, AbstractEffect effect, PerkInstance perkInstance) {
        if (effect instanceof IDamageEffect) {
            LivingEntity livingEntity;
            EntityHitResult entityHitResult;
            Entity entity;
            IDamageEffect damageEffect = (IDamageEffect)effect;
            if (rayTraceResult instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)rayTraceResult).m_82443_()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity) != shooter && damageEffect.canDamage(livingEntity, spellStats, spellContext, resolver, entityHitResult.m_82443_())) {
                int n = perkInstance.getSlot().value;
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> getModifiers(EquipmentSlot pEquipmentSlot, ItemStack stack, int slotValue) {
        return this.attributeBuilder().put((Object)Attributes.f_22284_, (Object)new AttributeModifier(PERK_UUID, "NoblePerk", 4.0, AttributeModifier.Operation.ADDITION)).build();
    }

    public void onPostResolve(HitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver, AbstractEffect effect, PerkInstance perkInstance) {
    }
}

