/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.cmds;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import com.gitsh01.libertyvillagers.cmds.VillagerStats;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class VillagerInfo {
    static final String BLANK_COORDS = "                 ";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"villagerInfo").executes(context -> {
            VillagerInfo.processVillagerInfo((CommandContext<CommandSourceStack>)context);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"villagerinfo").executes(context -> {
            VillagerInfo.processVillagerInfo((CommandContext<CommandSourceStack>)context);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"vi").executes(context -> {
            VillagerInfo.processVillagerInfo((CommandContext<CommandSourceStack>)context);
            return 1;
        }));
    }

    public static void processVillagerInfo(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
        EntityHitResult hitResult2;
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        ServerPlayer player = source.m_230896_();
        ServerLevel serverWorld = source.m_81372_();
        float maxDistance = 50.0f;
        float tickDelta = 0.0f;
        Vec3 vec3d = player.m_20299_(tickDelta);
        Vec3 vec3d2 = player.m_20252_(tickDelta);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * (double)maxDistance, vec3d2.f_82480_ * (double)maxDistance, vec3d2.f_82481_ * (double)maxDistance);
        BlockHitResult hit = serverWorld.m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (hit.m_6662_() != HitResult.Type.MISS) {
            vec3d3 = hit.m_82450_();
        }
        if ((hitResult2 = ProjectileUtil.m_37304_((Level)serverWorld, (Entity)player, (Vec3)vec3d2, (Vec3)vec3d3, (AABB)player.m_20191_().m_82369_(player.m_20184_()).m_82400_((double)maxDistance), Entity::m_6084_)) != null) {
            hit = hitResult2;
        }
        List<Component> lines = null;
        switch (hit.m_6662_()) {
            case MISS: {
                break;
            }
            case BLOCK: {
                BlockHitResult blockHit = hit;
                BlockPos blockPos = blockHit.m_82425_();
                BlockState blockState = serverWorld.m_8055_(blockPos);
                if (blockState == null) break;
                lines = VillagerInfo.getBlockInfo(serverWorld, blockPos, blockState);
                break;
            }
            case ENTITY: {
                EntityHitResult entityHit = (EntityHitResult)hit;
                Entity entity = entityHit.m_82443_();
                if (entity == null) break;
                lines = VillagerInfo.getEntityInfo(serverWorld, entity);
            }
        }
        if (lines != null) {
            for (Component line : lines) {
                player.m_5661_(line, false);
            }
        }
    }

    public static List<Component> getEntityInfo(ServerLevel serverWorld, Entity entity) {
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)Component.m_237115_((String)"text.LibertyVillagers.villagerInfo.title"));
        if (entity == null) {
            return lines;
        }
        Component name = entity.m_5446_();
        lines.add((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerInfo.name", (Object[])new Object[]{name}));
        if (!(entity instanceof Villager)) {
            return lines;
        }
        Villager villager = (Villager)entity;
        String occupation = VillagerStats.translatedProfession(villager.m_7141_().m_35571_());
        lines.add((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerInfo.occupation", (Object[])new Object[]{occupation}));
        if (serverWorld == null) {
            lines.add((Component)Component.m_237115_((String)"text.LibertyVillagers.villagerInfo.needsServer"));
            return lines;
        }
        Optional home = villager.m_6274_().m_257414_(MemoryModuleType.f_26359_);
        String homeCoords = home.isPresent() ? ((GlobalPos)home.get()).m_122646_().m_123344_() : BLANK_COORDS;
        lines.add((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerInfo.home", (Object[])new Object[]{homeCoords}));
        Optional jobSite = villager.m_6274_().m_257414_(MemoryModuleType.f_26360_);
        String jobSiteCoords = jobSite.isPresent() ? ((GlobalPos)jobSite.get()).m_122646_().m_123344_() : BLANK_COORDS;
        lines.add((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerInfo.jobSite", (Object[])new Object[]{jobSiteCoords}));
        Optional potentialJobSite = villager.m_6274_().m_257414_(MemoryModuleType.f_26361_);
        String potentialJobSiteCoords = potentialJobSite.isPresent() ? ((GlobalPos)potentialJobSite.get()).m_122646_().m_123344_() : BLANK_COORDS;
        lines.add((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerInfo.potentialJobSite", (Object[])new Object[]{potentialJobSiteCoords}));
        Optional meetingPoint = villager.m_6274_().m_257414_(MemoryModuleType.f_26362_);
        String meetingPointCoords = meetingPoint.isPresent() ? ((GlobalPos)meetingPoint.get()).m_122646_().m_123344_() : BLANK_COORDS;
        lines.add((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerInfo.meetingPoint", (Object[])new Object[]{meetingPointCoords}));
        Optional walkTarget = villager.m_6274_().m_257414_(MemoryModuleType.f_26370_);
        String walkTargetCoords = walkTarget.isPresent() ? ((WalkTarget)walkTarget.get()).m_26420_().m_6675_().m_123344_() : BLANK_COORDS;
        lines.add((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerInfo.walkTarget", (Object[])new Object[]{walkTargetCoords, walkTarget.map(WalkTarget::m_26422_).orElse(0)}));
        lines.add((Component)Component.m_237115_((String)"text.LibertyVillagers.villagerInfo.inventory"));
        if (villager.m_35311_().m_7983_()) {
            lines.add((Component)Component.m_237115_((String)"text.LibertyVillagers.villagerInfo.empty"));
        } else {
            for (int i = 0; i < villager.m_35311_().m_6643_(); ++i) {
                ItemStack stack = villager.m_35311_().m_8020_(i);
                if (stack.m_41619_()) continue;
                lines.add((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerInfo.inventoryLine", (Object[])new Object[]{stack.m_41613_(), stack.m_41786_()}));
            }
        }
        if (villager.m_21573_().m_26570_() != null && LibertyVillagersMod.CONFIG.debugConfig.villagerInfoShowsPath) {
            lines.add((Component)Component.m_237115_((String)"text.LibertyVillagers.villagerInfo.path"));
            Path path = villager.m_21573_().m_26570_();
            for (int i = path.m_77399_(); i < path.m_77398_(); ++i) {
                lines.add((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerInfo.pathnode", (Object[])new Object[]{i, path.m_77375_(i).m_77288_().m_123344_()}));
            }
        }
        return lines;
    }

    public static List<Component> getBlockInfo(ServerLevel serverWorld, BlockPos blockPos, BlockState blockState) {
        Optional optionalRegistryEntry;
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)Component.m_237115_((String)"text.LibertyVillagers.villagerInfo.title"));
        Block block = blockState.m_60734_();
        if (block == null) {
            return lines;
        }
        MutableComponent name = block.m_49954_();
        lines.add((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerInfo.name", (Object[])new Object[]{name}));
        if (serverWorld == null) {
            lines.add((Component)Component.m_237115_((String)"text.LibertyVillagers.villagerInfo.needsServer"));
            return lines;
        }
        if (block instanceof BeehiveBlock) {
            BlockEntity blockEntity = serverWorld.m_7702_(blockPos);
            if (blockEntity instanceof BeehiveBlockEntity) {
                BeehiveBlockEntity beehiveBlockEntity = (BeehiveBlockEntity)blockEntity;
                int numBees = beehiveBlockEntity.m_58776_();
                lines.add((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerInfo.numBees", (Object[])new Object[]{numBees}));
            }
            int numHoney = block.m_6782_(blockState, (Level)serverWorld, blockPos);
            lines.add((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerInfo.numHoney", (Object[])new Object[]{numHoney}));
        }
        if ((optionalRegistryEntry = PoiTypes.m_218075_((BlockState)blockState)).isEmpty()) {
            lines.add((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerInfo.poiType", (Object[])new Object[]{Component.m_237115_((String)"text.LibertyVillagers.villagerInfo.none")}));
            return lines;
        }
        PoiType poiType = (PoiType)((Holder)optionalRegistryEntry.get()).m_203334_();
        Optional optionalRegistryKey = ((Holder)optionalRegistryEntry.get()).m_203543_();
        if (optionalRegistryKey.isEmpty()) {
            lines.add((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerInfo.poiType", (Object[])new Object[]{Component.m_237115_((String)"text.LibertyVillagers.villagerInfo.none")}));
            return lines;
        }
        String poiTypeName = ((ResourceKey)optionalRegistryKey.get()).m_135782_().toString();
        lines.add((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerInfo.poiType", (Object[])new Object[]{poiTypeName}));
        PoiManager storage = serverWorld.m_8904_();
        if (!storage.m_217874_((ResourceKey)optionalRegistryKey.get(), blockPos)) {
            lines.add((Component)Component.m_237115_((String)"text.LibertyVillagers.villagerInfo.notAPOI"));
            return lines;
        }
        int freeTickets = storage.m_148653_(blockPos);
        MutableComponent isOccupied = freeTickets < poiType.f_27326_() ? Component.m_237115_((String)"text.LibertyVillagers.villagerInfo.true") : Component.m_237115_((String)"text.LibertyVillagers.villagerInfo.false");
        lines.add((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerInfo.isOccupied", (Object[])new Object[]{isOccupied}));
        lines.add((Component)Component.m_237110_((String)"text.LibertyVillagers.villagerInfo.freeTickets", (Object[])new Object[]{freeTickets, poiType.f_27326_()}));
        return lines;
    }
}

