/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.cmds;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import com.gitsh01.libertyvillagers.cmds.ProfessionInfo;
import com.gitsh01.libertyvillagers.cmds.VillagerStatsClient;
import com.gitsh01.libertyvillagers.cmds.VillagerStatsServer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.MutablePair;

public class VillagerStats {
    private static final int LINES_PER_PAGE = 14;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"villagerStats").executes(context -> {
            VillagerStats.processVillagerStats((CommandContext<CommandSourceStack>)context);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"villagerstats").executes(context -> {
            VillagerStats.processVillagerStats((CommandContext<CommandSourceStack>)context);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"vs").executes(context -> {
            VillagerStats.processVillagerStats((CommandContext<CommandSourceStack>)context);
            return 1;
        }));
    }

    public static MutablePair<Integer, Integer> sumPair(MutablePair<Integer, Integer> oldVal, MutablePair<Integer, Integer> newVal) {
        oldVal.setLeft((Object)((Integer)oldVal.getLeft() + (Integer)newVal.getLeft()));
        oldVal.setRight((Object)((Integer)oldVal.getRight() + (Integer)newVal.getRight()));
        return oldVal;
    }

    public static void processVillagerStats(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        ServerPlayer player = source.m_230896_();
        ServerLevel serverWorld = source.m_81372_();
        ItemStack bookStack = new ItemStack((ItemLike)Items.f_42615_);
        bookStack.m_41700_("title", (Tag)StringTag.m_129297_((String)Component.m_237115_((String)"text.LibertyVillagers.villagerStats.title").getString()));
        bookStack.m_41700_("author", (Tag)StringTag.m_129297_((String)player.m_6302_()));
        List villagers = serverWorld.m_45976_(Villager.class, player.m_20191_().m_82400_((double)LibertyVillagersMod.CONFIG.debugConfig.villagerStatRange));
        ListTag pages = new ListTag();
        pages.addAll(VillagerStats.splitToPageTags(VillagerStats.titlePage(player, villagers, serverWorld)));
        pages.addAll(VillagerStats.splitToPageTags(VillagerStats.professionPage(player, villagers, serverWorld)));
        pages.addAll(VillagerStats.splitToPageTags(VillagerStats.heldWorkstationPage(player, serverWorld)));
        pages.addAll(VillagerStats.splitToPageTags(VillagerStats.freeWorkstationsPage(player, serverWorld)));
        pages.addAll(VillagerStats.splitToPageTags(VillagerStats.homelessPage(player, villagers, serverWorld)));
        pages.addAll(VillagerStats.splitToPageTags(VillagerStats.availableBedsPage(player, serverWorld)));
        pages.addAll(VillagerStats.splitToPageTags(VillagerStats.golems(player, serverWorld)));
        pages.addAll(VillagerStats.splitToPageTags(VillagerStats.cats(player, serverWorld)));
        bookStack.m_41700_("pages", (Tag)pages);
        if (Platform.getEnvironment() == Env.CLIENT) {
            VillagerStatsClient.openBookScreen(bookStack);
        } else {
            if (Platform.isFabric() && !Platform.isModLoaded((String)"server-translations-api")) {
                player.m_5661_(Component.m_130674_((String)"Server_translations_api is missing. VillagerStats does not work server-side without translations."), false);
                return;
            }
            VillagerStatsServer.openBookScreen(bookStack, (Player)player);
        }
    }

    private static Collection<StringTag> splitToPageTags(String string) {
        List<String> lines = Platform.getEnvironment() == Env.CLIENT ? VillagerStatsClient.wrapText(string) : VillagerStatsServer.wrapText(string);
        LinkedList<StringTag> pageTags = new LinkedList<StringTag>();
        int linesRemaining = 14;
        StringBuilder curString = new StringBuilder();
        while (!lines.isEmpty()) {
            curString.append(lines.remove(0));
            if (--linesRemaining > 0) continue;
            linesRemaining = 14;
            pageTags.add(StringTag.m_129297_((String)("\"" + curString + "\"")));
            curString = new StringBuilder();
        }
        if (curString.length() > 0) {
            pageTags.add(StringTag.m_129297_((String)("\"" + curString + "\"")));
        }
        return pageTags;
    }

    protected static String titlePage(ServerPlayer player, List<Villager> villagers, ServerLevel serverWorld) {
        String pageString = Component.m_237115_((String)"text.LibertyVillagers.villagerStats.title").getString() + "\n\n";
        pageString = pageString + Component.m_237110_((String)"text.LibertyVillagers.villagerStats.format", (Object[])new Object[]{Component.m_237115_((String)"text.LibertyVillagers.villagerStats.numberOfVillagers").getString(), villagers.size()}).getString() + "\n";
        int babies = 0;
        int nitwits = 0;
        int unemployed = 0;
        int homeless = 0;
        for (Villager villager : villagers) {
            if (villager.m_7141_().m_35571_() == VillagerProfession.f_35596_) {
                ++nitwits;
            }
            if (villager.m_7141_().m_35571_() == VillagerProfession.f_35585_) {
                ++unemployed;
            }
            if (villager.m_6162_()) {
                ++babies;
            }
            if (villager.m_6274_().m_21874_(MemoryModuleType.f_26359_)) continue;
            ++homeless;
        }
        pageString = pageString + Component.m_237110_((String)"text.LibertyVillagers.villagerStats.format", (Object[])new Object[]{Component.m_237115_((String)"text.LibertyVillagers.villagerStats.numberOfNitwits").getString(), nitwits}).getString() + "\n";
        pageString = pageString + Component.m_237110_((String)"text.LibertyVillagers.villagerStats.format", (Object[])new Object[]{Component.m_237115_((String)"text.LibertyVillagers.villagerStats.numberOfUnemployed").getString(), unemployed}).getString() + "\n";
        pageString = pageString + Component.m_237110_((String)"text.LibertyVillagers.villagerStats.format", (Object[])new Object[]{Component.m_237115_((String)"text.LibertyVillagers.villagerStats.numberOfBabies").getString(), babies}).getString() + "\n";
        pageString = pageString + Component.m_237110_((String)"text.LibertyVillagers.villagerStats.format", (Object[])new Object[]{Component.m_237115_((String)"text.LibertyVillagers.villagerStats.numberOfHomeless").getString(), homeless}).getString() + "\n";
        List golems = serverWorld.m_45976_(IronGolem.class, player.m_20191_().m_82400_((double)LibertyVillagersMod.CONFIG.debugConfig.villagerStatRange));
        pageString = pageString + Component.m_237110_((String)"text.LibertyVillagers.villagerStats.format", (Object[])new Object[]{Component.m_237115_((String)"text.LibertyVillagers.villagerStats.numberOfGolems").getString(), golems.size()}).getString() + "\n";
        List cats = serverWorld.m_45976_(Cat.class, player.m_20191_().m_82400_((double)LibertyVillagersMod.CONFIG.debugConfig.villagerStatRange));
        pageString = pageString + Component.m_237110_((String)"text.LibertyVillagers.villagerStats.format", (Object[])new Object[]{Component.m_237115_((String)"text.LibertyVillagers.villagerStats.numberOfCats").getString(), cats.size()}).getString() + "\n";
        return pageString;
    }

    public static String translatedProfession(VillagerProfession profession) {
        String villagerTranslationKey = EntityType.f_20492_.m_20675_();
        return Component.m_237115_((String)(villagerTranslationKey + "." + BuiltInRegistries.f_256735_.m_7981_((Object)profession).m_135815_())).getString();
    }

    protected static TreeMap<String, ProfessionInfo> createProfessionTreeMap() {
        TreeMap<String, ProfessionInfo> villagerProfessionMap = new TreeMap<String, ProfessionInfo>();
        for (Map.Entry professionEntry : BuiltInRegistries.f_256735_.m_6579_()) {
            VillagerProfession profession = (VillagerProfession)professionEntry.getValue();
            String professionText = VillagerStats.translatedProfession(profession);
            villagerProfessionMap.put(professionText, new ProfessionInfo(profession, 0));
        }
        return villagerProfessionMap;
    }

    protected static String professionPage(ServerPlayer player, List<Villager> villagers, ServerLevel serverWorld) {
        String pageString = Component.m_237115_((String)"text.LibertyVillagers.villagerStats.professions").getString() + "\n\n";
        TreeMap<String, ProfessionInfo> villagerProfessionMap = VillagerStats.createProfessionTreeMap();
        for (Villager villager : villagers) {
            if (villager.m_6162_()) {
                String babyText = Component.m_237115_((String)"text.LibertyVillagers.villagerStats.baby").getString();
                villagerProfessionMap.merge(babyText, new ProfessionInfo(villager.m_7141_().m_35571_(), 1), ProfessionInfo::mergeProfessionInfo);
                continue;
            }
            villagerProfessionMap.merge(VillagerStats.translatedProfession(villager.m_7141_().m_35571_()), new ProfessionInfo(villager.m_7141_().m_35571_(), 1), ProfessionInfo::mergeProfessionInfo);
        }
        AtomicReference<String> professions = new AtomicReference<String>("");
        villagerProfessionMap.forEach((villagerProfession, professionInfo) -> professions.set((String)professions.get() + Component.m_237110_((String)"text.LibertyVillagers.villagerStats.professionsCountFormat", (Object[])new Object[]{villagerProfession, professionInfo.countVillagersWithProfession}).getString() + "\n"));
        pageString = pageString + professions.get() + "\n\n";
        return pageString;
    }

    protected static String heldWorkstationPage(ServerPlayer player, ServerLevel serverWorld) {
        String pageString = Component.m_237115_((String)"text.LibertyVillagers.villagerStats.professionsHeldJobSites").getString() + "\n\n";
        TreeMap<String, ProfessionInfo> villagerProfessionMap = VillagerStats.createProfessionTreeMap();
        AtomicReference<String> heldWorkstations = new AtomicReference<String>("");
        villagerProfessionMap.forEach((villagerProfession, professionInfo) -> {
            long numOccupiedWorkstations = 0L;
            if (!Objects.equals(villagerProfession, "baby")) {
                numOccupiedWorkstations = serverWorld.m_8904_().m_27121_(professionInfo.profession.f_219628_(), player.m_20183_(), LibertyVillagersMod.CONFIG.debugConfig.villagerStatRange, PoiManager.Occupancy.IS_OCCUPIED);
            }
            heldWorkstations.set((String)heldWorkstations.get() + Component.m_237110_((String)"text.LibertyVillagers.villagerStats.professionsCountFormat", (Object[])new Object[]{villagerProfession, numOccupiedWorkstations}).getString() + "\n");
        });
        pageString = pageString + heldWorkstations.get() + "\n\n";
        return pageString;
    }

    protected static String freeWorkstationsPage(ServerPlayer player, ServerLevel serverWorld) {
        String pageString = Component.m_237115_((String)"text.LibertyVillagers.villagerStats.professionsAvailableJobSites").getString() + "\n\n";
        TreeMap<String, ProfessionInfo> villagerProfessionMap = VillagerStats.createProfessionTreeMap();
        AtomicReference<String> availableWorkstations = new AtomicReference<String>("");
        villagerProfessionMap.forEach((villagerProfession, professionInfo) -> {
            long numAvailableWorkstations = 0L;
            if (!Objects.equals(villagerProfession, "baby")) {
                numAvailableWorkstations = serverWorld.m_8904_().m_27121_(professionInfo.profession.f_219629_(), player.m_20183_(), LibertyVillagersMod.CONFIG.debugConfig.villagerStatRange, PoiManager.Occupancy.HAS_SPACE);
            }
            availableWorkstations.set((String)availableWorkstations.get() + Component.m_237110_((String)"text.LibertyVillagers.villagerStats.professionsCountFormat", (Object[])new Object[]{villagerProfession, numAvailableWorkstations}).getString() + "\n");
        });
        pageString = pageString + availableWorkstations.get() + "\n\n";
        return pageString;
    }

    protected static String homelessPage(ServerPlayer player, List<Villager> villagers, ServerLevel serverWorld) {
        StringBuilder homelessString = new StringBuilder();
        int numHomeless = 0;
        for (Villager villager : villagers) {
            if (villager.m_6274_().m_21874_(MemoryModuleType.f_26359_)) continue;
            ++numHomeless;
            homelessString.append(Component.m_237110_((String)"text.LibertyVillagers.villagerStats.homeless", (Object[])new Object[]{villager.m_5446_(), villager.m_20183_().m_123344_()}).getString()).append("\n");
        }
        String pageString = Component.m_237110_((String)"text.LibertyVillagers.villagerStats.format", (Object[])new Object[]{Component.m_237115_((String)"text.LibertyVillagers.villagerStats.numberOfHomeless").getString(), numHomeless}).getString() + "\n\n";
        if (numHomeless > 0) {
            pageString = pageString + homelessString;
        }
        return pageString;
    }

    protected static String availableBedsPage(ServerPlayer player, ServerLevel serverWorld) {
        List availableBeds = serverWorld.m_8904_().m_27181_(registryEntry -> registryEntry.m_203565_(PoiTypes.f_218060_), player.m_20183_(), LibertyVillagersMod.CONFIG.debugConfig.villagerStatRange, PoiManager.Occupancy.HAS_SPACE).toList();
        StringBuilder pageString = new StringBuilder(Component.m_237110_((String)"text.LibertyVillagers.villagerStats.format", (Object[])new Object[]{Component.m_237115_((String)"text.LibertyVillagers.villagerStats.numberOfAvailableBeds").getString(), availableBeds.size()}).getString() + "\n\n");
        if (availableBeds.size() > 0) {
            pageString.append(Component.m_237115_((String)"text.LibertyVillagers.villagerStats.bedsAt").getString()).append("\n");
            for (PoiRecord bed : availableBeds) {
                if (bed == null || bed.m_27257_() == null) continue;
                pageString.append(bed.m_27257_().m_123344_()).append("\n");
            }
        }
        return pageString.toString();
    }

    protected static String golems(ServerPlayer player, ServerLevel serverWorld) {
        List golems = serverWorld.m_45976_(IronGolem.class, player.m_20191_().m_82400_((double)LibertyVillagersMod.CONFIG.debugConfig.villagerStatRange));
        StringBuilder pageString = new StringBuilder(Component.m_237110_((String)"text.LibertyVillagers.villagerStats.format", (Object[])new Object[]{Component.m_237115_((String)"text.LibertyVillagers.villagerStats.numberOfGolems").getString(), golems.size()}).getString() + "\n\n");
        if (golems.size() > 0) {
            pageString.append(Component.m_237115_((String)"text.LibertyVillagers.villagerStats.golemsAt").getString()).append("\n");
            for (IronGolem golem : golems) {
                if (golem == null || golem.m_20183_() == null) continue;
                pageString.append(Component.m_237110_((String)"text.LibertyVillagers.villagerStats.homeless", (Object[])new Object[]{golem.m_5446_(), golem.m_20183_().m_123344_()}).getString()).append("\n");
            }
        }
        return pageString.toString();
    }

    protected static String translatedCatVariant(String variant) {
        return Component.m_237115_((String)("text.LibertyVillagers.villagerStats." + variant)).getString();
    }

    protected static String catType(ResourceLocation identifier) {
        return identifier.m_135815_().replaceAll("^(.*)/(.*)(\\..*)$", "$2");
    }

    protected static String cats(ServerPlayer player, ServerLevel serverWorld) {
        List cats = serverWorld.m_45976_(Cat.class, player.m_20191_().m_82400_((double)LibertyVillagersMod.CONFIG.debugConfig.villagerStatRange));
        String pageString = Component.m_237110_((String)"text.LibertyVillagers.villagerStats.format", (Object[])new Object[]{Component.m_237115_((String)"text.LibertyVillagers.villagerStats.numberOfCats").getString(), cats.size()}).getString() + "\n\n";
        TreeMap<String, Integer> catVariantMap = new TreeMap<String, Integer>();
        for (Map.Entry catVariantEntry : BuiltInRegistries.f_256754_.m_6579_()) {
            catVariantMap.put(VillagerStats.translatedCatVariant(((ResourceKey)catVariantEntry.getKey()).m_135782_().m_214299_()), 0);
        }
        if (cats.size() > 0) {
            for (Cat cat : cats) {
                String variant = VillagerStats.translatedCatVariant(BuiltInRegistries.f_256754_.m_7981_((Object)cat.m_28554_()).m_214299_());
                catVariantMap.merge(variant, 1, Integer::sum);
            }
            pageString = pageString + Component.m_237115_((String)"text.LibertyVillagers.villagerStats.catTypes").getString() + "\n";
            AtomicReference<String> catVariants = new AtomicReference<String>("");
            catVariantMap.forEach((catVariant, sum) -> catVariants.set((String)catVariants.get() + Component.m_237110_((String)"text.LibertyVillagers.villagerStats.professionsCountFormat", (Object[])new Object[]{catVariant, sum}).getString() + "\n"));
            pageString = pageString + catVariants;
        }
        return pageString;
    }
}

