/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.mixin;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AzaleaBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WalkNodeEvaluator.class})
public abstract class LandPathNodeMakerMixin
extends NodeEvaluator {
    private static Mob lastUsedEntity;

    @Inject(method={"getCommonNodeType"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getCommonNodeType(BlockGetter world, BlockPos pos, CallbackInfoReturnable<BlockPathTypes> cir) {
        if (lastUsedEntity != null && (lastUsedEntity.m_6095_() == EntityType.f_20492_ || lastUsedEntity.m_6095_() == EntityType.f_20460_)) {
            BlockState blockState = world.m_8055_(pos);
            Block block = blockState.m_60734_();
            if (block instanceof AzaleaBlock) {
                cir.setReturnValue((Object)BlockPathTypes.LEAVES);
                cir.cancel();
            }
            if (block instanceof StairBlock) {
                cir.setReturnValue((Object)BlockPathTypes.BLOCKED);
                cir.cancel();
            }
            if (LibertyVillagersMod.CONFIG.villagerPathfindingConfig.villagersAvoidGlassPanes && block instanceof IronBarsBlock) {
                cir.setReturnValue((Object)BlockPathTypes.BLOCKED);
                cir.cancel();
            }
        }
    }

    @Inject(method={"getDefaultNodeType"}, at={@At(value="HEAD")})
    public void getDefaultNodeType(BlockGetter world, int x, int y, int z, CallbackInfoReturnable<BlockPathTypes> cir) {
        lastUsedEntity = this.f_77313_;
    }
}

