/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.mixin;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Villager.class})
public abstract class VillagerEntityMixin
extends AbstractVillager
implements ReputationEventHandler,
VillagerDataHolder {
    @Shadow
    public static Map<Item, Integer> f_35369_;
    @Shadow
    private static Set<Item> f_35372_;

    public VillagerEntityMixin(EntityType<? extends AbstractVillager> entityType, Level world) {
        super(entityType, world);
    }

    @Shadow
    public abstract VillagerData m_7141_();

    @Shadow
    public abstract void m_34375_(VillagerData var1);

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void modifyStaticBlock(CallbackInfo ci) {
        f_35372_ = ImmutableSet.copyOf((Collection)Sets.difference(f_35372_, (Set)ImmutableSet.of((Object)Items.f_42404_, (Object)Items.f_42733_, (Object)Items.f_42405_)));
        if (LibertyVillagersMod.CONFIG.villagersGeneralConfig.villagersEatMelons) {
            f_35372_ = new HashSet<Item>(f_35372_);
            f_35372_.add(Items.f_42575_);
            f_35369_ = new HashMap<Item, Integer>(f_35369_);
            f_35369_.put(Items.f_42575_, 1);
        }
        if (LibertyVillagersMod.CONFIG.villagersProfessionConfig.farmersHarvestMelons) {
            f_35372_ = new HashSet<Item>(f_35372_);
            f_35372_.add(Items.f_42575_);
        }
        if (LibertyVillagersMod.CONFIG.villagersGeneralConfig.villagersEatPumpkinPie) {
            f_35369_ = new HashMap<Item, Integer>(f_35369_);
            f_35369_.put(Items.f_42687_, 1);
            f_35372_ = new HashSet<Item>(f_35372_);
            f_35372_.add(Items.f_42687_);
        }
        if (LibertyVillagersMod.CONFIG.villagersGeneralConfig.villagersEatCookedFish) {
            f_35369_ = new HashMap<Item, Integer>(f_35369_);
            f_35369_.put(Items.f_42530_, 1);
            f_35369_.put(Items.f_42531_, 1);
            f_35372_ = new HashSet<Item>(f_35372_);
            f_35372_.add(Items.f_42530_);
            f_35372_.add(Items.f_42531_);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V"})
    public void villagerInit(EntityType<? extends AbstractVillager> entityType, Level world, CallbackInfo ci) {
        if (LibertyVillagersMod.CONFIG.villagerPathfindingConfig.villagersAvoidCactus) {
            this.m_21441_(BlockPathTypes.DANGER_OTHER, 16.0f);
        }
        if (LibertyVillagersMod.CONFIG.villagerPathfindingConfig.villagersAvoidWater) {
            this.m_21441_(BlockPathTypes.WATER, -1.0f);
            this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        }
        if (LibertyVillagersMod.CONFIG.villagerPathfindingConfig.villagersAvoidRail) {
            this.m_21441_(BlockPathTypes.RAIL, -1.0f);
        }
        if (LibertyVillagersMod.CONFIG.villagerPathfindingConfig.villagersAvoidTrapdoor) {
            this.m_21441_(BlockPathTypes.TRAPDOOR, -1.0f);
        }
        if (LibertyVillagersMod.CONFIG.villagerPathfindingConfig.villagersAvoidPowderedSnow) {
            this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
            this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, 16.0f);
        }
        if (LibertyVillagersMod.CONFIG.villagersGeneralConfig.allBabyVillagers) {
            this.m_6863_(true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"initBrain(Lnet/minecraft/entity/ai/brain/Brain;)V"})
    private void changeVillagerProfession(Brain<Villager> brain, CallbackInfo ci) {
        if (!(this.m_9236_() instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)this.m_9236_();
        VillagerProfession profession = this.m_7141_().m_35571_();
        if (LibertyVillagersMod.CONFIG.villagersGeneralConfig.noNitwitVillagers && profession == VillagerProfession.f_35596_) {
            this.m_34375_(this.m_7141_().m_35565_(VillagerProfession.f_35585_));
            brain.m_21933_(world, (LivingEntity)((Villager)this));
        }
        if (LibertyVillagersMod.CONFIG.villagersGeneralConfig.allNitwitVillagers && profession != VillagerProfession.f_35596_) {
            this.m_34375_(this.m_7141_().m_35565_(VillagerProfession.f_35596_));
            this.releaseTicketFor(brain, world, (MemoryModuleType<GlobalPos>)MemoryModuleType.f_26360_);
            this.releaseTicketFor(brain, world, (MemoryModuleType<GlobalPos>)MemoryModuleType.f_26361_);
            brain.m_21933_(world, (LivingEntity)((Villager)this));
        }
    }

    public void releaseTicketFor(Brain<Villager> brain, ServerLevel world, MemoryModuleType<GlobalPos> memoryModuleType) {
        MinecraftServer minecraftServer = world.m_7654_();
        brain.m_257414_(memoryModuleType).ifPresent(pos -> {
            ServerLevel serverWorld = minecraftServer.m_129880_(pos.m_122640_());
            if (serverWorld == null) {
                return;
            }
            PoiManager pointOfInterestStorage = serverWorld.m_8904_();
            Optional optional = pointOfInterestStorage.m_27177_(pos.m_122646_());
            BiPredicate biPredicate = (BiPredicate)Villager.f_35370_.get(memoryModuleType);
            if (optional.isPresent() && biPredicate.test((Villager)this, (Holder)optional.get())) {
                pointOfInterestStorage.m_27154_(pos.m_122646_());
                DebugPackets.m_133719_((ServerLevel)serverWorld, (BlockPos)pos.m_122646_());
            }
        });
    }

    @Inject(method={"hasSeedToPlant()Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void hasExtraSeedToPlant(CallbackInfoReturnable<Boolean> cir) {
        HashSet<Item> extraSeeds = new HashSet<Item>();
        if (LibertyVillagersMod.CONFIG.villagersProfessionConfig.farmersHarvestMelons) {
            extraSeeds.add(Items.f_42575_);
            extraSeeds.add(Items.f_42578_);
        }
        if (LibertyVillagersMod.CONFIG.villagersProfessionConfig.farmersHarvestPumpkins) {
            extraSeeds.add(Items.f_42046_);
            extraSeeds.add(Items.f_42577_);
        }
        if (!extraSeeds.isEmpty() && this.m_35311_().m_18949_(extraSeeds)) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Inject(method={"onGrowUp()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void babiesNeverGrowUp(CallbackInfo ci) {
        if (LibertyVillagersMod.CONFIG.villagersGeneralConfig.allBabyVillagers || LibertyVillagersMod.CONFIG.villagersGeneralConfig.foreverYoung) {
            this.m_6863_(true);
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"wakeUp()V"})
    private void healOnWakeUp(CallbackInfo info) {
        if (LibertyVillagersMod.CONFIG.villagersGeneralConfig.healOnWake) {
            this.m_5634_(this.m_21233_());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isReadyToBreed()Z"}, cancellable=true)
    public void replaceIsReadyToBreed(CallbackInfoReturnable<Boolean> cir) {
        if (LibertyVillagersMod.CONFIG.villagersGeneralConfig.villagersDontBreed) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canSummonGolem(J)Z"}, cancellable=true)
    public void replaceCanSummonGolem(long time, CallbackInfoReturnable<Boolean> cir) {
        List golems;
        if (LibertyVillagersMod.CONFIG.golemsConfig.villagersDontSummonGolems) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
        if (LibertyVillagersMod.CONFIG.golemsConfig.golemSpawnLimit && (golems = this.m_9236_().m_45976_(IronGolem.class, this.m_20191_().m_82400_((double)LibertyVillagersMod.CONFIG.golemsConfig.golemSpawnLimitRange))).size() >= LibertyVillagersMod.CONFIG.golemsConfig.golemSpawnLimitCount) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void readCustomDataFromNbt(CompoundTag nbt, CallbackInfo ci) {
        if (this.m_21205_().m_150930_(Items.f_42523_)) {
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        for (int i = this.m_35311_().m_6643_(); i >= 0; --i) {
            ItemStack stack = this.m_35311_().m_8020_(i);
            if (stack.m_41619_() || f_35372_.contains(stack.m_41720_()) || this.m_7141_().m_35571_().f_35602_().contains((Object)stack.m_41720_())) continue;
            this.m_35311_().m_8016_(i);
        }
    }

    @Inject(method={"setAttacker"}, at={@At(value="TAIL")})
    public void setAttacker(@Nullable LivingEntity attacker, CallbackInfo ci) {
        if (this.m_21205_().m_150930_(Items.f_42523_)) {
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
    }
}

