/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.mixin;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import com.gitsh01.libertyvillagers.tasks.FeedTargetTask;
import com.gitsh01.libertyvillagers.tasks.FisherWorkTask;
import com.gitsh01.libertyvillagers.tasks.GoFishingTask;
import com.gitsh01.libertyvillagers.tasks.HealGolemTask;
import com.gitsh01.libertyvillagers.tasks.ThrowRegenPotionAtTask;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.GiveGiftToHero;
import net.minecraft.world.entity.ai.behavior.HarvestFarmland;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromBlockMemory;
import net.minecraft.world.entity.ai.behavior.ShowTradesToPlayer;
import net.minecraft.world.entity.ai.behavior.StrollAroundPoi;
import net.minecraft.world.entity.ai.behavior.StrollToPoi;
import net.minecraft.world.entity.ai.behavior.StrollToPoiList;
import net.minecraft.world.entity.ai.behavior.UpdateActivityFromSchedule;
import net.minecraft.world.entity.ai.behavior.UseBonemeal;
import net.minecraft.world.entity.ai.behavior.VillagerGoalPackages;
import net.minecraft.world.entity.ai.behavior.WorkAtComposter;
import net.minecraft.world.entity.ai.behavior.WorkAtPoi;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VillagerGoalPackages.class})
public abstract class VillagerTaskListProviderMixin {
    private static final int SECONDARY_WORK_TASK_PRIORITY = 6;
    private static final int THIRD_WORK_TASK_PRIORITY = 7;
    private static final int PRIMARY_WORK_TASK_PRIORITY = 8;

    @Invoker(value="createBusyFollowTask")
    public static Pair<Integer, BehaviorControl<LivingEntity>> invokeCreateBusyFollowTask() {
        throw new AssertionError();
    }

    @Inject(method={"createWorkTasks"}, at={@At(value="Head")}, cancellable=true)
    private static void replaceCreateWorkTasks(VillagerProfession profession, float speed, CallbackInfoReturnable<List<Pair<Integer, ? extends BehaviorControl<? super Villager>>>> cir) {
        Object villagerWorkTask = new WorkAtPoi();
        Object secondaryWorkTask = null;
        OneShot thirdWorkTask = StrollAroundPoi.m_257894_((MemoryModuleType)MemoryModuleType.f_26360_, (float)0.4f, (int)4);
        switch (profession.toString()) {
            case "armorer": {
                if (!LibertyVillagersMod.CONFIG.villagersProfessionConfig.armorerHealsGolems) break;
                secondaryWorkTask = new HealGolemTask();
                break;
            }
            case "butcher": {
                ArrayList<Pair> randomTasks = new ArrayList<Pair>();
                if (LibertyVillagersMod.CONFIG.villagersProfessionConfig.butchersFeedChickens) {
                    randomTasks.add(Pair.of((Object)((Object)new FeedTargetTask(Chicken.class, (ImmutableSet<Item>)ImmutableSet.of((Object)Items.f_42404_, (Object)Items.f_42733_, (Object)Items.f_42578_, (Object)Items.f_42577_), LibertyVillagersMod.CONFIG.villagersProfessionConfig.feedAnimalsRange, LibertyVillagersMod.CONFIG.villagersProfessionConfig.feedMaxAnimals)), (Object)6));
                }
                if (LibertyVillagersMod.CONFIG.villagersProfessionConfig.butchersFeedCows) {
                    randomTasks.add(Pair.of((Object)((Object)new FeedTargetTask(Cow.class, (ImmutableSet<Item>)ImmutableSet.of((Object)Items.f_42405_), LibertyVillagersMod.CONFIG.villagersProfessionConfig.feedAnimalsRange, LibertyVillagersMod.CONFIG.villagersProfessionConfig.feedMaxAnimals)), (Object)6));
                }
                if (LibertyVillagersMod.CONFIG.villagersProfessionConfig.butchersFeedPigs) {
                    randomTasks.add(Pair.of((Object)((Object)new FeedTargetTask(Pig.class, (ImmutableSet<Item>)ImmutableSet.of((Object)Items.f_42732_, (Object)Items.f_42620_, (Object)Items.f_42619_), LibertyVillagersMod.CONFIG.villagersProfessionConfig.feedAnimalsRange, LibertyVillagersMod.CONFIG.villagersProfessionConfig.feedMaxAnimals)), (Object)6));
                }
                if (LibertyVillagersMod.CONFIG.villagersProfessionConfig.butchersFeedRabbits) {
                    randomTasks.add(Pair.of((Object)((Object)new FeedTargetTask(Rabbit.class, (ImmutableSet<Item>)ImmutableSet.of((Object)Items.f_42619_), LibertyVillagersMod.CONFIG.villagersProfessionConfig.feedAnimalsRange, LibertyVillagersMod.CONFIG.villagersProfessionConfig.feedMaxAnimals)), (Object)6));
                }
                if (LibertyVillagersMod.CONFIG.villagersProfessionConfig.butchersFeedSheep) {
                    randomTasks.add(Pair.of((Object)((Object)new FeedTargetTask(Sheep.class, (ImmutableSet<Item>)ImmutableSet.of((Object)Items.f_42405_), LibertyVillagersMod.CONFIG.villagersProfessionConfig.feedAnimalsRange, LibertyVillagersMod.CONFIG.villagersProfessionConfig.feedMaxAnimals)), (Object)6));
                }
                if (randomTasks.size() <= 0) break;
                secondaryWorkTask = new RunOne((List)ImmutableList.copyOf(randomTasks));
                break;
            }
            case "cleric": {
                if (!LibertyVillagersMod.CONFIG.villagersProfessionConfig.clericThrowsPotionsAtPlayers && !LibertyVillagersMod.CONFIG.villagersProfessionConfig.clericThrowsPotionsAtVillagers) break;
                secondaryWorkTask = new ThrowRegenPotionAtTask();
                break;
            }
            case "farmer": {
                villagerWorkTask = new HarvestFarmland();
                secondaryWorkTask = new WorkAtComposter();
                thirdWorkTask = new UseBonemeal();
                break;
            }
            case "fisherman": {
                if (!LibertyVillagersMod.CONFIG.villagersProfessionConfig.fishermanFish) break;
                villagerWorkTask = new GoFishingTask();
                secondaryWorkTask = new FisherWorkTask();
                break;
            }
            case "fletcher": {
                if (!LibertyVillagersMod.CONFIG.villagersProfessionConfig.fletchersFeedChickens) break;
                secondaryWorkTask = new FeedTargetTask(Chicken.class, (ImmutableSet<Item>)ImmutableSet.of((Object)Items.f_42404_, (Object)Items.f_42733_, (Object)Items.f_42578_, (Object)Items.f_42577_), LibertyVillagersMod.CONFIG.villagersProfessionConfig.feedAnimalsRange, LibertyVillagersMod.CONFIG.villagersProfessionConfig.feedMaxAnimals);
                break;
            }
            case "leatherworker": {
                if (!LibertyVillagersMod.CONFIG.villagersProfessionConfig.leatherworkersFeedCows) break;
                secondaryWorkTask = new FeedTargetTask(Cow.class, (ImmutableSet<Item>)ImmutableSet.of((Object)Items.f_42405_), LibertyVillagersMod.CONFIG.villagersProfessionConfig.feedAnimalsRange, LibertyVillagersMod.CONFIG.villagersProfessionConfig.feedMaxAnimals);
                break;
            }
            case "shepherd": {
                if (!LibertyVillagersMod.CONFIG.villagersProfessionConfig.shepherdsFeedSheep) break;
                secondaryWorkTask = new FeedTargetTask(Sheep.class, (ImmutableSet<Item>)ImmutableSet.of((Object)Items.f_42405_), LibertyVillagersMod.CONFIG.villagersProfessionConfig.feedAnimalsRange, LibertyVillagersMod.CONFIG.villagersProfessionConfig.feedMaxAnimals);
            }
        }
        ArrayList<Pair> randomTasks = new ArrayList<Pair>((Collection<Pair>)ImmutableList.of((Object)Pair.of((Object)villagerWorkTask, (Object)8), (Object)Pair.of((Object)StrollToPoi.m_258086_((MemoryModuleType)MemoryModuleType.f_26360_, (float)0.4f, (int)LibertyVillagersMod.CONFIG.villagerPathfindingConfig.minimumPOISearchDistance, (int)10), (Object)5), (Object)Pair.of((Object)StrollToPoiList.m_257487_((MemoryModuleType)MemoryModuleType.f_26363_, (float)speed, (int)LibertyVillagersMod.CONFIG.villagerPathfindingConfig.minimumPOISearchDistance, (int)6, (MemoryModuleType)MemoryModuleType.f_26360_), (Object)5)));
        if (secondaryWorkTask != null) {
            randomTasks.add(Pair.of((Object)secondaryWorkTask, (Object)6));
        }
        if (thirdWorkTask != null) {
            randomTasks.add(Pair.of((Object)thirdWorkTask, (Object)7));
        }
        RunOne randomTask = new RunOne((List)ImmutableList.copyOf(randomTasks));
        List<Pair> tasks = List.of(VillagerTaskListProviderMixin.invokeCreateBusyFollowTask(), Pair.of((Object)7, (Object)randomTask), Pair.of((Object)10, (Object)new ShowTradesToPlayer(400, 1600)), Pair.of((Object)10, (Object)SetLookAndInteract.m_257430_((EntityType)EntityType.f_20532_, (int)4)), Pair.of((Object)2, (Object)SetWalkTargetFromBlockMemory.m_257972_((MemoryModuleType)MemoryModuleType.f_26360_, (float)speed, (int)9, (int)LibertyVillagersMod.CONFIG.villagerPathfindingConfig.pathfindingMaxRange, (int)1200)), Pair.of((Object)3, (Object)new GiveGiftToHero(100)), Pair.of((Object)99, (Object)UpdateActivityFromSchedule.m_257835_()));
        cir.setReturnValue((Object)ImmutableList.copyOf(tasks));
        cir.cancel();
    }

    @ModifyArg(method={"createMeetTasks(Lnet/minecraft/village/VillagerProfession;F)Lcom/google/common/collect/ImmutableList;"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/brain/task/VillagerWalkTowardsTask;create(Lnet/minecraft/entity/ai/brain/MemoryModuleType;FIII)Lnet/minecraft/entity/ai/brain/task/SingleTickTask;"), index=2)
    private static int replaceCompletionRangeForWalkTowardsMeetTask(int completionRange) {
        return Math.max(LibertyVillagersMod.CONFIG.villagerPathfindingConfig.minimumPOISearchDistance, completionRange) + 3;
    }
}

