/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.mixin;

import com.gitsh01.libertyvillagers.LibertyVillagersMod;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.SetClosestHomeAsWalkTarget;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.mutable.MutableLong;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SetClosestHomeAsWalkTarget.class})
public abstract class WalkHomeTaskMixin {
    private static ServerLevel world;

    @Redirect(method={"method_47054"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/BlockPos;getSquaredDistance(Lnet/minecraft/util/math/Vec3i;)D"))
    private static double replaceSquaredDistanceWithManhattan(BlockPos origin, Vec3i dest) {
        return origin.m_123333_(dest);
    }

    @ModifyConstant(method={"method_47054"}, constant={@Constant(doubleValue=4.0)})
    private static double replaceSquaredDistanceWithManhattanConstant(double constant) {
        return 2.0;
    }

    @ModifyArg(method={"method_47054"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/poi/PointOfInterestStorage;getNearestPosition(Ljava/util/function/Predicate;Lnet/minecraft/util/math/BlockPos;ILnet/minecraft/world/poi/PointOfInterestStorage$OccupationStatus;)Ljava/util/Optional;"), index=2)
    private static int modifyShouldRunGetNearestPositionArgs(int range) {
        return LibertyVillagersMod.CONFIG.villagerPathfindingConfig.findPOIRange;
    }

    @Inject(method={"method_47054"}, at={@At(value="HEAD")})
    private static void runHead(MutableLong mutableLong, Long2LongMap map, MemoryAccessor result, float speed, ServerLevel serverWorld, PathfinderMob entity, long time, CallbackInfoReturnable<Boolean> cir) {
        world = serverWorld;
    }

    @Redirect(method={"method_47054"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/poi/PointOfInterestStorage;getTypesAndPositions(Ljava/util/function/Predicate;Ljava/util/function/Predicate;Lnet/minecraft/util/math/BlockPos;ILnet/minecraft/world/poi/PointOfInterestStorage$OccupationStatus;)Ljava/util/stream/Stream;"))
    private static Stream<Pair<Holder<PoiType>, BlockPos>> modifyGetTypesAndPositions(PoiManager pointOfInterestStorage, Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus) {
        Predicate<BlockPos> newBlockPosPredicate = blockPos -> {
            if (WalkHomeTaskMixin.isBedOccupied(world, blockPos)) {
                return false;
            }
            return posPredicate.test((BlockPos)blockPos);
        };
        Stream stream = pointOfInterestStorage.m_217994_(typePredicate, newBlockPosPredicate, pos, LibertyVillagersMod.CONFIG.villagerPathfindingConfig.findPOIRange, PoiManager.Occupancy.HAS_SPACE);
        Set set = stream.collect(Collectors.toSet());
        if (!set.isEmpty()) {
            return set.stream();
        }
        return pointOfInterestStorage.m_217994_(typePredicate, posPredicate, pos, LibertyVillagersMod.CONFIG.villagerPathfindingConfig.findPOIRange, occupationStatus);
    }

    private static boolean isBedOccupied(ServerLevel world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        return blockState.m_204336_(BlockTags.f_13038_) && (Boolean)blockState.m_61143_((Property)BedBlock.f_49441_) != false;
    }
}

