/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.tasks;

import com.gitsh01.libertyvillagers.tasks.HealTargetTask;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FeedTargetTask
extends HealTargetTask {
    private static final int COMPLETION_RANGE = 3;
    private final Class<? extends LivingEntity> entityClass;
    private final ImmutableSet<Item> foodTypes;
    private final double range;
    private final int maxEntities;

    public FeedTargetTask(Class<? extends LivingEntity> entityClass, ImmutableSet<Item> foodTypes, double range, int maxEntities) {
        super(3);
        this.entityClass = entityClass;
        this.foodTypes = foodTypes;
        this.range = range;
        this.maxEntities = maxEntities;
    }

    @Override
    protected List<LivingEntity> getPossiblePatients(ServerLevel serverWorld, Villager villagerEntity) {
        if (!villagerEntity.m_35311_().m_18949_(this.foodTypes)) {
            return Lists.newArrayList();
        }
        List possiblePatients = villagerEntity.m_9236_().m_45976_(this.entityClass, villagerEntity.m_20191_().m_82400_(this.range));
        if (possiblePatients.size() >= this.maxEntities) {
            return Lists.newArrayList();
        }
        return possiblePatients;
    }

    @Override
    protected void healTarget(ServerLevel serverWorld, Villager villagerEntity, LivingEntity currentPatient) {
        if (!(currentPatient instanceof Animal)) {
            return;
        }
        Animal animal = (Animal)currentPatient;
        if (!animal.m_5957_()) {
            return;
        }
        SimpleContainer simpleInventory = villagerEntity.m_35311_();
        if (!simpleInventory.m_18949_(this.foodTypes)) {
            return;
        }
        for (int i = 0; i < simpleInventory.m_6643_(); ++i) {
            ItemStack itemStack = simpleInventory.m_8020_(i);
            if (itemStack.m_41619_() || !this.foodTypes.contains((Object)itemStack.m_41720_())) continue;
            animal.m_27595_(null);
            itemStack.m_41774_(1);
            break;
        }
    }

    @Override
    protected boolean isValidPatient(LivingEntity entity) {
        if (!(entity instanceof Animal)) {
            return false;
        }
        Animal animal = (Animal)entity;
        return entity != null && entity.m_6084_() && !entity.m_20145_() && !entity.m_20147_() && animal.m_5957_() && !animal.m_6162_();
    }
}

