/*
 * Decompiled with CFR 0.152.
 */
package com.gitsh01.libertyvillagers.tasks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import org.jetbrains.annotations.Nullable;

public abstract class HealTargetTask
extends Behavior<Villager> {
    public static final float WALK_SPEED = 0.7f;
    private static final int MAX_RUN_TIME = 1000;
    @Nullable
    private LivingEntity currentPatient;
    private long nextResponseTime;
    private int ticksRan;
    private int completionRange;

    public HealTargetTask(int completionRange) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26360_, (Object)MemoryStatus.VALUE_PRESENT), 1000);
        this.completionRange = completionRange;
    }

    protected abstract List<LivingEntity> getPossiblePatients(ServerLevel var1, Villager var2);

    protected boolean shouldRun(ServerLevel serverWorld, Villager villagerEntity) {
        List<LivingEntity> possiblePatients = this.getPossiblePatients(serverWorld, villagerEntity);
        ArrayList patients = Lists.newArrayList();
        for (LivingEntity possiblePatient : possiblePatients) {
            if (!this.isValidPatient(possiblePatient)) continue;
            patients.add(possiblePatient);
        }
        if (patients.size() == 0) {
            return false;
        }
        this.currentPatient = (LivingEntity)patients.get(serverWorld.m_213780_().m_188503_(patients.size()));
        return this.currentPatient != null;
    }

    protected void run(ServerLevel serverWorld, Villager villagerEntity, long l) {
        if (l > this.nextResponseTime && this.currentPatient != null) {
            villagerEntity.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)this.currentPatient, true));
            villagerEntity.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget((Entity)this.currentPatient, 0.7f, this.completionRange));
        }
    }

    protected void finishRunning(ServerLevel serverWorld, Villager villagerEntity, long l) {
        villagerEntity.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        villagerEntity.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        this.ticksRan = 0;
        this.nextResponseTime = l + 40L;
    }

    protected void keepRunning(ServerLevel serverWorld, Villager villagerEntity, long l) {
        if (!this.isValidPatient(this.currentPatient)) {
            return;
        }
        if (this.currentPatient.m_20270_((Entity)villagerEntity) <= (float)this.completionRange) {
            this.healTarget(serverWorld, villagerEntity, this.currentPatient);
            this.currentPatient = null;
            ++this.ticksRan;
        }
    }

    protected abstract void healTarget(ServerLevel var1, Villager var2, LivingEntity var3);

    protected boolean shouldKeepRunning(ServerLevel serverWorld, Villager villagerEntity, long l) {
        if (!this.isValidPatient(this.currentPatient)) {
            return false;
        }
        return this.ticksRan < 1000;
    }

    protected boolean isValidPatient(LivingEntity entity) {
        return entity != null && !(entity.m_21223_() >= entity.m_21233_()) && entity.m_6084_() && !entity.m_20145_() && !entity.m_20147_() && !entity.m_21023_(MobEffects.f_19605_);
    }
}

