/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.config;

import java.util.HashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.util.Utils;

public class MandatoryFun {
    public static HashMap<String, Boolean> configReqs = null;

    public static void completeFunReq(Player player, FUN_REQS req) {
        IMahou mahou;
        if (player instanceof ServerPlayer && (mahou = Utils.getPlayerMahou(player)) != null) {
            HashMap<String, Boolean> fun = mahou.getMandatoryFun();
            if (fun == null) {
                fun = new HashMap();
            }
            fun.put(req.name(), true);
            mahou.setMandatoryFun(fun);
            PlayerManaManager.updateClientMahou((ServerPlayer)player, mahou);
        }
    }

    public static boolean meetsFunReq(Player player, FUN_REQS req) {
        IMahou mahou = Utils.getPlayerMahou(player);
        HashMap<String, Boolean> fun = mahou.getMandatoryFun();
        return fun != null && fun.containsKey(req.name()) && fun.get(req.name()) != false;
    }

    public static boolean meetsAllFunReqs(Player player) {
        if (MTConfig.CALIBURN_FUN_REQUIRED && !MTConfig.CALIBURN_MANDATORY_FUN_REQUIREMENTS.isEmpty()) {
            if (configReqs == null) {
                configReqs = MandatoryFun.getConfigRequirements();
            }
            for (FUN_REQS req : FUN_REQS.values()) {
                if (!configReqs.containsKey(req.name()) || !configReqs.get(req.name()).booleanValue() || MandatoryFun.meetsFunReq(player, req)) continue;
                return false;
            }
        }
        return true;
    }

    public static HashMap<String, Boolean> getConfigRequirements() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (FUN_REQS req : FUN_REQS.values()) {
            if (MTConfig.CALIBURN_MANDATORY_FUN_REQUIREMENTS.contains(req.name())) {
                map.put(req.name(), true);
                continue;
            }
            map.put(req.name(), false);
        }
        return map;
    }

    public static enum FUN_REQS {
        EMRYS_HIT_PHANTOM,
        SHOOT_A_SWORD,
        SPATIAL_THROW_SOMETHING,
        BORROWED_AUTHORITY_PUNCH,
        BUTTERFLY_FUTURE_BLOCK_REMOVE,
        GEAS_PICKUP_CANCEL,
        CREEPER_BINDING_EYES,
        CREEPER_POSSESSION,
        SWAP_TWO_THINGS;

    }
}

