/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.render.GifLoader;

public class ThreadDownloadImageData
extends SimpleTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final AtomicInteger TEXTURE_DOWNLOADER_THREAD_ID = new AtomicInteger(0);
    @Nullable
    private final File cacheFile;
    private final String imageUrl;
    @Nullable
    private Thread imageThread;
    private final Runnable onDownloaded;
    private boolean uploaded;
    private boolean isgif;
    private SimpleTexture[] gifframes;
    public ResourceLocation loc;

    public ThreadDownloadImageData(@Nullable File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocation, @Nullable BufferedImage imageBufferIn, @Nullable Runnable runnable, ResourceLocation loc) {
        super(textureResourceLocation);
        this.cacheFile = cacheFileIn;
        this.imageUrl = imageUrlIn;
        this.onDownloaded = runnable;
        this.loc = loc;
    }

    public int m_117963_() {
        return super.m_117963_();
    }

    public void m_6704_(ResourceManager resourceManager) throws IOException {
        Minecraft.m_91087_().execute(() -> {
            if (!this.uploaded) {
                try {
                    super.m_6704_(resourceManager);
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Failed to load texture: {}", (Object)this.f_118129_, (Object)ioexception);
                }
                this.uploaded = true;
            }
        });
        if (this.imageThread == null) {
            NativeImage nativeimage;
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                MahouTsukaiMod.logger.info("Loading http texture from local cache ({})", (Object)this.cacheFile);
                FileInputStream fileinputstream = new FileInputStream(this.cacheFile);
                nativeimage = this.load(fileinputstream);
            } else {
                nativeimage = null;
            }
            if (nativeimage != null) {
                this.loadCallback(nativeimage);
            } else {
                this.loadTextureFromServer();
            }
        }
    }

    protected void loadTextureFromServer() {
        this.imageThread = new Thread("Texture Downloader #" + TEXTURE_DOWNLOADER_THREAD_ID.incrementAndGet()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpURLConnection httpurlconnection = null;
                MahouTsukaiMod.logger.info("Downloading http texture from {} to {}", (Object)ThreadDownloadImageData.this.imageUrl, (Object)ThreadDownloadImageData.this.cacheFile);
                try {
                    httpurlconnection = (HttpURLConnection)new URL(ThreadDownloadImageData.this.imageUrl).openConnection(Minecraft.m_91087_().m_91096_());
                    httpurlconnection.setDoInput(true);
                    httpurlconnection.setRequestProperty("Accept", "image/*");
                    httpurlconnection.setDoOutput(false);
                    httpurlconnection.connect();
                    if (httpurlconnection.getResponseCode() / 100 == 2) {
                        InputStream inputstream;
                        if (ThreadDownloadImageData.this.cacheFile != null) {
                            FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)ThreadDownloadImageData.this.cacheFile);
                            inputstream = new FileInputStream(ThreadDownloadImageData.this.cacheFile);
                        } else {
                            inputstream = httpurlconnection.getInputStream();
                        }
                        byte[] bytes = inputstream.readAllBytes();
                        ByteArrayInputStream newInputStream = new ByteArrayInputStream(bytes);
                        if (GifLoader.isGIF(bytes)) {
                            NativeImage gif = GifLoader.loadGif(newInputStream, ThreadDownloadImageData.this.loc);
                            if (gif != null) {
                                ThreadDownloadImageData.this.loadCallback(gif);
                            }
                        } else {
                            NativeImage nativeimage1 = ThreadDownloadImageData.this.load(newInputStream);
                            if (nativeimage1 != null) {
                                ThreadDownloadImageData.this.loadCallback(nativeimage1);
                            }
                        }
                        return;
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Couldn't download http texture", (Throwable)exception);
                    return;
                }
                finally {
                    if (httpurlconnection != null) {
                        httpurlconnection.disconnect();
                    }
                }
            }
        };
        this.imageThread.setDaemon(true);
        this.imageThread.start();
    }

    private void loadCallback(NativeImage p_118011_) {
        if (this.onDownloaded != null) {
            this.onDownloaded.run();
        }
        Minecraft.m_91087_().execute(() -> {
            this.uploaded = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.upload(p_118011_));
            } else {
                this.upload(p_118011_);
            }
        });
    }

    @Nullable
    private NativeImage load(InputStream p_118019_) {
        NativeImage nativeimage = null;
        try {
            nativeimage = NativeImage.m_85058_((InputStream)p_118019_);
        }
        catch (Exception exception) {
            LOGGER.warn("Error while loading the skin texture", (Throwable)exception);
        }
        return nativeimage;
    }

    private void upload(NativeImage p_118021_) {
        TextureUtil.prepareImage((int)this.m_117963_(), (int)p_118021_.m_84982_(), (int)p_118021_.m_85084_());
        p_118021_.m_85040_(0, 0, 0, true);
    }
}

