/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.entity.mahoujin.GunEntity;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderGunEntity
extends EntityRenderer<GunEntity> {
    public static final ResourceLocation gun = new ResourceLocation("mahoutsukai:textures/block/gun_pattern.png");

    public RenderGunEntity(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(GunEntity entity) {
        return TextureAtlas.f_118259_;
    }

    public void render(GunEntity entity, float eyaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
    }

    public static void renderGun(GunEntity entity, double x, double y, double z, PoseStack matrix, float partialTicks) {
        float size = entity.getCircleSize();
        size = 4.0f;
        float ryaw = 90.0f + entity.f_19859_ + (entity.f_19857_ - entity.f_19859_) * partialTicks;
        float rpitch = 135.0f - entity.f_19860_ + (entity.f_19858_ - entity.f_19860_) * partialTicks;
        float yRotate = -90.0f + entity.f_19859_ + (entity.f_19857_ - entity.f_19859_) * partialTicks;
        float pRotate = 90.0f + entity.f_19860_ + (entity.f_19858_ - entity.f_19860_) * partialTicks;
        matrix.m_85836_();
        RenderGunEntity.renderGun(x, y, z, yRotate, pRotate, 0.0f, size, matrix, partialTicks);
        matrix.m_85849_();
    }

    public static void renderGun(double x, double y, double z, float yRot, float pRot, float dRot, float size, PoseStack matrix, float partialTicks) {
        matrix.m_85836_();
        matrix.m_85837_(x, y, z);
        RenderUtils.rotateQ(dRot, 0.0f, 0.0f, 1.0f, matrix);
        RenderUtils.rotateQ(yRot, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pRot, 0.0f, 1.0f, 0.0f, matrix);
        matrix.m_85841_(size, size, size);
        float[] bottom_barrel_color = new float[]{0.4f, 0.26f, 0.36f, 1.0f};
        float[] top_barrel_color = new float[]{0.15f, 0.1f, 0.1f, 1.0f};
        float[] ornament_color = new float[]{0.8345f, 0.7796f, 0.5051f, 1.0f};
        float[] top_barrel_measure = new float[]{1.04f, 0.025f, 0.75f, 0.0f, 0.025f, 0.025f, 0.0f, 1.0f};
        float[] bottom_barrel_measure = new float[]{1.0f, 0.04f, 0.75f, 0.04f, 0.0f, 0.04f, 0.0f, 1.0f};
        float[] ornament1_measure = new float[]{0.032f, 0.05f, 0.65f, 0.34f, -0.0025f, 0.05f, 0.25f, 0.4f};
        float[] ornament2_measure = new float[]{0.024f, 0.05f, 0.65f, 0.72f, -0.0025f, 0.05f, 0.6f, 0.75f};
        float[] ornament3_measure = new float[]{0.2f, 0.06f, 0.3f, 0.98f, 0.0f, 0.08f, 0.2f, 0.8f};
        float[] stock_measure = new float[]{0.04f, 0.04f, 0.75f, 1.18f, 0.005f, 0.055f, 0.25f, 0.5f};
        float[] circle_measure = new float[]{0.24f, 0.24f, -0.05f, 1.08f, 0.005f, 0.055f, 0.25f, 0.5f};
        float[] circle2_measure = new float[]{0.22f, 0.22f, 0.05f, 1.08f, 0.005f, 0.055f, 0.25f, 0.5f};
        MultiBufferSource.BufferSource buf = Minecraft.m_91087_().m_91269_().m_110104_();
        int lx = 240;
        int ly = 240;
        RenderGunEntity.renderBarrel(bottom_barrel_color, bottom_barrel_measure, lx, ly, matrix, buf);
        RenderGunEntity.renderBarrel(ornament_color, ornament1_measure, lx, ly, matrix, buf);
        RenderGunEntity.renderBarrel(ornament_color, ornament2_measure, lx, ly, matrix, buf);
        RenderGunEntity.renderBarrel(ornament_color, ornament3_measure, lx, ly, matrix, buf);
        RenderGunEntity.renderBarrel(top_barrel_color, top_barrel_measure, lx, ly, matrix, buf);
        RenderGunEntity.renderStock(bottom_barrel_color, stock_measure, lx, ly, matrix, buf);
        RenderGunEntity.renderMahoujin(ornament_color, circle_measure, Minecraft.m_91087_().f_91073_.m_46467_(), lx, ly, matrix, buf);
        RenderGunEntity.renderMahoujin(ornament_color, circle2_measure, Minecraft.m_91087_().f_91073_.m_46467_(), lx, ly, matrix, buf);
        matrix.m_85849_();
    }

    public static void renderBarrel(float[] rgba, float[] measures, int lx, int ly, PoseStack matrix, MultiBufferSource.BufferSource buf) {
        float r = rgba[0];
        float g = rgba[1];
        float b = rgba[2];
        float a = rgba[3];
        float len = measures[0];
        float size = measures[1];
        float thickness = measures[2];
        float zPos = measures[3];
        float yPos = measures[4];
        float height = measures[5];
        float u = measures[6];
        float v = measures[7];
        matrix.m_85836_();
        matrix.m_252880_(yPos, 0.0f, zPos);
        RenderGunEntity.renderRectPrism(r, g, b, a, size, len, height, 240, 240, matrix, buf, u, v);
        RenderGunEntity.renderRectPrism(r - 0.1f, g - 0.1f, b - 0.1f, a, size * thickness, len, height * thickness, lx, ly, matrix, buf, u, v);
        RenderGunEntity.renderHollowSquare(r - 0.05f, g - 0.05f, b - 0.05f, a, size, len, height, 0.0f, thickness, lx, ly, matrix, buf);
        RenderGunEntity.renderHollowSquare(r - 0.05f, g - 0.05f, b - 0.05f, a, size, len, height, 1.0f, thickness, lx, ly, matrix, buf);
        matrix.m_85849_();
    }

    public static void renderRectPrism(float r, float g, float b, float a, float size, float len, float height, int lx, int ly, PoseStack matrix, MultiBufferSource.BufferSource buf, float u, float v) {
        RenderType type = MahoujinRenderType.createBoxRenderType(gun, 0);
        VertexConsumer bb = buf.m_6299_(type);
        matrix.m_85836_();
        matrix.m_85841_(height, size, len);
        Matrix4f m = matrix.m_85850_().m_252922_();
        bb.m_252986_(m, -0.5f, -0.5f, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, u).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -0.5f, -0.5f, 1.0f).m_85950_(r, g, b, a).m_7421_(0.0f, v).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -0.5f, 0.5f, 0.0f).m_85950_(r, g, b, a).m_7421_(0.25f, u).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -0.5f, 0.5f, 1.0f).m_85950_(r, g, b, a).m_7421_(0.25f, v).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, 0.5f, 0.5f, 0.0f).m_85950_(r, g, b, a).m_7421_(0.5f, u).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, 0.5f, 0.5f, 1.0f).m_85950_(r, g, b, a).m_7421_(0.5f, v).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, 0.5f, -0.5f, 0.0f).m_85950_(r, g, b, a).m_7421_(0.75f, u).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, 0.5f, -0.5f, 1.0f).m_85950_(r, g, b, a).m_7421_(0.75f, v).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -0.5f, -0.5f, 0.0f).m_85950_(r, g, b, a).m_7421_(1.0f, u).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -0.5f, -0.5f, 1.0f).m_85950_(r, g, b, a).m_7421_(1.0f, v).m_7120_(lx, ly).m_5752_();
        buf.m_109912_(type);
        matrix.m_85849_();
    }

    public static void renderHollowSquare(float r, float g, float b, float a, float size, float len, float height, float zPos, float thickness, int lx, int ly, PoseStack matrix, MultiBufferSource.BufferSource buf) {
        RenderType type = MahoujinRenderType.createHollowSquareRenderType(gun, 0, false);
        matrix.m_85836_();
        matrix.m_85841_(height, size, len);
        Matrix4f m = matrix.m_85850_().m_252922_();
        float outer = 0.5f;
        float inner = 0.5f * thickness;
        VertexConsumer bb = buf.m_6299_(type);
        bb.m_252986_(m, -inner, -inner, zPos).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -outer, -inner, zPos).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -outer, outer, zPos).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -inner, outer, zPos).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        buf.m_109912_(type);
        bb = buf.m_6299_(type);
        bb.m_252986_(m, -inner, inner, zPos).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -inner, outer, zPos).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, outer, outer, zPos).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, outer, inner, zPos).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        buf.m_109912_(type);
        bb = buf.m_6299_(type);
        bb.m_252986_(m, inner, inner, zPos).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, outer, inner, zPos).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, outer, -outer, zPos).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, inner, -outer, zPos).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        buf.m_109912_(type);
        bb = buf.m_6299_(type);
        bb.m_252986_(m, inner, -inner, zPos).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, inner, -outer, zPos).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -outer, -outer, zPos).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -outer, -inner, zPos).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        buf.m_109912_(type);
        matrix.m_85849_();
    }

    public static void renderStock(float[] rgba, float[] measures, int lx, int ly, PoseStack matrix, MultiBufferSource.BufferSource buf) {
        VertexConsumer bb;
        RenderType type = MahoujinRenderType.createBoxRenderType(gun, 0);
        float r = rgba[0];
        float g = rgba[1];
        float b = rgba[2];
        float a = rgba[3];
        float len = measures[0];
        float size = measures[1];
        float thickness = measures[2];
        float zPos = measures[3];
        float yPos = measures[4];
        float height = measures[5];
        matrix.m_85836_();
        matrix.m_252880_(yPos, 0.0f, zPos);
        matrix.m_85841_(height, size, len);
        Matrix4f m = matrix.m_85850_().m_252922_();
        int angle = 30;
        int pieces = 20;
        float x1 = -0.5f;
        float x2 = 0.5f;
        float y1 = -0.5f;
        float y2 = 0.5f;
        float z1 = -0.5f;
        float z2 = 0.5f;
        float Ax = x1;
        float Az = z1;
        float Bx = x2;
        float Bz = z1;
        float Cx = x1;
        float Cz = z2;
        float Dx = x2;
        float Dz = z2;
        float[] diffsCz = new float[]{0.0f, 1.2f, 3.0f, 4.5f, 6.2f, 7.2f, 8.0f, 8.5f, 8.6f};
        float[] diffsDz = new float[]{0.0f, 0.8f, 1.6f, 2.1f, 2.5f, 2.8f, 3.0f, 3.1f, 3.05f};
        float[] diffsCx = new float[]{0.0f, 0.0f, 1.5f, 3.5f, 3.2f};
        float[] diffsDx = new float[]{0.0f, 0.2f, 0.4f, 1.8f, 3.4f};
        float scale = 0.7f;
        float darken = 0.003f;
        float czdiff = 0.0f;
        float dzdiff = 0.0f;
        for (int p = 0; p < pieces; ++p) {
            r -= darken;
            g -= darken;
            b -= darken;
            czdiff = 1.0f + RenderGunEntity.parabola(p, 0.015f, 2.0f);
            dzdiff = 1.0f + RenderGunEntity.parabola(p, 0.004f, 2.0f);
            Cx = x1 + RenderGunEntity.parabola_bottom(dzdiff) * scale;
            Cz = z2 + dzdiff * scale;
            Dx = x2 + RenderGunEntity.parabola_top(czdiff) * scale;
            Dz = z2 + czdiff * scale;
            bb = buf.m_6299_(type);
            bb.m_252986_(m, Ax, y1, Az).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
            bb.m_252986_(m, Cx, y1, Cz).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
            bb.m_252986_(m, Ax, y2, Az).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
            bb.m_252986_(m, Cx, y2, Cz).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
            bb.m_252986_(m, Bx, y2, Bz).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
            bb.m_252986_(m, Dx, y2, Dz).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
            bb.m_252986_(m, Bx, y1, Bz).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
            bb.m_252986_(m, Dx, y1, Dz).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
            bb.m_252986_(m, Ax, y1, Az).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
            bb.m_252986_(m, Cx, y1, Cz).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
            buf.m_109912_(type);
            Ax = Cx;
            Az = Cz;
            Bx = Dx;
            Bz = Dz;
        }
        bb = buf.m_6299_(type);
        bb.m_252986_(m, Cx, y1, Cz).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, Dx, y1, Dz).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, Cx, y2, Cz).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, Dx, y2, Dz).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        buf.m_109912_(type);
        matrix.m_85849_();
    }

    public static float parabola_top(float input) {
        return RenderGunEntity.parabola(input, -0.0012f, 4.0f);
    }

    public static float parabola_bottom(float input) {
        return RenderGunEntity.parabola(input, -0.09f, 3.0f);
    }

    public static float parabola(float input, float scale, float power) {
        float ret = scale * (float)Math.pow(input, power);
        return ret;
    }

    public static void renderMahoujin(float[] rgba, float[] measures, float angle, int lx, int ly, PoseStack matrix, MultiBufferSource.BufferSource buf) {
        float r = rgba[0];
        float g = rgba[1];
        float b = rgba[2];
        float a = rgba[3];
        float len = measures[0];
        float size = measures[1];
        float thickness = measures[2];
        float zPos = measures[3];
        float yPos = measures[4];
        float height = measures[5];
        float u = measures[6];
        float v = measures[7];
        matrix.m_85836_();
        matrix.m_252880_(yPos, thickness, zPos);
        RenderUtils.rotateQ(angle, 0.0f, 1.0f, 0.0f, matrix);
        matrix.m_85841_(size, 1.0f, size);
        RenderType type = MahoujinRenderType.createMahoujinRenderType(RenderUtils.mahoujin, 0, false);
        Matrix4f m = matrix.m_85850_().m_252922_();
        VertexConsumer bb = buf.m_6299_(type);
        bb.m_252986_(m, 0.5f, 0.0f, 0.5f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -0.5f, 0.0f, 0.5f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -0.5f, 0.0f, -0.5f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, 0.5f, 0.0f, -0.5f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        buf.m_109912_(type);
        matrix.m_85849_();
    }
}

