/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import stepsword.mahoutsukai.item.FaeEssence;
import stepsword.mahoutsukai.item.catalysts.PowderedCatalyst;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.UpdatingTileEntity;
import stepsword.mahoutsukai.util.UnorderedList;

public class MahoujinTileEntity
extends UpdatingTileEntity {
    private UUID casterUUID;
    private boolean cloth;
    private boolean fay;
    public static final String ORDER_TAG = "catalyst_order";
    public static final String CASTER_ID = "caster_uuid";
    public static final String CLOTH_BOOLEAN = "cloth";
    public static final String FAY_TAG = "fay";
    private UnorderedList catalysts;

    public MahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.mahoujin.get(), p, bs);
    }

    public MahoujinTileEntity(BlockEntityType type, BlockPos p, BlockState bs) {
        super(type, p, bs);
    }

    public void m_183515_(CompoundTag compound) {
        CompoundTag order = new CompoundTag();
        if (this.catalysts == null) {
            this.catalysts = new UnorderedList();
        }
        ArrayList<String> orderList = this.catalysts.getOrder();
        for (int i = 0; i < orderList.size(); ++i) {
            order.m_128359_("" + i, orderList.get(i));
        }
        compound.m_128365_(ORDER_TAG, (Tag)order);
        compound.m_128379_(FAY_TAG, this.fay);
        if (this.casterUUID != null) {
            compound.m_128362_(CASTER_ID, this.casterUUID);
        }
        compound.m_128379_(CLOTH_BOOLEAN, this.cloth);
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        ArrayList<String> order = new ArrayList<String>();
        CompoundTag orderTag = (CompoundTag)compound.m_128423_(ORDER_TAG);
        for (int i = 0; i < orderTag.m_128431_().size(); ++i) {
            order.add(orderTag.m_128461_("" + i));
        }
        this.catalysts = new UnorderedList(order);
        this.casterUUID = compound.m_128342_(CASTER_ID);
        this.cloth = compound.m_128471_(CLOTH_BOOLEAN);
        this.fay = compound.m_128471_(FAY_TAG);
        super.m_142466_(compound);
    }

    public UnorderedList getCatalysts() {
        return this.catalysts;
    }

    public void setCatalysts(UnorderedList catalysts) {
        this.catalysts = catalysts;
        this.sendUpdates();
    }

    public int getNumCatalysts() {
        return this.catalysts == null ? 0 : this.catalysts.size();
    }

    public boolean addCatalyst(PowderedCatalyst catalyst) {
        if (this.catalysts == null) {
            this.catalysts = new UnorderedList();
        }
        if (this.catalysts.size() >= 3) {
            this.sendUpdates();
            return false;
        }
        this.catalysts.add(catalyst.getCatalystName(), true);
        this.sendUpdates();
        return true;
    }

    public Player getCaster() {
        if (this.casterUUID == null || this.casterUUID.equals(UUID.fromString("00000000-0000-0000-0000-000000000000")) || this.casterUUID.equals(FaeEssence.faeID)) {
            return null;
        }
        if (this.f_58857_ instanceof ServerLevel && this.f_58857_.m_7654_() != null) {
            return this.f_58857_.m_7654_().m_6846_().m_11259_(this.casterUUID);
        }
        if (this.f_58857_ != null) {
            return this.f_58857_.m_46003_(this.casterUUID);
        }
        return null;
    }

    public UUID getCasterUUID() {
        return this.casterUUID;
    }

    public void setCasterUUID(UUID casterUUID) {
        this.casterUUID = casterUUID;
        this.sendUpdates();
    }

    public void setCaster(Player caster) {
        this.casterUUID = caster.m_20148_();
        this.sendUpdates();
    }

    public boolean hasCloth() {
        return this.cloth;
    }

    public void setCloth(boolean c) {
        this.cloth = c;
    }

    public boolean isFay() {
        return this.fay;
    }

    public void setFay(boolean c) {
        this.fay = c;
    }
}

