/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.replica;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.registries.ForgeRegistries;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.StrengtheningSpellEffect;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.MagicalItemRender;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.ReplicaKnockbackParticlePacket;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.item.ReplicaRenderer;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;
import stepsword.mahoutsukai.util.PlayerHelp;
import stepsword.mahoutsukai.util.Utils;

public class Replica
extends ItemBase {
    public static HashMap<String, DamageSource> DAMAGE_SOURCE_REGISTRY = new HashMap();

    public Replica() {
        super("replica", new Item.Properties().m_41487_(1).m_41503_(MTConfig.REPLICA_DURABILITY));
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand handIn) {
        ItemStack itemstack = player.m_21120_(handIn);
        if (!player.m_9236_().f_46443_ && player.m_20142_()) {
            Replica.coverMove(player);
        }
        player.m_6672_(handIn);
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public void m_5929_(Level level, LivingEntity player, ItemStack stack, int count) {
        if (count == 72000 && !player.m_9236_().f_46443_ && player instanceof Player) {
            if (!player.m_20142_() && player.m_20163_()) {
                Replica.saveTeleportLocation(stack, (Player)player);
            }
            if (!EffectUtil.hasBuff(player, ModEffects.REPLICA_SHOCKWAVE_COOLDOWN) && PlayerManaManager.drainMana((Player)player, MTConfig.REPLICA_ATTACK_MANA_COST, false, false) == MTConfig.REPLICA_ATTACK_MANA_COST) {
                this.bigKnockback((Player)player, stack);
                EffectUtil.buff(player, ModEffects.REPLICA_SHOCKWAVE_COOLDOWN, false, MTConfig.REPLICA_SHOCKWAVE_COOLDOWN, false);
            }
        }
        player.m_20334_(0.0, 0.0, 0.0);
        player.f_19864_ = true;
    }

    public void bigKnockback(Player playerIn, ItemStack stack) {
        double maxRadius = MTConfig.REPLICA_ATTACK_RANGE;
        ReplicaKnockbackParticlePacket packet = new ReplicaKnockbackParticlePacket(playerIn.m_20185_(), playerIn.m_20186_() + (double)(playerIn.m_20206_() / 2.0f), playerIn.m_20189_(), 0.2f, 0.2f, 0.2f);
        PacketHandler.sendTracking((Entity)playerIn, packet);
        PacketHandler.sendTo((ServerPlayer)playerIn, packet);
        List lst = playerIn.m_9236_().m_45976_(LivingEntity.class, new AABB(playerIn.m_20185_() - maxRadius, playerIn.m_20186_() - maxRadius, playerIn.m_20189_() - maxRadius, playerIn.m_20185_() + maxRadius, playerIn.m_20186_() + maxRadius, playerIn.m_20189_() + maxRadius));
        int multiplier = 0;
        double damage = MTConfig.REPLICA_BASE_DAMAGE;
        for (LivingEntity e : lst) {
            if (!ContractMahoujinTileEntity.isImmuneToSpell(playerIn.m_9236_(), playerIn.m_20148_(), (Entity)e)) continue;
            ++multiplier;
        }
        for (LivingEntity e : lst) {
            if (ContractMahoujinTileEntity.isImmuneToSpell(playerIn.m_9236_(), playerIn.m_20148_(), (Entity)e)) continue;
            String type = Replica.getDamageTypeForSlot(stack, Replica.getSelectedSlot(stack));
            DamageSource source = Replica.getDamageSource(type, (LivingEntity)playerIn);
            e.m_6469_(source, (float)Math.min((double)multiplier * damage, MTConfig.REPLICA_MAX_DAMAGE));
            Vec3 v = e.m_20182_().m_82546_(playerIn.m_20182_());
            this.boop((Entity)e, 3.0f, -v.f_82479_, -v.f_82480_, -v.f_82481_);
        }
    }

    public static void coverMove(Player player) {
        double totalRange = MTConfig.REPLICA_COVER_MOVE_RANGE;
        Vec3 myloc = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_());
        List lst = player.m_9236_().m_45976_(LivingEntity.class, new AABB(player.m_20185_() - totalRange, player.m_20186_() - totalRange, player.m_20189_() - totalRange, player.m_20185_() + totalRange, player.m_20186_() + totalRange, player.m_20189_() + totalRange));
        ArrayList<LivingEntity> inRange = new ArrayList<LivingEntity>();
        HashSet<LivingEntity> needsHelp = new HashSet<LivingEntity>();
        HashSet<LivingEntity> players = new HashSet<LivingEntity>();
        for (LivingEntity tmp : lst) {
            if (!EffectUtil.inRange(tmp, (LivingEntity)player, myloc, (int)totalRange, false) || !ContractMahoujinTileEntity.isImmuneToSpell(player.m_9236_(), player.m_20148_(), (Entity)tmp) || player == tmp) continue;
            inRange.add(tmp);
            if (tmp instanceof Player) {
                players.add(tmp);
            }
            if (!Replica.needsHelp(tmp)) continue;
            needsHelp.add(tmp);
        }
        Collections.sort(inRange, Replica.getDistanceSorter((LivingEntity)player));
        LivingEntity e = Replica.coverMoveTarget(inRange, needsHelp, players);
        if (e != null) {
            Vec3 facing = Replica.coverMoveFacing(e);
            if (facing == null) {
                MahouTsukaiTeleporter.teleport((Entity)player, EffectUtil.getDimension(player.m_9236_()), e.m_20182_().m_82549_(new Vec3(1.0, 0.0, 0.0)));
                player.f_19864_ = true;
            } else {
                facing = facing.m_82541_();
                float pitch = (float)Math.asin(-facing.f_82480_);
                float yaw = (float)Math.atan2(facing.f_82479_, facing.f_82481_);
                player.f_19857_ = EffectUtil.toDegrees(-yaw);
                player.f_19858_ = EffectUtil.toDegrees(pitch);
                MahouTsukaiTeleporter.teleport((Entity)player, EffectUtil.getDimension(player.m_9236_()), e.m_20182_().m_82549_(facing.m_82490_(0.2)));
                player.f_19864_ = true;
            }
        }
    }

    public static LivingEntity coverMoveTarget(ArrayList<LivingEntity> inRange, HashSet<LivingEntity> needsHelp, HashSet<LivingEntity> players) {
        for (LivingEntity living : inRange) {
            if (!needsHelp.contains(living) || !players.contains(living)) continue;
            return living;
        }
        for (LivingEntity living : inRange) {
            if (!needsHelp.contains(living)) continue;
            return living;
        }
        for (LivingEntity living : inRange) {
            if (!players.contains(living)) continue;
            return living;
        }
        Iterator<LivingEntity> iterator = inRange.iterator();
        if (iterator.hasNext()) {
            LivingEntity living;
            living = iterator.next();
            return living;
        }
        return null;
    }

    public static void saveTeleportLocation(ItemStack s, Player player) {
        Vec3 save = player.m_20182_();
        CompoundTag nbt = s.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128347_("mahou_teleport_x", save.f_82479_);
        nbt.m_128347_("mahou_teleport_y", save.f_82480_);
        nbt.m_128347_("mahou_teleport_z", save.f_82481_);
        nbt.m_128359_("mahou_teleport_dim", EffectUtil.getDimension(player.m_9236_()).toString());
        s.m_41751_(nbt);
    }

    public static Vec3 getTeleportLocation(ItemStack s) {
        CompoundTag nbt = s.m_41783_();
        if (nbt != null && nbt.m_128441_("mahou_teleport_x") && nbt.m_128441_("mahou_teleport_y") && nbt.m_128441_("mahou_teleport_z")) {
            return new Vec3(nbt.m_128459_("mahou_teleport_x"), nbt.m_128459_("mahou_teleport_y"), nbt.m_128459_("mahou_teleport_z"));
        }
        return null;
    }

    public static ResourceLocation getTeleportDimension(ItemStack s) {
        CompoundTag nbt = s.m_41783_();
        if (nbt != null && nbt.m_128441_("mahou_teleport_dim")) {
            return new ResourceLocation(nbt.m_128461_("mahou_teleport_dim"));
        }
        return null;
    }

    public static boolean getFriendlyOnly(ItemStack s) {
        CompoundTag nbt = s.m_41783_();
        if (nbt != null && nbt.m_128441_("mahou_friendly")) {
            return nbt.m_128471_("mahou_friendly");
        }
        return false;
    }

    public static void setFriendlyOnly(ItemStack s, boolean b) {
        CompoundTag nbt = s.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128379_("mahou_friendly", b);
        s.m_41751_(nbt);
    }

    public static Vec3 coverMoveFacing(LivingEntity e) {
        return Replica.coverMoveFacing(e, null);
    }

    public static Vec3 coverMoveFacing(LivingEntity e, Entity ignore) {
        int inTroubleRange = 15;
        List lst = e.m_9236_().m_45976_(LivingEntity.class, new AABB(e.m_20185_() - (double)inTroubleRange, e.m_20186_() - (double)inTroubleRange, e.m_20189_() - (double)inTroubleRange, e.m_20185_() + (double)inTroubleRange, e.m_20186_() + (double)inTroubleRange, e.m_20189_() + (double)inTroubleRange));
        Collections.sort(lst, Replica.getDistanceSorter(e));
        lst.remove(e);
        if (ignore != null) {
            lst.remove(ignore);
        }
        Vec3 ret = null;
        for (LivingEntity attacker : lst) {
            if (ret == null) {
                ret = attacker.m_20182_().m_82546_(e.m_20182_());
            }
            if (attacker.m_21188_() != e && (!(attacker instanceof Mob) || ((Mob)attacker).m_5448_() != e) && (!(attacker instanceof Player) || ContractMahoujinTileEntity.isImmuneToSpell(e.m_9236_(), e.m_20148_(), (Entity)attacker))) continue;
            ret = attacker.m_20182_().m_82546_(e.m_20182_());
            return ret;
        }
        return ret;
    }

    public static Comparator<LivingEntity> getDistanceSorter(final LivingEntity player) {
        Comparator<LivingEntity> compareDistance = new Comparator<LivingEntity>(){

            @Override
            public int compare(LivingEntity o1, LivingEntity o2) {
                double d = o1.m_20270_((Entity)player) - o2.m_20270_((Entity)player);
                if (d < 0.0) {
                    return -1;
                }
                if (d > 0.0) {
                    return 1;
                }
                return 0;
            }
        };
        return compareDistance;
    }

    public static boolean needsHelp(LivingEntity e) {
        int inTroubleRange = 15;
        List lst = e.m_9236_().m_45976_(LivingEntity.class, new AABB(e.m_20185_() - (double)inTroubleRange, e.m_20186_() - (double)inTroubleRange, e.m_20189_() - (double)inTroubleRange, e.m_20185_() + (double)inTroubleRange, e.m_20186_() + (double)inTroubleRange, e.m_20189_() + (double)inTroubleRange));
        for (LivingEntity attacker : lst) {
            if (attacker.m_21188_() != e && (!(attacker instanceof Mob) || ((Mob)attacker).m_5448_() != e)) continue;
            return true;
        }
        return false;
    }

    public static void replicaBreakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer().m_21205_().m_41720_() instanceof Replica) {
            ItemStack s;
            boolean friendly = Replica.getFriendlyOnly(s = event.getPlayer().m_21205_());
            Replica.setFriendlyOnly(s, !friendly);
            MutableComponent tt = friendly ? Component.m_237115_((String)"mahoutsukai.replica.friendlyoff") : Component.m_237115_((String)"mahoutsukai.replica.friendlyon");
            event.getPlayer().m_5661_((Component)tt, true);
        }
    }

    public static void printItems() {
        ImmutableList list = ImmutableList.copyOf((Iterable)ForgeRegistries.ITEMS);
        Object s = "";
        for (Item i : list) {
            if (!Utils.getRegistryKey(i).m_135827_().equals("mahoutsukai")) continue;
            s = (String)s + "\"" + Utils.getRegistryName(i) + "\",";
        }
        Utils.err(s);
    }

    public static void printBlocks() {
        ImmutableList list = ImmutableList.copyOf((Iterable)ForgeRegistries.BLOCKS);
        Object s = "";
        for (Block i : list) {
            if (!Utils.getRegistryKey(i).m_135827_().equals("mahoutsukai")) continue;
            s = (String)s + "\"" + Utils.getRegistryName(i).toString() + "\",";
        }
        Utils.err(s);
    }

    private void boop(Entity entity, float strength, double x, double y, double z) {
        entity.f_19812_ = true;
        float f = Mth.m_14116_((float)((float)(x * x + z * z + y * y)));
        Vec3 motion = entity.m_20184_();
        double motionX = motion.m_7096_();
        double motionY = motion.m_7098_();
        double motionZ = motion.m_7094_();
        motionX /= 2.0;
        motionZ /= 2.0;
        motionY /= 2.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.f_19864_ = true;
        if (entity.m_20096_()) {
            motionY /= 2.0;
            if ((motionY += (double)strength) > (double)0.4f) {
                motionY = 0.4f;
            }
        }
        entity.m_20334_(motionX, motionY, motionZ);
    }

    public static void setSelectedSlot(ItemStack s, int i) {
        CompoundTag nbt = s.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128405_("replica_selected_slot", i);
        s.m_41751_(nbt);
    }

    public static int getSelectedSlot(ItemStack s) {
        CompoundTag nbt = s.m_41783_();
        if (nbt != null && nbt.m_128441_("replica_selected_slot")) {
            return nbt.m_128451_("replica_selected_slot");
        }
        return 0;
    }

    public static String getDamageTypeForSlot(ItemStack s, int i) {
        CompoundTag nbt = s.m_41783_();
        String key = "mahou_replica_dt" + i;
        if (nbt != null && nbt.m_128441_(key)) {
            return nbt.m_128461_(key);
        }
        return "EMPTY";
    }

    public static void tryAddDamageType(ItemStack s, DamageSource source, LivingEntity e) {
        String type = source.m_19385_();
        if (DAMAGE_SOURCE_REGISTRY.isEmpty()) {
            Replica.initVanillaDamageTypes(e.m_269291_());
        }
        if (!(EffectUtil.inGenericBlacklist(type, MTConfig.REPLICA_BANNED_DAMAGE_TYPES) || !DAMAGE_SOURCE_REGISTRY.containsKey(type) && Replica.getDamageSource(type, e).equals(e.m_269291_().m_269264_()))) {
            String slot;
            CompoundTag nbt = s.m_41783_();
            if (nbt == null) {
                nbt = new CompoundTag();
            }
            for (int i = 0; i < 6 && !(slot = Replica.getDamageTypeForSlot(s, i)).equals(type); ++i) {
                if (!slot.equals("EMPTY")) continue;
                String key = "mahou_replica_dt" + i;
                nbt.m_128359_(key, type);
                break;
            }
            s.m_41751_(nbt);
        }
    }

    public static void replicaLivingAttack(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        Replica.replicaDamageSource(event.getEntity(), source);
    }

    public static boolean replicaLivingHurt(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        if (event.getEntity() != null && event.getEntity().m_21211_().m_41720_() instanceof Replica) {
            for (int i = 0; i < 6; ++i) {
                String s = Replica.getDamageTypeForSlot(event.getEntity().m_21211_(), i);
                if (!s.equals(source.m_19385_())) continue;
                event.setAmount(0.0f);
                return true;
            }
        }
        return false;
    }

    public static void replicaDamageSource(LivingEntity entity, DamageSource source) {
        if (!entity.m_9236_().f_46443_ && entity.m_21254_() && entity.m_21211_().m_41720_() instanceof Replica) {
            Replica.tryAddDamageType(entity.m_21211_(), source, entity);
            entity.m_21211_().m_41622_(1, entity, a -> {});
        }
        if (!MTConfig.REPLICA_DISABLED) {
            ServerPlayer e;
            IMahou mahou;
            boolean blocking = entity.m_21254_();
            boolean hasShield = entity.m_21211_().m_41720_() instanceof ShieldItem;
            boolean isPlayer = entity instanceof ServerPlayer;
            if (blocking && hasShield && isPlayer && (mahou = Utils.getPlayerMahou((Player)(e = (ServerPlayer)entity))) != null) {
                boolean offHand;
                boolean damageExchange = (double)mahou.getDamageExchangeUses() > 0.9 * (double)MTConfig.DAMAGE_EXCHANGE_CAP;
                boolean deathCollection = (double)mahou.getDeathCollectionUsesLeft() >= Math.min(100.0, MTConfig.DEATH_COLLECTION_MAX);
                boolean immunityExchange = EffectUtil.hasBuff((LivingEntity)e, ModEffects.IMMUNITY_EXCHANGE);
                boolean armor = e.m_21230_() > 15;
                boolean mainHand = e.m_21205_().m_41720_() == Items.f_42740_;
                boolean strengthenedMain = StrengtheningSpellEffect.getStrengthened(e.m_21205_()) > 0;
                boolean bl = offHand = e.m_21206_().m_41720_() == Items.f_42740_ && StrengtheningSpellEffect.getStrengthened(e.m_21206_()) > 0;
                if (offHand) {
                    PlayerHelp.sendHelpMessage((Player)e, PlayerHelp.Message.REPLICA_WRONG_HAND);
                } else {
                    int count = 0;
                    boolean[] conditions = new boolean[]{damageExchange, deathCollection, immunityExchange, armor};
                    for (int i = 0; i < conditions.length; ++i) {
                        if (!conditions[i]) continue;
                        ++count;
                    }
                    if (count >= 3 && mainHand) {
                        PlayerHelp.sendHelpMessage((Player)e, PlayerHelp.Message.REPLICA_NOT_STRENGTHENED);
                    }
                }
                if (strengthenedMain && mainHand) {
                    if (damageExchange) {
                        if (deathCollection) {
                            if (immunityExchange) {
                                if (armor) {
                                    e.m_150109_().m_8016_(e.m_150109_().f_35977_);
                                    ItemStack change = new ItemStack((ItemLike)ModItems.replica.get());
                                    if (MTConfig.REPLICA_IS_UNBREAKABLE) {
                                        CompoundTag nbt = change.m_41783_();
                                        if (nbt == null) {
                                            nbt = new CompoundTag();
                                        }
                                        nbt.m_128379_("Unbreakable", true);
                                        change.m_41751_(nbt);
                                    }
                                    if (!e.m_150109_().m_36040_(e.m_150109_().f_35977_, change)) {
                                        e.m_36176_(change, false);
                                    }
                                    ModTriggers.REPLICA.trigger(e);
                                } else {
                                    PlayerHelp.sendHelpMessage((Player)e, PlayerHelp.Message.REPLICA_NOT_ENOUGH_ARMOR);
                                }
                            } else {
                                PlayerHelp.sendHelpMessage((Player)e, PlayerHelp.Message.REPLICA_NO_IMMUNITY_EXCHANGE);
                            }
                        } else {
                            PlayerHelp.sendHelpMessage((Player)e, PlayerHelp.Message.REPLICA_NOT_ENOUGH_SOULS);
                        }
                    } else {
                        PlayerHelp.sendHelpMessage((Player)e, PlayerHelp.Message.REPLICA_NOT_ENOUGH_DAMAGE_ABSORPTION);
                    }
                }
            }
        }
    }

    public static void clearDamageTypes(ItemStack s) {
        CompoundTag nbt = s.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        for (int i = 0; i < 6; ++i) {
            String key = "mahou_replica_dt" + i;
            nbt.m_128359_(key, "EMPTY");
        }
        s.m_41751_(nbt);
    }

    public static void initVanillaDamageTypes(DamageSources srcs) {
        Replica.addToRegistry(srcs.m_269387_(), srcs.m_269548_(), srcs.m_269549_(), srcs.m_269233_(), srcs.m_269047_(), srcs.m_269318_(), srcs.m_269354_(), srcs.m_269063_(), srcs.m_269064_(), srcs.m_269325_(), srcs.m_268989_(), srcs.m_269515_(), srcs.m_269341_(), srcs.m_269264_(), srcs.m_269425_(), srcs.m_269251_(), srcs.m_269254_(), srcs.m_269483_(), srcs.m_269555_());
    }

    public static void addToRegistry(DamageSource ... src) {
        for (int i = 0; i < src.length; ++i) {
            DAMAGE_SOURCE_REGISTRY.put(src[i].m_19385_(), src[i]);
        }
    }

    public static DamageSource getDamageSource(String key, LivingEntity e) {
        DamageSource ret = e.m_269291_().m_269264_();
        DamageSources srcs = e.m_269291_();
        if (DAMAGE_SOURCE_REGISTRY.isEmpty()) {
            Replica.initVanillaDamageTypes(e.m_269291_());
        }
        if (DAMAGE_SOURCE_REGISTRY.containsKey(key)) {
            ret = DAMAGE_SOURCE_REGISTRY.get(key);
        } else {
            DamageSource BEE_STING = srcs.m_269396_(e);
            DamageSource MOB = srcs.m_269333_(e);
            DamageSource INDIRECT = srcs.m_269364_(e);
            DamageSource ARROW = srcs.m_269418_((AbstractArrow)new Arrow(e.m_9236_(), e), (Entity)e);
            DamageSource EXPLOSION = srcs.m_269036_((Entity)e, null);
            DamageSource THORNS = srcs.m_269374_((Entity)e);
            DamageSource WITHER_SKULL = srcs.m_269383_(new WitherSkull(e.m_9236_(), e, e.m_20185_(), e.m_20186_(), e.m_20189_()), (Entity)e);
            DamageSource TRIDENT = srcs.m_269525_((Entity)e, (Entity)e);
            DamageSource FIREWORK = srcs.m_268994_(new FireworkRocketEntity(e.m_9236_(), new ItemStack((ItemLike)Items.f_42688_), e), (Entity)e);
            DamageSource THROWN = srcs.m_269390_((Entity)e, (Entity)e);
            HashMap<String, DamageSource> map = new HashMap<String, DamageSource>();
            map.put(BEE_STING.m_19385_(), BEE_STING);
            map.put(MOB.m_19385_(), MOB);
            map.put(INDIRECT.m_19385_(), INDIRECT);
            map.put(ARROW.m_19385_(), ARROW);
            map.put(EXPLOSION.m_19385_(), EXPLOSION);
            map.put(THORNS.m_19385_(), THORNS);
            map.put(WITHER_SKULL.m_19385_(), WITHER_SKULL);
            map.put(TRIDENT.m_19385_(), TRIDENT);
            map.put(FIREWORK.m_19385_(), FIREWORK);
            map.put(THROWN.m_19385_(), THROWN);
            if (map.containsKey(key)) {
                ret = (DamageSource)map.get(key);
            }
        }
        return ret;
    }

    public static void replicaExplosionProtection(ExplosionEvent.Detonate event) {
        List lst = event.getExplosion().m_46081_();
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        if (lst.size() > 0 || event.getAffectedEntities().size() > 0) {
            for (BlockPos p : lst) {
                if ((float)p.m_123341_() < minX) {
                    minX = p.m_123341_();
                }
                if ((float)p.m_123342_() < minY) {
                    minY = p.m_123342_();
                }
                if ((float)p.m_123343_() < minZ) {
                    minZ = p.m_123343_();
                }
                if ((float)p.m_123341_() > maxX) {
                    maxX = p.m_123341_();
                }
                if ((float)p.m_123342_() > maxY) {
                    maxY = p.m_123342_();
                }
                if (!((float)p.m_123343_() > maxZ)) continue;
                maxZ = p.m_123343_();
            }
            for (Entity e : event.getAffectedEntities()) {
                BlockPos p = e.m_20183_();
                if ((float)p.m_123341_() < minX) {
                    minX = p.m_123341_();
                }
                if ((float)p.m_123342_() < minY) {
                    minY = p.m_123342_();
                }
                if ((float)p.m_123343_() < minZ) {
                    minZ = p.m_123343_();
                }
                if ((float)p.m_123341_() > maxX) {
                    maxX = p.m_123341_();
                }
                if ((float)p.m_123342_() > maxY) {
                    maxY = p.m_123342_();
                }
                if (!((float)p.m_123343_() > maxZ)) continue;
                maxZ = p.m_123343_();
            }
            ChunkPos bottom = new ChunkPos(new BlockPos((int)(minX -= 14.0f), (int)(minY -= 14.0f), (int)(minZ -= 14.0f)));
            ChunkPos top = new ChunkPos(new BlockPos((int)(maxX += 14.0f), (int)(maxY += 14.0f), (int)(maxZ += 14.0f)));
            AABB aabb = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            List entities = event.getLevel().m_45976_(Player.class, aabb);
            if (entities.size() > 0) {
                Iterator iter = lst.iterator();
                while (iter.hasNext()) {
                    boolean remove = false;
                    BlockPos p = (BlockPos)iter.next();
                    for (Player entity : entities) {
                        Vec3 vec1;
                        if (!(entity.m_21211_().m_41720_() instanceof Replica) || !Replica.isPointInRadiusOfCircle(entity, vec1 = EffectUtil.fromBlockPos(p).m_82520_(0.5, 0.5, 0.5))) continue;
                        remove = true;
                        break;
                    }
                    if (!remove) continue;
                    iter.remove();
                }
                Iterator affected = event.getAffectedEntities().iterator();
                while (affected.hasNext()) {
                    boolean remove = false;
                    Entity a = (Entity)affected.next();
                    Vec3 p = a.m_20182_();
                    Vec3 p2 = a.m_20182_().m_82520_(0.0, (double)a.m_20206_(), 0.0);
                    for (Player entity : entities) {
                        if (!(entity.m_21211_().m_41720_() instanceof Replica) || !Replica.isPointInRadiusOfCircle(entity, p) && !Replica.isPointInRadiusOfCircle(entity, p2)) continue;
                        remove = true;
                        break;
                    }
                    if (!remove) continue;
                    affected.remove();
                }
            }
        }
    }

    public static boolean isPointInRadiusOfCircle(Player player, Vec3 pos) {
        Vec3 sphereMid = Replica.getSphereMid(player);
        double distance = pos.m_82554_(sphereMid);
        return distance < (double)Replica.getSphereMidRadius();
    }

    public static Vec3 getSphereMid(Player player) {
        Vec3 sphereMid = player.m_20182_().m_82546_(player.m_20154_().m_82541_().m_82490_((double)Replica.getSphereMidRadius() - 0.5));
        return sphereMid;
    }

    public static float getSphereMidRadius() {
        float sphereMidRadius = 3.8f;
        return sphereMidRadius;
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.REPLICA_DURABILITY;
    }

    public Object getRenderPropertiesInternal() {
        return new MagicalItemRender(ReplicaRenderer::new);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        if (toolAction == ToolActions.SHIELD_BLOCK) {
            return true;
        }
        return super.canPerformAction(stack, toolAction);
    }
}

