/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.rulebreaker;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.MagicalItemRender;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.ProbabilityAlterPotion;
import stepsword.mahoutsukai.render.item.RuleBreakerRenderer;
import stepsword.mahoutsukai.util.EffectUtil;

public class RuleBreaker
extends SwordItem {
    public static String MODULUS_TAG = "MAHOUTSUKAI_RB_MODULUS";
    public static String DESIGNATION_TAG = "MAHOUTSUKAI_RB_DESIGNATION";

    public RuleBreaker() {
        super((Tier)Tiers.IRON, 2, -1.5f, new Item.Properties().m_41487_(1).m_41503_(MTConfig.RULE_BREAKER_DURABILITY));
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.RULE_BREAKER_DURABILITY;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            if (player.m_20163_()) {
                RuleBreaker.setDesignation(stack, RuleBreaker.getDesignation(stack) + 1);
            } else if (!EffectUtil.hasBuff((LivingEntity)player, ModEffects.PROBABILITY_ALTER)) {
                player.m_6469_(player.m_269291_().m_269264_(), 2.0f);
                EffectUtil.buff((LivingEntity)player, ModEffects.PROBABILITY_ALTER, false, MTConfig.RULE_BREAKER_DURATION);
                int mod = RuleBreaker.getModulus(stack);
                int des = RuleBreaker.getDesignation(stack);
                ProbabilityAlterPotion.createProbabilityAlter((LivingEntity)player, des, mod);
                stack.m_41622_(1, (LivingEntity)player, a -> {});
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public static void ruleBreakerLivingHurt(LivingHurtEvent event) {
        Entity e = event.getSource().m_7639_();
        if (e instanceof LivingEntity && ((LivingEntity)e).m_21205_().m_41720_() instanceof RuleBreaker) {
            LivingEntity target = event.getEntity();
            ItemStack stack = ((LivingEntity)e).m_21205_();
            if (!target.m_9236_().f_46443_ && !EffectUtil.hasBuff(target, ModEffects.PROBABILITY_ALTER)) {
                EffectUtil.buff(target, ModEffects.PROBABILITY_ALTER, false, MTConfig.RULE_BREAKER_DURATION);
                int mod = RuleBreaker.getModulus(stack);
                int des = RuleBreaker.getDesignation(stack);
                ProbabilityAlterPotion.createProbabilityAlter(target, des, mod);
            }
        }
    }

    public static boolean hasModulus(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_(MODULUS_TAG);
    }

    public static boolean hasDesignation(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_(DESIGNATION_TAG);
    }

    public static void setModulus(ItemStack stack, int m) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128405_(MODULUS_TAG, Math.max(2, m));
    }

    public static void setDesignation(ItemStack stack, int d) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128405_(DESIGNATION_TAG, Math.floorMod(d, RuleBreaker.getModulus(stack)));
    }

    public static int getModulus(ItemStack stack) {
        if (RuleBreaker.hasModulus(stack)) {
            return stack.m_41783_().m_128451_(MODULUS_TAG);
        }
        return 2;
    }

    public static int getDesignation(ItemStack stack) {
        if (RuleBreaker.hasDesignation(stack)) {
            return stack.m_41783_().m_128451_(DESIGNATION_TAG);
        }
        return 0;
    }

    public Object getRenderPropertiesInternal() {
        return new MagicalItemRender(RuleBreakerRenderer::new);
    }
}

