/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.capability.chunks.IChunkMahou;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.settingsmahou.ISettingsMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.FamiliarEntity;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffBeamMahoujinEntity;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.Bakuretsu;
import stepsword.mahoutsukai.networking.AuthorityPacket;
import stepsword.mahoutsukai.networking.BakuretsuPacket;
import stepsword.mahoutsukai.networking.BeamPacket;
import stepsword.mahoutsukai.networking.BlackFirePacket;
import stepsword.mahoutsukai.networking.ChunkMahouPacket;
import stepsword.mahoutsukai.networking.DataManagerPacket;
import stepsword.mahoutsukai.networking.EntityPathPacket;
import stepsword.mahoutsukai.networking.FaeNoisePacket;
import stepsword.mahoutsukai.networking.FogPacket;
import stepsword.mahoutsukai.networking.GardenPacket;
import stepsword.mahoutsukai.networking.InsightPacket;
import stepsword.mahoutsukai.networking.MagicCircleBoomParticlePacket;
import stepsword.mahoutsukai.networking.PlayerMahouPacket;
import stepsword.mahoutsukai.networking.PossessEntityPacket;
import stepsword.mahoutsukai.networking.RagePacket;
import stepsword.mahoutsukai.networking.ReplicaKnockbackParticlePacket;
import stepsword.mahoutsukai.networking.RevertedPacket;
import stepsword.mahoutsukai.networking.RipperInvisiblePacket;
import stepsword.mahoutsukai.networking.ScryingEntityPacket;
import stepsword.mahoutsukai.networking.SettingsMahouPacket;
import stepsword.mahoutsukai.potion.ClairvoyanceEyesPotion;
import stepsword.mahoutsukai.potion.InsightEyesPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.ReversionEyesPotion;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.overlay.RenderInsightOverlay;
import stepsword.mahoutsukai.render.particle.ModParticles;
import stepsword.mahoutsukai.render.particle.ParticleMagic;
import stepsword.mahoutsukai.render.particle.ParticleSphere;
import stepsword.mahoutsukai.sounds.BeamMovingSound;
import stepsword.mahoutsukai.tile.displacement.ScryingMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ClientPacketHandler {
    public static void mahouPacketHandler(PlayerMahouPacket message) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_6937_(() -> {
            LocalPlayer player = mc.f_91074_;
            if (player != null) {
                IMahou mahou = Utils.getPlayerMahou((Player)player);
                IMahou mahouUpdate = message.mahou;
                if (mahou != null) {
                    mahou.copyMahou(mahouUpdate);
                }
            }
        });
    }

    public static void mahouPacketHandler(SettingsMahouPacket message) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_6937_(() -> {
            LocalPlayer player = mc.f_91074_;
            if (player != null) {
                ISettingsMahou mahou = Utils.getSettingsMahou((LivingEntity)player);
                ISettingsMahou mahouUpdate = message.mahou;
                if (mahou != null) {
                    mahou.copyMahou(mahouUpdate);
                }
            }
        });
    }

    public static void chunkMahouPacketHandler(ChunkMahouPacket message) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_6937_(() -> {
            LevelChunk c = Minecraft.m_91087_().f_91073_.m_6325_(message.x, message.z);
            IChunkMahou chunkMahou = Utils.getChunkMahou(c);
            if (chunkMahou != null) {
                if (message.mode == 0) {
                    chunkMahou.setLakeBlocks(message.set);
                }
                if (message.mode == 1) {
                    chunkMahou.setFogProjectors(message.set);
                }
            }
        });
    }

    public static void updateTE(DataManagerPacket message) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_6937_(() -> {
            BlockEntity te = mc.f_91073_.m_7702_(message.pos);
            if (te instanceof ScryingMahoujinTileEntity) {
                ((ScryingMahoujinTileEntity)te).scryDataManager = message.dataManagerEntries;
            }
        });
    }

    public static void updateFire(BlackFirePacket message) {
        Entity e = Minecraft.m_91087_().f_91073_.m_6815_(message.entityids);
        if (e instanceof LivingEntity) {
            if (message.onFire) {
                EffectUtil.buff((LivingEntity)e, ModEffects.BLACK_BURNING, false, 180);
            } else {
                EffectUtil.debuff((LivingEntity)e, ModEffects.BLACK_BURNING);
            }
        }
    }

    public static void pathHandler(EntityPathPacket message) {
        try {
            if (ClairvoyanceEyesPotion.predictionMap == null) {
                ClairvoyanceEyesPotion.predictionMap = new ConcurrentHashMap();
            }
            Minecraft mc = Minecraft.m_91087_();
            int range = MTConfig.CLAIRVOYANCE_RANGE;
            LocalPlayer player = mc.f_91074_;
            AABB aabb = new AABB(player.m_20183_().m_7918_(-range, -range, -range), player.m_20183_().m_7918_(range, range, range));
            List lst = mc.f_91073_.m_45976_(PathfinderMob.class, aabb);
            HashSet nearby = new HashSet(lst);
            HashSet<PathfinderMob> received = new HashSet<PathfinderMob>();
            for (int i = 0; i < message.entities.size(); ++i) {
                Entity e = player.m_9236_().m_6815_(message.entities.get(i).intValue());
                if (!(e instanceof PathfinderMob)) continue;
                PathfinderMob living = (PathfinderMob)e;
                received.add(living);
                if (!nearby.contains(living) || i >= message.paths.size()) continue;
                Path path = message.paths.get(i);
                if (ClairvoyanceEyesPotion.predictionMap == null) continue;
                if (ClairvoyanceEyesPotion.predictionMap.containsKey(living)) {
                    Path p = ClairvoyanceEyesPotion.predictionMap.get(living);
                    if (p.m_77375_(p.m_77398_() - 1).equals((Object)path.m_77375_(path.m_77398_() - 1))) continue;
                    ClairvoyanceEyesPotion.predictionMap.put(living, path);
                    continue;
                }
                ClairvoyanceEyesPotion.predictionMap.put(living, path);
            }
            if (ClairvoyanceEyesPotion.predictionMap != null) {
                for (Entity e : ClairvoyanceEyesPotion.predictionMap.keySet()) {
                    if (nearby.contains(e) && received.contains(e)) continue;
                    ClairvoyanceEyesPotion.predictionMap.remove(e);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updateReverted(RevertedPacket message) {
        Entity e = Minecraft.m_91087_().f_91073_.m_6815_(message.entityids);
        if (e instanceof LivingEntity) {
            if (message.reverted) {
                ReversionEyesPotion.setEntityReverted((LivingEntity)e);
            } else {
                EffectUtil.debuff((LivingEntity)e, ModEffects.REVERTED);
            }
        }
    }

    public static void gardenHandler(GardenPacket message) {
        FamiliarEntity.gardenEffectB(Utils.toBlockPos(message.posX, message.posY, message.posZ), (Level)Minecraft.m_91087_().f_91073_);
    }

    public static void scryingHandler(ScryingEntityPacket message) {
        BlockEntity be = Minecraft.m_91087_().f_91074_.m_9236_().m_7702_(Utils.toBlockPos(message.posX, message.posY, message.posZ));
        if (be instanceof ScryingMahoujinTileEntity) {
            if (message.entityTag == null) {
                ((ScryingMahoujinTileEntity)be).scryTarget = null;
                ((ScryingMahoujinTileEntity)be).lst = new ArrayList();
                ((ScryingMahoujinTileEntity)be).scryNBT = null;
            }
            ((ScryingMahoujinTileEntity)be).scryNBT = message.entityTag;
            ((ScryingMahoujinTileEntity)be).doRead = true;
        }
    }

    public static void possess(PossessEntityPacket message) {
        try {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            ChunkPos pos = new ChunkPos(message.chunkx, message.chunkz);
            List lst = player.m_9236_().m_45976_(Entity.class, new AABB(new BlockPos(pos.m_45615_().m_123341_(), player.m_9236_().m_141937_(), pos.m_45615_().m_123343_()), pos.m_45615_().m_7918_(16, player.m_9236_().m_151558_(), 16)));
            for (Entity entity : lst) {
                if (entity.m_19879_() != message.entityId) continue;
                mc.m_91118_(entity);
                IMahou mahou = Utils.getPlayerMahou((Player)player);
                if (mahou == null) continue;
                mahou.setPossessing(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void handleBakuretsu(BakuretsuPacket message) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Bakuretsu bakuretsu = new Bakuretsu(message.strength, (float)message.posX, (float)message.posY, (float)message.posZ, 0.0f);
        bakuretsu.explosionB((Level)Minecraft.m_91087_().f_91073_, (Player)Minecraft.m_91087_().f_91074_);
        double motionX = player.m_20184_().f_82479_;
        double motionY = player.m_20184_().f_82480_;
        double motionZ = player.m_20184_().f_82481_;
        player.m_20334_(motionX += (double)message.motionX, motionY += (double)message.motionY, motionZ += (double)message.motionZ);
    }

    public static void insightHandler(InsightPacket message) {
        RenderInsightOverlay.inventory = InsightEyesPotion.readInventory(message.inventory);
        RenderInsightOverlay.entityId = message.id;
        RenderInsightOverlay.hasTarget = message.hasTarget;
        RenderInsightOverlay.block = message.block;
        RenderInsightOverlay.effects = InsightEyesPotion.readEffects(message.effects);
        RenderInsightOverlay.mainhandindex = message.mainhandindex;
    }

    public static void beamHandler(BeamPacket message) {
        Entity entity;
        if (Minecraft.m_91087_().f_91073_ != null && (entity = Minecraft.m_91087_().f_91073_.m_6815_(message.entityId)) instanceof MysticStaffBeamMahoujinEntity) {
            BeamMovingSound s = new BeamMovingSound((Player)Minecraft.m_91087_().f_91074_, (MysticStaffBeamMahoujinEntity)entity);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)s);
        }
    }

    public static void faeNoiseHandler(FaeNoisePacket message) {
        if (Minecraft.m_91087_().f_91073_ != null && MTConfig.FAE_NOISE) {
            Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().f_91073_.m_6263_((Player)Minecraft.m_91087_().f_91074_, (double)message.x, (double)message.y, (double)message.z, message.sound, message.cat, message.vol, message.pit));
        }
    }

    public static void updateRage(RagePacket message) {
        Entity e = Minecraft.m_91087_().f_91073_.m_6815_(message.entityids);
        if (e instanceof LivingEntity) {
            if (message.rage) {
                EffectUtil.buff((LivingEntity)e, ModEffects.RAGE, false, MTConfig.MORGAN_RAGE_TIME);
            } else {
                EffectUtil.debuff((LivingEntity)e, ModEffects.RAGE);
            }
        }
    }

    public static void updateAuthority(AuthorityPacket message) {
        Entity e = Minecraft.m_91087_().f_91073_.m_6815_(message.entityids);
        if (e instanceof LivingEntity) {
            if (message.authority) {
                EffectUtil.buff((LivingEntity)e, ModEffects.BORROWED_AUTHORITY, false, MTConfig.AUTHORITY_TIME);
            } else {
                EffectUtil.debuff((LivingEntity)e, ModEffects.BORROWED_AUTHORITY);
            }
        }
    }

    public static void magicParticleHandler(MagicCircleBoomParticlePacket message) {
        Vec3 look = new Vec3(message.lookX, message.lookY, message.lookZ).m_82541_();
        Vec3 v = look.m_82496_(EffectUtil.toRad(90.0f)).m_82541_();
        for (int i = 0; i < 25; ++i) {
            float b;
            float g;
            float r;
            double angle = Math.random() * 360.0;
            if (message.boom_mode == 0) {
                v = ClientPacketHandler.rotateVecAroundVec(v, look, (float)angle);
            } else if (message.boom_mode == 1) {
                v = Vec3.m_82498_((float)((float)angle), (float)((float)Math.random() * 360.0f)).m_82541_();
            }
            v = message.randomspeed ? v.m_82490_(Math.random() * message.speed) : v.m_82490_(message.speed);
            if (message.color == 1) {
                r = message.r;
                g = message.g;
                b = message.b;
            } else {
                r = message.r2;
                g = message.g2;
                b = message.b2;
            }
            float sz = message.big ? 1.2f : 0.2f;
            ParticleMagic p = new ParticleMagic(Minecraft.m_91087_().f_91073_, message.posX, message.posY, message.posZ, 0.5f, v.f_82479_, v.f_82480_, v.f_82481_, "textures/particle/white_magic_particle", sz, r, g, b, 1.0f, false);
            Minecraft.m_91087_().f_91061_.m_107344_((Particle)p);
        }
    }

    public static void replicaKnockbackParticleHandler(ReplicaKnockbackParticlePacket message) {
        ParticleSphere p = new ParticleSphere(Minecraft.m_91087_().f_91073_, message.posX, message.posY, message.posZ, 0.4f, 0.0, 0.0, 0.0, RenderUtils.beam.toString(), 0.32f, message.r, message.g, message.b, 0.4f, false, 1.2f);
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)p);
        ParticleSphere p2 = new ParticleSphere(Minecraft.m_91087_().f_91073_, message.posX, message.posY, message.posZ, 0.4f, 0.0, 0.0, 0.0, RenderUtils.beam.toString(), 0.34f, 1.0f, 1.0f, 1.0f, 0.2f, false, 1.2f);
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)p2);
    }

    public static Vec3 rotateVecAroundVec(Vec3 v1, Vec3 v2, float angle) {
        Vec3 z = v1.m_82537_(v2).m_82541_();
        return v1.m_82490_(Math.cos(EffectUtil.toRad(angle))).m_82549_(z.m_82490_(Math.sin(EffectUtil.toRad(angle)))).m_82541_();
    }

    public static void fog(FogPacket message) {
        Entity player;
        if (Minecraft.m_91087_().f_91073_ != null && (player = Minecraft.m_91087_().f_91073_.m_6815_(message.eid)) != null) {
            double FOG_RANGE = message.range;
            Vec3 v = player.m_20182_();
            double unit = message.space;
            for (double i = -FOG_RANGE; i < FOG_RANGE; i += unit) {
                for (double j = -FOG_RANGE / 4.0; j < FOG_RANGE / 2.0; j += unit) {
                    for (double k = -FOG_RANGE; k < FOG_RANGE; k += unit) {
                        if (!(i * i + j * j + k * k < FOG_RANGE * FOG_RANGE)) continue;
                        player.m_9236_().m_7106_((ParticleOptions)ModParticles.FOG1.get(), v.f_82479_ + i, v.f_82480_ + j, v.f_82481_ + k, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public static void updateInvisible(RipperInvisiblePacket message) {
        Entity e = Minecraft.m_91087_().f_91073_.m_6815_(message.entityids);
        if (e instanceof LivingEntity) {
            if (message.invisible) {
                EffectUtil.buff((LivingEntity)e, ModEffects.RIPPER_INVISIBILITY, false, 90000000, false);
            } else {
                EffectUtil.debuff((LivingEntity)e, ModEffects.RIPPER_INVISIBILITY);
            }
        }
    }
}

