/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;
import stepsword.mahoutsukai.util.ByteBufUtils;

public class InsightPacket {
    CompoundTag inventory;
    CompoundTag effects;
    int id;
    int mainhandindex;
    boolean hasTarget;
    boolean block;

    public InsightPacket() {
    }

    public InsightPacket(CompoundTag inv, CompoundTag effects, boolean hasTarget, boolean block, int eid, int mainhandindex) {
        this.inventory = inv;
        this.id = eid;
        this.block = block;
        this.hasTarget = hasTarget;
        this.effects = effects;
        this.mainhandindex = mainhandindex;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.block = buf.readBoolean();
        this.hasTarget = buf.readBoolean();
        this.mainhandindex = buf.readInt();
        String s = ByteBufUtils.readUTF8String(buf);
        try {
            this.inventory = s == null ? new CompoundTag() : TagParser.m_129359_((String)s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String s2 = ByteBufUtils.readUTF8String(buf);
        try {
            this.effects = s2 == null ? new CompoundTag() : TagParser.m_129359_((String)s2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeBoolean(this.block);
        buf.writeBoolean(this.hasTarget);
        buf.writeInt(this.mainhandindex);
        String s = this.inventory.toString();
        ByteBufUtils.writeUTF8String(buf, s);
        String s2 = this.effects.toString();
        ByteBufUtils.writeUTF8String(buf, s2);
    }

    public static void encode(InsightPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static InsightPacket decode(FriendlyByteBuf buf) {
        InsightPacket msg = new InsightPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(InsightPacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.insightHandler(message);
        context.get().setPacketHandled(true);
    }
}

