/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.item.mysticcode.MysticCode;
import stepsword.mahoutsukai.item.spells.secret.FallenDownSpellScroll;
import stepsword.mahoutsukai.item.spells.secret.GandrSpellScroll;
import stepsword.mahoutsukai.util.Utils;

public class MysticCodeSwitchPacket {
    int slot;

    public MysticCodeSwitchPacket() {
    }

    public MysticCodeSwitchPacket(int s) {
        this.slot = s;
    }

    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
    }

    public static void encode(MysticCodeSwitchPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static MysticCodeSwitchPacket decode(FriendlyByteBuf buf) {
        MysticCodeSwitchPacket msg = new MysticCodeSwitchPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(MysticCodeSwitchPacket message, Supplier<NetworkEvent.Context> context) {
        MysticCodeSwitchPacket.handleSwitch(message, (Player)context.get().getSender());
        context.get().setPacketHandled(true);
    }

    public static void handleSwitch(MysticCodeSwitchPacket message, Player player) {
        ItemStack stack = player.m_21205_();
        if (stack != null && !stack.m_41619_() && stack.m_41720_() instanceof MysticCode) {
            int slot;
            MysticCode.setSlot(stack, message.slot);
            ((MysticCode)stack.m_41720_()).setRandomColor(stack, player.m_217043_());
            IItemHandler inventory = Utils.getMCInventory(stack);
            if (inventory != null && (slot = MysticCode.getSlot(stack)) >= 0 && slot < 3) {
                ItemStack ammo = inventory.getStackInSlot(slot);
                if (ammo.m_41720_() instanceof GandrSpellScroll) {
                    ((MysticCode)stack.m_41720_()).setColor(stack, 8);
                }
                if (ammo.m_41720_() instanceof FallenDownSpellScroll) {
                    ((MysticCode)stack.m_41720_()).setColor(stack, 9);
                }
            }
        }
    }
}

