/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.enchant.MahoujinProjectorEnchant;
import stepsword.mahoutsukai.enchant.ModEnchantments;
import stepsword.mahoutsukai.tile.MahoujinProjectorTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;

public class ProjectorRightClickPacket {
    ARMOR_ACTION action;
    BlockPos pos;

    public ProjectorRightClickPacket() {
    }

    public ProjectorRightClickPacket(ARMOR_ACTION action, BlockPos pos) {
        this.action = action;
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.action = ARMOR_ACTION.values()[buf.readInt() % ARMOR_ACTION.values().length];
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.pos.m_123341_());
        buf.writeInt(this.pos.m_123342_());
        buf.writeInt(this.pos.m_123343_());
    }

    public static void encode(ProjectorRightClickPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static ProjectorRightClickPacket decode(FriendlyByteBuf buf) {
        ProjectorRightClickPacket msg = new ProjectorRightClickPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(final ProjectorRightClickPacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                ProjectorRightClickPacket.modifyArmor(context, message);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void modifyArmor(Supplier<NetworkEvent.Context> context, ProjectorRightClickPacket message) {
        ServerPlayer player = context.get().getSender();
        BlockEntity te = player.m_9236_().m_7702_(message.pos);
        if (te instanceof MahoujinProjectorTileEntity && player.m_21205_().m_41720_() instanceof ArmorItem) {
            EffectUtil.addEnchantment(player.m_21205_(), (Enchantment)ModEnchantments.PROJECTOR.get(), 1);
            if (message.action == ARMOR_ACTION.ADD) {
                MahoujinProjectorEnchant.setProjectorNBT(player.m_21205_(), (MahoujinProjectorTileEntity)te, false, false);
            }
            if (message.action == ARMOR_ACTION.REPLACE) {
                MahoujinProjectorEnchant.setProjectorNBT(player.m_21205_(), (MahoujinProjectorTileEntity)te, true, false);
            }
            if (message.action == ARMOR_ACTION.REMOVE) {
                MahoujinProjectorEnchant.setProjectorNBT(player.m_21205_(), (MahoujinProjectorTileEntity)te, true, true);
            }
        }
    }

    public static enum ARMOR_ACTION {
        REPLACE,
        ADD,
        REMOVE;

    }
}

