/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.config.MandatoryFun;
import stepsword.mahoutsukai.potion.EyesPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;

public class BindingEyesPotion
extends EyesPotion {
    protected BindingEyesPotion() {
        super(ModEffects.getColorNumber(252, 45, 225));
    }

    public static void bindingEyesPlayerTick(Player player) {
        if (EffectUtil.hasBuff((LivingEntity)player, ModEffects.BINDING_EYES)) {
            BindingEyesPotion.addBindings(player);
        }
        if (BindingEyesPotion.isBound((LivingEntity)player) && !BindingEyesPotion.continueBinding((LivingEntity)player)) {
            EffectUtil.debuff((LivingEntity)player, ModEffects.BOUND);
        }
    }

    public static boolean bindingEyesLivingUpdate(LivingEntity entity) {
        boolean ret = false;
        Level world = entity.m_9236_();
        if (EffectUtil.hasBuff(entity, ModEffects.BOUND)) {
            entity.f_20911_ = false;
            if (!world.f_46443_) {
                if (!(entity instanceof Player)) {
                    ret = true;
                }
                --entity.f_19802_;
                if (!BindingEyesPotion.continueBinding(entity)) {
                    EffectUtil.debuff(entity, ModEffects.BOUND);
                }
            }
        }
        return ret;
    }

    public static void addBindings(Player player) {
        int totalRange = MTConfig.MYSTIC_EYES_RANGE_FROM_USER;
        Vec3 myloc = player.m_20182_();
        List lst = player.m_9236_().m_45976_(LivingEntity.class, new AABB(myloc.f_82479_ - (double)totalRange, myloc.f_82480_ - (double)totalRange, myloc.f_82481_ - (double)totalRange, myloc.f_82479_ + (double)totalRange, myloc.f_82480_ + (double)totalRange, myloc.f_82481_ + (double)totalRange));
        for (LivingEntity tmp : lst) {
            if (!EffectUtil.inRange(tmp, (LivingEntity)player, myloc, MTConfig.MYSTIC_EYES_RANGE_FROM_LOOK_VEC, true) || ContractMahoujinTileEntity.isImmuneToSpell(player.m_9236_(), player.m_20148_(), (Entity)tmp) || BindingEyesPotion.isBound(tmp)) continue;
            if (tmp instanceof Creeper) {
                MandatoryFun.completeFunReq(player, MandatoryFun.FUN_REQS.CREEPER_BINDING_EYES);
            }
            EffectUtil.buff(tmp, ModEffects.BOUND, false, 100);
        }
    }

    public static boolean continueBinding(LivingEntity victim) {
        int totalRange = MTConfig.MYSTIC_EYES_RANGE_FROM_USER;
        Vec3 myloc = victim.m_20182_();
        boolean keepBinding = false;
        List lst = victim.m_9236_().m_45976_(Player.class, new AABB(myloc.f_82479_ - (double)totalRange, myloc.f_82480_ - (double)totalRange, myloc.f_82481_ - (double)totalRange, myloc.f_82479_ + (double)totalRange, myloc.f_82480_ + (double)totalRange, myloc.f_82481_ + (double)totalRange));
        for (Player tmp : lst) {
            if (tmp.m_20148_().equals(victim.m_20148_()) || !EffectUtil.hasBuff((LivingEntity)tmp, ModEffects.BINDING_EYES) || !EffectUtil.inRange(victim, (LivingEntity)tmp, myloc, MTConfig.MYSTIC_EYES_RANGE_FROM_LOOK_VEC, true)) continue;
            keepBinding = true;
        }
        return keepBinding;
    }

    public static boolean isBound(LivingEntity e) {
        return EffectUtil.hasBuff(e, ModEffects.BOUND);
    }
}

