/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.entity.mahoujin.FallenDownBeamEntity;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderFallenDownBeamEntity
extends EntityRenderer<FallenDownBeamEntity> {
    public RenderFallenDownBeamEntity(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(FallenDownBeamEntity entity) {
        return TextureAtlas.f_118259_;
    }

    public void render(FallenDownBeamEntity entity, float eyaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
    }

    public static void renderFallenDownBeam(FallenDownBeamEntity entity, double x, double y, double z, PoseStack matrix, float partialTicks) {
        matrix.m_85836_();
        matrix.m_85837_(x, y, z);
        matrix.m_85837_(0.0, 1.5, 0.0);
        float time = (float)ClientHandler.clientTickCounter * 1.3f;
        float ticksToFullSize = entity.getGrowingLife();
        float growth = Math.max(0.0f, Math.min(ticksToFullSize, (float)entity.getLife()));
        growth /= ticksToFullSize;
        float rotleft = time;
        float rotright = -time;
        float timeColor = Math.abs((float)(entity.m_9236_().m_46468_() % 24000L) - 6000.0f) / 12000.0f;
        float rad = (float)entity.getCurrentRadius();
        float r1 = 0.19215687f;
        float g1 = 0.3529412f;
        float b1 = 0.7058824f;
        float a1 = 1.0f;
        float r2 = 0.27058825f;
        float g2 = 0.7921569f;
        float b2 = 1.0f;
        float a2 = 1.0f;
        float r = r1 + (r2 - r1) * timeColor;
        float g = g1 + (g2 - g1) * timeColor;
        float b = b1 + (b2 - b1) * timeColor;
        float a = a1 + (a2 - a1) * timeColor;
        r = 0.3f;
        g = 0.8f;
        b = 1.0f;
        a = 1.0f;
        int lightmapX = 240;
        int lightmapY = 240;
        int index = 0;
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        CullWrappedRenderLayer type = new CullWrappedRenderLayer(MahoujinRenderType.createMahoujinRenderType(RenderUtils.mahoujin, 0, false));
        VertexConsumer bb = buffer.m_6299_((RenderType)type);
        RenderFallenDownBeamEntity.renderPlayerLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        if (growth > 0.0f) {
            RenderFallenDownBeamEntity.renderFirstLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        if (growth > 0.0f) {
            RenderFallenDownBeamEntity.renderSecondLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        if (growth > 0.0f) {
            RenderFallenDownBeamEntity.renderThirdLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        if (growth > 0.0f) {
            RenderFallenDownBeamEntity.renderFourthLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        if (growth > 0.0f) {
            RenderFallenDownBeamEntity.renderFifthLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        if (growth > 0.0f) {
            RenderFallenDownBeamEntity.renderSixthLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        if (growth > 0.0f) {
            RenderFallenDownBeamEntity.renderBeam(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth, rad);
        }
        matrix.m_85849_();
    }

    public static void renderPlayerLayer(PoseStack matrix, float rotright, float rotleft, MultiBufferSource.BufferSource buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        matrix.m_85836_();
        RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
        RenderType t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 0.6, 90.0f, 2.0f, 0.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.m_109912_(t2);
        matrix.m_85849_();
        matrix.m_85836_();
        RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
        t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 1.2, 45.0f, 1.4f, 0.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.m_109912_(t2);
        matrix.m_85849_();
        matrix.m_85836_();
        matrix.m_85837_(0.0, 1.2, 0.0);
        RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
        matrix.m_85841_(2.0f, 2.0f, 2.0f);
        VertexConsumer bb = buffer.m_6299_(type);
        RenderFallenDownBeamEntity.renderCircle(bb, matrix, r, g, b, a, lightmapX, lightmapY);
        buffer.m_109912_(type);
        matrix.m_85849_();
        matrix.m_85836_();
        RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
        matrix.m_252880_(0.0f, 0.0f, 0.0f);
        int num_circles = 4;
        for (int i = 0; i < num_circles; ++i) {
            matrix.m_85836_();
            RenderUtils.rotateQ(360 / num_circles * i, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(70.0f, 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            matrix.m_252880_(0.0f, 2.0f, 0.0f);
            matrix.m_85841_(1.0f, 1.0f, 1.0f);
            bb = buffer.m_6299_(type);
            RenderFallenDownBeamEntity.renderCircle(bb, matrix, r, g, b, a, lightmapX, lightmapY);
            buffer.m_109912_(type);
            matrix.m_85849_();
        }
        matrix.m_85849_();
    }

    public static void renderFirstLayer(PoseStack matrix, float rotright, float rotleft, MultiBufferSource.BufferSource buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        float prevLevel = 10.0f;
        float threshold = 0.0f;
        float endThreshold = 0.5f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        matrix.m_85836_();
        RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
        RenderType t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 4.2, 0.0f, newgrowth * 4.0f, 0.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.m_109912_(t2);
        matrix.m_85849_();
        matrix.m_85836_();
        RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
        t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 4.0, 0.0f, newgrowth * 2.0f, 1.0f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.m_109912_(t2);
        matrix.m_85849_();
        matrix.m_85836_();
        RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
        matrix.m_252880_(0.0f, 2.0f, 0.0f);
        int num_circles = 8;
        for (int i = 0; i < num_circles; ++i) {
            matrix.m_85836_();
            RenderUtils.rotateQ(360 / num_circles * i, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(50.0f, 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            matrix.m_252880_(0.0f, 5.0f, 0.0f);
            VertexConsumer bb = buffer.m_6299_(type);
            matrix.m_85841_(newgrowth * 1.2f, newgrowth * 1.2f, newgrowth * 1.2f);
            if (i % 2 == 0) {
                RenderFallenDownBeamEntity.renderCircle(bb, matrix, r, g, b, a, lightmapX, lightmapY);
            } else {
                t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 0.0, 45.0f, newgrowth * 0.6f, 0.3f, 32, lightmapX, lightmapY, r, g, b, a, index++);
                buffer.m_109912_(t2);
                matrix.m_85836_();
                matrix.m_85837_(0.0, 0.1, 0.0);
                t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 0.0, 0.0f, newgrowth * 0.3f, 0.1f, 32, lightmapX, lightmapY, r, g, b, a, index++);
                buffer.m_109912_(t2);
                matrix.m_85849_();
                matrix.m_85836_();
                matrix.m_85837_(0.0, 0.2, 0.0);
                t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 0.0, 0.0f, newgrowth * 0.4f, 0.1f, 32, lightmapX, lightmapY, r, g, b, a, index++);
                buffer.m_109912_(t2);
                matrix.m_85849_();
                t2 = RenderUtils.renderRing(matrix, (MultiBufferSource)buffer, 0.0, 45.0f, newgrowth * 0.6f, 0.2f, 32, lightmapX, lightmapY, r, g, b, a, index++, RenderUtils.beam);
                buffer.m_109912_(t2);
            }
            buffer.m_109912_(type);
            matrix.m_85849_();
        }
        matrix.m_85849_();
    }

    public static void renderSecondLayer(PoseStack matrix, float rotright, float rotleft, MultiBufferSource.BufferSource buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        float prevLevel = 10.0f;
        float threshold = 0.0f;
        float endThreshold = 0.5f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        matrix.m_85836_();
        RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
        RenderType t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 10.0, 0.0f, newgrowth * 6.0f, 0.5f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.m_109912_(t2);
        matrix.m_85849_();
        matrix.m_85836_();
        RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
        t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 10.0, 0.0f, newgrowth * 4.0f, 1.5f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.m_109912_(t2);
        matrix.m_85849_();
        matrix.m_85836_();
        RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
        matrix.m_252880_(0.0f, newgrowth * 3.0f, 0.0f);
        int num_circles = 6;
        for (int i = 0; i < num_circles; ++i) {
            matrix.m_85836_();
            RenderUtils.rotateQ(360 / num_circles * i, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(60.0f, 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            matrix.m_252880_(0.0f, 9.0f, 0.0f);
            matrix.m_85841_(newgrowth * 4.0f, newgrowth * 4.0f, newgrowth * 4.0f);
            VertexConsumer bb = buffer.m_6299_(type);
            RenderFallenDownBeamEntity.renderCircle(bb, matrix, r, g, b, a, lightmapX, lightmapY);
            buffer.m_109912_(type);
            matrix.m_85849_();
        }
        matrix.m_85849_();
    }

    public static void renderThirdLayer(PoseStack matrix, float rotright, float rotleft, MultiBufferSource.BufferSource buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        RenderType t2;
        float prevLevel = 10.0f;
        float threshold = 0.6f;
        float endThreshold = 0.7f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        if (growth > threshold) {
            matrix.m_85836_();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, prevLevel + 5.0f * newgrowth, 0.0f, 6.0f + newgrowth * 2.0f, newgrowth * 0.8f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.m_109912_(t2);
            matrix.m_85849_();
        }
        if (growth > threshold) {
            matrix.m_85836_();
            RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, prevLevel + 5.0f * newgrowth, 0.0f, 4.0f, newgrowth * 2.0f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.m_109912_(t2);
            matrix.m_85849_();
        }
    }

    public static void renderFourthLayer(PoseStack matrix, float rotright, float rotleft, MultiBufferSource.BufferSource buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        RenderType t2;
        float prevLevel = 10.0f;
        float threshold = 0.5f;
        float endThreshold = 0.6f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        if (growth > threshold) {
            matrix.m_85836_();
            RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, prevLevel + 2.0f * newgrowth, 0.0f, 2.0f + newgrowth * 2.0f, newgrowth * 2.0f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.m_109912_(t2);
            matrix.m_85849_();
        }
        if (growth > threshold) {
            matrix.m_85836_();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 5.0 + 2.5 * (double)newgrowth, 90.0f, 2.0f + newgrowth * 4.0f, newgrowth * 0.6f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.m_109912_(t2);
            matrix.m_85849_();
        }
    }

    public static void renderFifthLayer(PoseStack matrix, float rotright, float rotleft, MultiBufferSource.BufferSource buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        RenderType t2;
        float threshold = 0.7f;
        float endThreshold = 0.75f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        if (growth > threshold) {
            matrix.m_85836_();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 15.0f + 3.0f * newgrowth, 90.0f, 8.0f + newgrowth * 6.0f, newgrowth * 1.5f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.m_109912_(t2);
            matrix.m_85849_();
        }
        if (growth > threshold) {
            matrix.m_85836_();
            RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 10.0f + 4.0f * newgrowth, 90.0f, 4.0f + newgrowth * 7.0f, newgrowth * 1.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.m_109912_(t2);
            matrix.m_85849_();
        }
        if (growth > threshold) {
            matrix.m_85836_();
            matrix.m_252880_(0.0f, 15.0f + 3.0f * newgrowth, 0.0f);
            RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
            matrix.m_85841_(16.0f + newgrowth * 2.0f, 16.0f + newgrowth * 2.0f, 16.0f + newgrowth * 2.0f);
            VertexConsumer bb = buffer.m_6299_(type);
            RenderFallenDownBeamEntity.renderCircle(bb, matrix, r, g, b, a, lightmapX, lightmapY);
            buffer.m_109912_(type);
            matrix.m_85849_();
        }
    }

    public static void renderSixthLayer(PoseStack matrix, float rotright, float rotleft, MultiBufferSource.BufferSource buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        RenderType t2;
        float threshold = 0.75f;
        float endThreshold = 0.8f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        if (growth > threshold) {
            matrix.m_85836_();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 10.0f + 3.0f * newgrowth, 0.0f, 8.0f + newgrowth * 8.0f, newgrowth * 3.0f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.m_109912_(t2);
            matrix.m_85849_();
        }
        if (growth > threshold) {
            matrix.m_85836_();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 18.0f + 3.0f * newgrowth, 0.0f, 9.0f + newgrowth * 12.0f, newgrowth * 3.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.m_109912_(t2);
            matrix.m_85849_();
        }
        if (growth > threshold) {
            matrix.m_85836_();
            RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 18.0f + 3.0f * newgrowth, 0.0f, 9.0f + newgrowth * 4.5f, newgrowth * 5.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.m_109912_(t2);
            matrix.m_85849_();
        }
    }

    public static void renderBeam(PoseStack matrix, float rotright, float rotleft, MultiBufferSource.BufferSource buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth, float rad) {
        float threshold = 0.75f;
        float cy = 255.0f;
        if (growth > threshold) {
            matrix.m_85836_();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            CullWrappedRenderLayer beam2 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(RenderUtils.beam, RenderUtils.rune_index++));
            RenderUtils.renderRing(matrix, (MultiBufferSource)buffer, (double)cy, 90.0f, rad, 512.0f, 64, lightmapX, lightmapY, 1.0f, 1.0f, 1.0f, 1.0f, beam2);
            buffer.m_109912_((RenderType)beam2);
            matrix.m_85849_();
            matrix.m_85836_();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            CullWrappedRenderLayer beam3 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(RenderUtils.beam, RenderUtils.rune_index++));
            RenderUtils.renderRing(matrix, (MultiBufferSource)buffer, (double)cy, 90.0f, rad + 0.08f, 512.0f, 64, lightmapX, lightmapY, r, g, b, 0.4f, beam3);
            buffer.m_109912_((RenderType)beam3);
            matrix.m_85849_();
            matrix.m_85836_();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            CullWrappedRenderLayer beam4 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(RenderUtils.beam, RenderUtils.rune_index++));
            RenderUtils.renderRing(matrix, (MultiBufferSource)buffer, (double)cy, 90.0f, rad - 0.08f, 512.0f, 64, lightmapX, lightmapY, r, g, b, 0.4f, beam4);
            buffer.m_109912_((RenderType)beam4);
            matrix.m_85849_();
        }
    }

    public static void renderCircle(VertexConsumer bb, PoseStack matrix, float r, float g, float b, float a, int lightmapX, int lightmapY) {
        Matrix4f m = matrix.m_85850_().m_252922_();
        bb.m_252986_(m, -0.5f, 0.0f, -0.5f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(m, -0.5f, 0.0f, 0.5f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(m, 0.5f, 0.0f, 0.5f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(m, 0.5f, 0.0f, -0.5f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
    }
}

