/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.particle;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public enum MTParticleTypes {
    FOG("fog", 352, false),
    WIND("wind", 353, false);

    private final String particleName;
    private final int particleID;
    private final boolean shouldIgnoreRange;
    private final int argumentCount;
    private static final Map<Integer, MTParticleTypes> PARTICLES;
    private static final Map<String, MTParticleTypes> BY_NAME;

    private MTParticleTypes(String particleNameIn, int particleIDIn, boolean shouldIgnoreRangeIn, int argumentCountIn) {
        this.particleName = particleNameIn;
        this.particleID = particleIDIn;
        this.shouldIgnoreRange = shouldIgnoreRangeIn;
        this.argumentCount = argumentCountIn;
    }

    private MTParticleTypes(String particleNameIn, int particleIDIn, boolean shouldIgnoreRangeIn) {
        this(particleNameIn, particleIDIn, shouldIgnoreRangeIn, 0);
    }

    public static Set<String> getParticleNames() {
        return BY_NAME.keySet();
    }

    public String getParticleName() {
        return this.particleName;
    }

    public int getParticleID() {
        return this.particleID;
    }

    public int getArgumentCount() {
        return this.argumentCount;
    }

    public boolean getShouldIgnoreRange() {
        return this.shouldIgnoreRange;
    }

    @Nullable
    public static MTParticleTypes getParticleFromId(int particleId) {
        return PARTICLES.get(particleId);
    }

    @Nullable
    public static MTParticleTypes getByName(String nameIn) {
        return BY_NAME.get(nameIn);
    }

    static {
        PARTICLES = Maps.newHashMap();
        BY_NAME = Maps.newHashMap();
        for (MTParticleTypes enumparticletypes : MTParticleTypes.values()) {
            PARTICLES.put(enumparticletypes.getParticleID(), enumparticletypes);
            BY_NAME.put(enumparticletypes.getParticleName(), enumparticletypes);
        }
    }
}

