/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.advancement.criterion;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import forge.net.mca.MCA;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class HeartsCriterion
extends SimpleCriterionTrigger<Conditions> {
    private static final ResourceLocation ID = MCA.locate("hearts");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Conditions conditionsFromJson(JsonObject json, ContextAwarePredicate player, DeserializationContext deserializer) {
        MinMaxBounds.Ints hearts = MinMaxBounds.Ints.m_55373_((JsonElement)json.get("hearts"));
        MinMaxBounds.Ints increase = MinMaxBounds.Ints.m_55373_((JsonElement)json.get("increase"));
        String source = json.has("source") ? json.get("source").getAsString() : "";
        return new Conditions(player, hearts, increase, source);
    }

    public void trigger(ServerPlayer player, int hearts, int increase, String source) {
        this.m_66234_(player, conditions -> conditions.test(hearts, increase, source));
    }

    public static class Conditions
    extends AbstractCriterionTriggerInstance {
        private final MinMaxBounds.Ints hearts;
        private final MinMaxBounds.Ints increase;
        private final String source;

        public Conditions(ContextAwarePredicate player, MinMaxBounds.Ints hearts, MinMaxBounds.Ints increase, String source) {
            super(ID, player);
            this.hearts = hearts;
            this.increase = increase;
            this.source = source;
        }

        public boolean test(int hearts, int increase, String source) {
            return this.hearts.m_55390_(hearts) && this.increase.m_55390_(increase) && (MCA.isBlankString(this.source) || this.source.equals(source));
        }

        public JsonObject m_7683_(SerializationContext serializer) {
            JsonObject json = super.m_7683_(serializer);
            json.add("hearts", this.hearts.m_55328_());
            json.add("increase", this.increase.m_55328_());
            json.add("source", (JsonElement)new JsonPrimitive(this.source));
            return json;
        }
    }
}

