/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.minersdelight.repack.registrate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.sammy.minersdelight.repack.registrate.builders.BlockBuilder;
import com.sammy.minersdelight.repack.registrate.builders.BlockEntityBuilder;
import com.sammy.minersdelight.repack.registrate.builders.Builder;
import com.sammy.minersdelight.repack.registrate.builders.BuilderCallback;
import com.sammy.minersdelight.repack.registrate.builders.EnchantmentBuilder;
import com.sammy.minersdelight.repack.registrate.builders.EntityBuilder;
import com.sammy.minersdelight.repack.registrate.builders.FluidBuilder;
import com.sammy.minersdelight.repack.registrate.builders.ItemBuilder;
import com.sammy.minersdelight.repack.registrate.builders.MenuBuilder;
import com.sammy.minersdelight.repack.registrate.builders.NoConfigBuilder;
import com.sammy.minersdelight.repack.registrate.providers.ProviderType;
import com.sammy.minersdelight.repack.registrate.providers.RegistrateDataProvider;
import com.sammy.minersdelight.repack.registrate.providers.RegistrateLangProvider;
import com.sammy.minersdelight.repack.registrate.providers.RegistrateProvider;
import com.sammy.minersdelight.repack.registrate.util.CreativeModeTabModifier;
import com.sammy.minersdelight.repack.registrate.util.DebugMarkers;
import com.sammy.minersdelight.repack.registrate.util.OneTimeEventReceiver;
import com.sammy.minersdelight.repack.registrate.util.entry.ItemEntry;
import com.sammy.minersdelight.repack.registrate.util.entry.ItemProviderEntry;
import com.sammy.minersdelight.repack.registrate.util.entry.RegistryEntry;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonNullBiFunction;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonNullConsumer;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonNullFunction;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonNullSupplier;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonNullUnaryOperator;
import com.sammy.minersdelight.repack.registrate.util.nullness.NonnullType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class AbstractRegistrate<S extends AbstractRegistrate<S>> {
    private static final Logger log = LogManager.getLogger(AbstractRegistrate.class);
    private final Table<ResourceKey<? extends Registry<?>>, String, Registration<?, ?>> registrations = HashBasedTable.create();
    private final Multimap<Pair<String, ResourceKey<? extends Registry<?>>>, NonNullConsumer<?>> registerCallbacks = HashMultimap.create();
    private final Multimap<ResourceKey<? extends Registry<?>>, Runnable> afterRegisterCallbacks = HashMultimap.create();
    private final Set<ResourceKey<? extends Registry<?>>> completedRegistrations = new HashSet();
    private final Table<Pair<String, ResourceKey<? extends Registry<?>>>, ProviderType<?>, Consumer<? extends RegistrateProvider>> datagensByEntry = HashBasedTable.create();
    private final ListMultimap<ProviderType<?>, @NonnullType NonNullConsumer<? extends RegistrateProvider>> datagens = ArrayListMultimap.create();
    private final Multimap<ResourceKey<CreativeModeTab>, Consumer<CreativeModeTabModifier>> creativeModeTabModifiers = ArrayListMultimap.create();
    private ResourceKey<CreativeModeTab> defaultCreativeModeTab = CreativeModeTabs.f_256750_;
    private final NonNullSupplier<Boolean> doDatagen = NonNullSupplier.lazy(DatagenModLoader::isRunningDataGen);
    private final String modid;
    @Nullable
    private String currentName;
    private boolean skipErrors;
    @Nullable
    private RegistrateDataProvider provider;
    private final NonNullSupplier<List<Pair<String, String>>> extraLang = NonNullSupplier.lazy(() -> {
        ArrayList ret = new ArrayList();
        this.addDataGenerator(ProviderType.LANG, prov -> ret.forEach(p -> prov.add((String)p.getKey(), (String)p.getValue())));
        return ret;
    });

    public static boolean isDevEnvironment() {
        return FMLEnvironment.naming.equals("mcp");
    }

    protected AbstractRegistrate(String modid) {
        this.modid = modid;
    }

    protected final S self() {
        return (S)this;
    }

    public IEventBus getModEventBus() {
        return FMLJavaModLoadingContext.get().getModEventBus();
    }

    protected S registerEventListeners(IEventBus bus) {
        Consumer<RegisterEvent> onRegister = this::onRegister;
        Consumer<RegisterEvent> onRegisterLate = this::onRegisterLate;
        bus.addListener(onRegister);
        bus.addListener(EventPriority.LOWEST, onRegisterLate);
        bus.addListener(this::onBuildCreativeModeTabContents);
        OneTimeEventReceiver.addModListener(this, FMLCommonSetupEvent.class, $ -> {
            OneTimeEventReceiver.unregister(this, (Object)onRegister, RegisterEvent.class);
            OneTimeEventReceiver.unregister(this, (Object)onRegisterLate, RegisterEvent.class);
        });
        if (this.doDatagen.get().booleanValue()) {
            OneTimeEventReceiver.addModListener(this, GatherDataEvent.class, this::onData);
        }
        return this.self();
    }

    protected void onRegister(RegisterEvent event) {
        Map registrationsForType;
        ResourceKey type = event.getRegistryKey();
        if (type == null) {
            log.debug(DebugMarkers.REGISTER, "Skipping invalid registry with no supertype: " + event.getRegistryKey());
            return;
        }
        if (!this.registerCallbacks.isEmpty()) {
            this.registerCallbacks.asMap().forEach((k, v) -> log.warn("Found {} unused register callback(s) for entry {} [{}]. Was the entry ever registered?", (Object)v.size(), k.getLeft(), (Object)((ResourceKey)k.getRight()).m_135782_()));
            this.registerCallbacks.clear();
            if (AbstractRegistrate.isDevEnvironment()) {
                throw new IllegalStateException("Found unused register callbacks, see logs");
            }
        }
        if ((registrationsForType = this.registrations.row((Object)type)).size() > 0) {
            log.debug(DebugMarkers.REGISTER, "Registering {} known objects of type {}", (Object)registrationsForType.size(), (Object)type.m_135782_());
            for (Map.Entry e : registrationsForType.entrySet()) {
                try {
                    ((Registration)e.getValue()).register(event);
                    log.debug(DebugMarkers.REGISTER, "Registered {} to registry {}", (Object)((Registration)e.getValue()).getName(), (Object)event.getRegistryKey());
                }
                catch (Exception ex) {
                    String err = "Unexpected error while registering entry " + ((Registration)e.getValue()).getName() + " to registry " + event.getRegistryKey();
                    if (this.skipErrors) {
                        log.error(DebugMarkers.REGISTER, err);
                        continue;
                    }
                    throw new RuntimeException(err, ex);
                }
            }
        }
    }

    protected void onRegisterLate(RegisterEvent event) {
        ResourceKey type = event.getRegistryKey();
        Collection callbacks = this.afterRegisterCallbacks.get((Object)type);
        callbacks.forEach(Runnable::run);
        callbacks.clear();
        this.completedRegistrations.add(type);
    }

    protected void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        CreativeModeTabModifier modifier = new CreativeModeTabModifier(() -> ((BuildCreativeModeTabContentsEvent)event).getFlags(), () -> ((BuildCreativeModeTabContentsEvent)event).hasPermissions(), (arg_0, arg_1) -> ((BuildCreativeModeTabContentsEvent)event).m_246267_(arg_0, arg_1));
        this.creativeModeTabModifiers.forEach((key, value) -> {
            if (event.getTabKey().equals(key)) {
                value.accept(modifier);
            }
        });
    }

    protected void onData(GatherDataEvent event) {
        this.provider = new RegistrateDataProvider(this, this.modid, event);
        event.getGenerator().addProvider(true, (DataProvider)this.provider);
    }

    protected String currentName() {
        String name = this.currentName;
        Objects.requireNonNull(name, "Current name not set");
        return name;
    }

    public <R, T extends R> RegistryEntry<T> get(ResourceKey<? extends Registry<R>> type) {
        return this.get(this.currentName(), type);
    }

    public <R, T extends R> RegistryEntry<T> get(String name, ResourceKey<? extends Registry<R>> type) {
        return this.getRegistration(name, type).getDelegate();
    }

    public <R, T extends R> RegistryEntry<T> getOptional(String name, ResourceKey<? extends Registry<R>> type) {
        Registration<R, T> reg = this.getRegistrationUnchecked(name, type);
        return reg == null ? RegistryEntry.empty() : reg.getDelegate();
    }

    @Nullable
    private <R, T extends R> Registration<R, T> getRegistrationUnchecked(String name, ResourceKey<? extends Registry<R>> type) {
        return (Registration)this.registrations.get(type, (Object)name);
    }

    private <R, T extends R> Registration<R, T> getRegistration(String name, ResourceKey<? extends Registry<R>> type) {
        Registration<R, T> reg = this.getRegistrationUnchecked(name, type);
        if (reg != null) {
            return reg;
        }
        throw new IllegalArgumentException("Unknown registration " + name + " for type " + type);
    }

    public <R> Collection<RegistryEntry<R>> getAll(ResourceKey<? extends Registry<R>> type) {
        return this.registrations.row(type).values().stream().map(r -> r.getDelegate()).collect(Collectors.toList());
    }

    public <R, T extends R> S addRegisterCallback(String name, ResourceKey<? extends Registry<R>> registryType, NonNullConsumer<? super T> callback) {
        Registration<R, ? super T> reg = this.getRegistrationUnchecked(name, registryType);
        if (reg == null) {
            this.registerCallbacks.put((Object)Pair.of((Object)name, registryType), callback);
        } else {
            reg.addRegisterCallback(callback);
        }
        return this.self();
    }

    public <R> S addRegisterCallback(ResourceKey<? extends Registry<R>> registryType, Runnable callback) {
        this.afterRegisterCallbacks.put(registryType, (Object)callback);
        return this.self();
    }

    public <R> boolean isRegistered(ResourceKey<? extends Registry<R>> registryType) {
        return this.completedRegistrations.contains(registryType);
    }

    public <P extends RegistrateProvider> Optional<P> getDataProvider(ProviderType<P> type) {
        RegistrateDataProvider provider = this.provider;
        if (provider != null) {
            return provider.getSubProvider(type);
        }
        throw new IllegalStateException("Cannot get data provider before datagen is started");
    }

    public <P extends RegistrateProvider, R> S setDataGenerator(Builder<R, ?, ?, ?> builder, ProviderType<? extends P> type, NonNullConsumer<? extends P> cons) {
        return this.setDataGenerator(builder.getName(), builder.getRegistryKey(), type, cons);
    }

    public <P extends RegistrateProvider, R> S setDataGenerator(String entry, ResourceKey<? extends Registry<R>> registryType, ProviderType<? extends P> type, NonNullConsumer<? extends P> cons) {
        if (!this.doDatagen.get().booleanValue()) {
            return this.self();
        }
        Consumer existing = (Consumer)this.datagensByEntry.put((Object)Pair.of((Object)entry, registryType), type, cons);
        if (existing != null) {
            this.datagens.remove(type, (Object)existing);
        }
        return this.addDataGenerator(type, cons);
    }

    public <T extends RegistrateProvider> S addDataGenerator(ProviderType<? extends T> type, NonNullConsumer<? extends T> cons) {
        if (this.doDatagen.get().booleanValue()) {
            this.datagens.put(type, cons);
        }
        return this.self();
    }

    public MutableComponent addLang(String type, ResourceLocation id, String localizedName) {
        return this.addRawLang(Util.m_137492_((String)type, (ResourceLocation)id), localizedName);
    }

    public MutableComponent addLang(String type, ResourceLocation id, String suffix, String localizedName) {
        return this.addRawLang(Util.m_137492_((String)type, (ResourceLocation)id) + "." + suffix, localizedName);
    }

    public MutableComponent addRawLang(String key, String value) {
        if (this.doDatagen.get().booleanValue()) {
            this.extraLang.get().add((Pair<String, String>)Pair.of((Object)key, (Object)value));
        }
        return Component.m_237115_((String)key);
    }

    private Optional<Pair<String, ResourceKey<? extends Registry<?>>>> getEntryForGenerator(ProviderType<?> type, NonNullConsumer<? extends RegistrateProvider> generator) {
        for (Map.Entry e : this.datagensByEntry.column(type).entrySet()) {
            if (e.getValue() != generator) continue;
            return Optional.of((Pair)e.getKey());
        }
        return Optional.empty();
    }

    public <T extends RegistrateProvider> void genData(ProviderType<? extends T> type, T gen) {
        if (!this.doDatagen.get().booleanValue()) {
            return;
        }
        this.datagens.get(type).forEach(cons -> {
            Optional<Pair<String, ResourceKey<Registry<?>>>> entry = null;
            if (log.isEnabled(Level.DEBUG, DebugMarkers.DATA)) {
                entry = this.getEntryForGenerator(type, (NonNullConsumer<? extends RegistrateProvider>)cons);
                if (entry.isPresent()) {
                    log.debug(DebugMarkers.DATA, "Generating data of type {} for entry {} [{}]", (Object)RegistrateDataProvider.getTypeName(type), entry.get().getLeft(), (Object)((ResourceKey)entry.get().getRight()).m_135782_());
                } else {
                    log.debug(DebugMarkers.DATA, "Generating unassociated data of type {} ({})", (Object)RegistrateDataProvider.getTypeName(type), (Object)type);
                }
            }
            try {
                cons.accept(gen);
            }
            catch (Exception e) {
                if (entry == null) {
                    entry = this.getEntryForGenerator(type, (NonNullConsumer<? extends RegistrateProvider>)cons);
                }
                Message err = entry.isPresent() ? log.getMessageFactory().newMessage("Unexpected error while running data generator of type {} for entry {} [{}]", new Object[]{RegistrateDataProvider.getTypeName(type), entry.get().getLeft(), ((ResourceKey)entry.get().getRight()).m_135782_()}) : log.getMessageFactory().newMessage("Unexpected error while running unassociated data generator of type {} ({})", new Object[]{RegistrateDataProvider.getTypeName(type), type});
                if (this.skipErrors) {
                    log.error(err);
                }
                throw new RuntimeException(err.getFormattedMessage(), e);
            }
        });
    }

    public S skipErrors(boolean skipErrors) {
        if (skipErrors && !AbstractRegistrate.isDevEnvironment()) {
            log.error("Ignoring skipErrors(true) as this is not a development environment!");
        } else {
            this.skipErrors = skipErrors;
        }
        return this.self();
    }

    public S object(String name) {
        this.currentName = name;
        return this.self();
    }

    public S defaultCreativeTab(ResourceKey<CreativeModeTab> creativeModeTab) {
        this.defaultCreativeModeTab = creativeModeTab;
        return this.self();
    }

    public S modifyCreativeModeTab(ResourceKey<CreativeModeTab> creativeModeTab, Consumer<CreativeModeTabModifier> modifier) {
        this.creativeModeTabModifiers.put(creativeModeTab, modifier);
        return this.self();
    }

    public S transform(NonNullUnaryOperator<S> func) {
        return (S)((AbstractRegistrate)func.apply(this.self()));
    }

    public <R, T extends R, P, S2 extends Builder<R, T, P, S2>> S2 transform(NonNullFunction<S, S2> func) {
        return (S2)((Builder)func.apply(this.self()));
    }

    public <R, T extends R, P, S2 extends Builder<R, T, P, S2>> S2 entry(NonNullBiFunction<String, BuilderCallback, S2> factory) {
        return (S2)this.entry(this.currentName(), callback -> (Builder)factory.apply(this.currentName(), (BuilderCallback)callback));
    }

    public <R, T extends R, P, S2 extends Builder<R, T, P, S2>> S2 entry(String name, NonNullFunction<BuilderCallback, S2> factory) {
        return (S2)((Builder)factory.apply(this::accept));
    }

    protected <R, T extends R> RegistryEntry<T> accept(String name, ResourceKey<? extends Registry<R>> type, Builder<R, T, ?, ?> builder, NonNullSupplier<? extends T> creator, NonNullFunction<RegistryObject<T>, ? extends RegistryEntry<T>> entryFactory) {
        Registration reg = new Registration(new ResourceLocation(this.modid, name), type, creator, entryFactory);
        log.debug(DebugMarkers.REGISTER, "Captured registration for entry {} of type {}", (Object)name, (Object)type.m_135782_());
        this.registerCallbacks.removeAll((Object)Pair.of((Object)name, type)).forEach(callback -> {
            NonNullConsumer unsafeCallback = callback;
            reg.addRegisterCallback(unsafeCallback);
        });
        this.registrations.put(type, (Object)name, reg);
        return reg.getDelegate();
    }

    public <R> ResourceKey<Registry<R>> makeRegistry(String name, Supplier<RegistryBuilder<R>> builder) {
        ResourceKey registryId = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation(this.getModid(), name));
        OneTimeEventReceiver.addModListener(this, NewRegistryEvent.class, e -> e.create(((RegistryBuilder)builder.get()).setName(registryId.m_135782_())));
        return registryId;
    }

    public <R, T extends R> RegistryEntry<T> simple(ResourceKey<Registry<R>> registryType, NonNullSupplier<T> factory) {
        return this.simple((Object)this.currentName(), registryType, factory);
    }

    public <R, T extends R> RegistryEntry<T> simple(String name, ResourceKey<Registry<R>> registryType, NonNullSupplier<T> factory) {
        return this.simple(this, name, registryType, factory);
    }

    public <R, T extends R, P> RegistryEntry<T> simple(P parent, ResourceKey<Registry<R>> registryType, NonNullSupplier<T> factory) {
        return this.simple(parent, this.currentName(), registryType, factory);
    }

    public <R, T extends R, P> RegistryEntry<T> simple(P parent, String name, ResourceKey<Registry<R>> registryType, NonNullSupplier<T> factory) {
        return this.generic(parent, name, registryType, factory).register();
    }

    public <R, T extends R> NoConfigBuilder<R, T, S> generic(ResourceKey<Registry<R>> registryType, NonNullSupplier<T> factory) {
        return this.generic(this.self(), registryType, factory);
    }

    public <R, T extends R> NoConfigBuilder<R, T, S> generic(String name, ResourceKey<Registry<R>> registryType, NonNullSupplier<T> factory) {
        return this.generic(this.self(), name, registryType, factory);
    }

    public <R, T extends R, P> NoConfigBuilder<R, T, P> generic(P parent, ResourceKey<Registry<R>> registryType, NonNullSupplier<T> factory) {
        return this.generic(parent, this.currentName(), registryType, factory);
    }

    public <R, T extends R, P> NoConfigBuilder<R, T, P> generic(P parent, String name, ResourceKey<Registry<R>> registryType, NonNullSupplier<T> factory) {
        return this.entry(name, callback -> new NoConfigBuilder(this, parent, name, (BuilderCallback)callback, registryType, factory));
    }

    public <T extends Item> ItemBuilder<T, S> item(NonNullFunction<Item.Properties, T> factory) {
        return this.item(this.self(), factory);
    }

    public <T extends Item> ItemBuilder<T, S> item(String name, NonNullFunction<Item.Properties, T> factory) {
        return this.item(this.self(), name, factory);
    }

    public <T extends Item, P> ItemBuilder<T, P> item(P parent, NonNullFunction<Item.Properties, T> factory) {
        return this.item(parent, this.currentName(), factory);
    }

    public <T extends Item, P> ItemBuilder<T, P> item(P parent, String name, NonNullFunction<Item.Properties, T> factory) {
        return this.entry(name, callback -> ItemBuilder.create(this, parent, name, callback, factory).transform((S builder) -> this.defaultCreativeModeTab == null ? builder : builder.tab(this.defaultCreativeModeTab)));
    }

    public <T extends Block> BlockBuilder<T, S> block(NonNullFunction<BlockBehaviour.Properties, T> factory) {
        return this.block(this.self(), factory);
    }

    public <T extends Block> BlockBuilder<T, S> block(String name, NonNullFunction<BlockBehaviour.Properties, T> factory) {
        return this.block(this.self(), name, factory);
    }

    public <T extends Block, P> BlockBuilder<T, P> block(P parent, NonNullFunction<BlockBehaviour.Properties, T> factory) {
        return this.block(parent, this.currentName(), factory);
    }

    public <T extends Block, P> BlockBuilder<T, P> block(P parent, String name, NonNullFunction<BlockBehaviour.Properties, T> factory) {
        return this.entry(name, callback -> BlockBuilder.create(this, parent, name, callback, factory));
    }

    public <T extends Entity> EntityBuilder<T, S> entity(EntityType.EntityFactory<T> factory, MobCategory classification) {
        return this.entity(this.self(), factory, classification);
    }

    public <T extends Entity> EntityBuilder<T, S> entity(String name, EntityType.EntityFactory<T> factory, MobCategory classification) {
        return this.entity(this.self(), name, factory, classification);
    }

    public <T extends Entity, P> EntityBuilder<T, P> entity(P parent, EntityType.EntityFactory<T> factory, MobCategory classification) {
        return this.entity(parent, this.currentName(), factory, classification);
    }

    public <T extends Entity, P> EntityBuilder<T, P> entity(P parent, String name, EntityType.EntityFactory<T> factory, MobCategory classification) {
        return this.entry(name, callback -> EntityBuilder.create(this, parent, name, callback, factory, classification));
    }

    public <T extends BlockEntity> BlockEntityBuilder<T, S> blockEntity(BlockEntityBuilder.BlockEntityFactory<T> factory) {
        return this.blockEntity(this.self(), factory);
    }

    public <T extends BlockEntity> BlockEntityBuilder<T, S> blockEntity(String name, BlockEntityBuilder.BlockEntityFactory<T> factory) {
        return this.blockEntity(this.self(), name, factory);
    }

    public <T extends BlockEntity, P> BlockEntityBuilder<T, P> blockEntity(P parent, BlockEntityBuilder.BlockEntityFactory<T> factory) {
        return this.blockEntity(parent, this.currentName(), factory);
    }

    public <T extends BlockEntity, P> BlockEntityBuilder<T, P> blockEntity(P parent, String name, BlockEntityBuilder.BlockEntityFactory<T> factory) {
        return this.entry(name, callback -> BlockEntityBuilder.create(this, parent, name, callback, factory));
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid() {
        return this.fluid(this.self());
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid(FluidBuilder.FluidTypeFactory typeFactory) {
        return this.fluid(this.self(), typeFactory);
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid(NonNullSupplier<FluidType> fluidType) {
        return this.fluid(this.self(), fluidType);
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return this.fluid(this.self(), stillTexture, flowingTexture);
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid(ResourceLocation stillTexture, ResourceLocation flowingTexture, FluidBuilder.FluidTypeFactory typeFactory) {
        return this.fluid(this.self(), stillTexture, flowingTexture, typeFactory);
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid(ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullSupplier<FluidType> fluidType) {
        return this.fluid(this.self(), stillTexture, flowingTexture, fluidType);
    }

    public <T extends ForgeFlowingFluid> FluidBuilder<T, S> fluid(ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory) {
        return this.fluid(this.self(), stillTexture, flowingTexture, fluidFactory);
    }

    public <T extends ForgeFlowingFluid> FluidBuilder<T, S> fluid(ResourceLocation stillTexture, ResourceLocation flowingTexture, FluidBuilder.FluidTypeFactory typeFactory, NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory) {
        return this.fluid(this.self(), stillTexture, flowingTexture, typeFactory, fluidFactory);
    }

    public <T extends ForgeFlowingFluid> FluidBuilder<T, S> fluid(ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullSupplier<FluidType> fluidType, NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory) {
        return this.fluid(this.self(), stillTexture, flowingTexture, fluidType, fluidFactory);
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid(String name) {
        return this.fluid(this.self(), name);
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid(String name, FluidBuilder.FluidTypeFactory typeFactory) {
        return this.fluid(this.self(), name, typeFactory);
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid(String name, NonNullSupplier<FluidType> fluidType) {
        return this.fluid(this.self(), name, fluidType);
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return this.fluid(this.self(), name, stillTexture, flowingTexture);
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, FluidBuilder.FluidTypeFactory typeFactory) {
        return this.fluid(this.self(), name, stillTexture, flowingTexture, typeFactory);
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, S> fluid(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullSupplier<FluidType> fluidType) {
        return this.fluid(this.self(), name, stillTexture, flowingTexture, fluidType);
    }

    public <T extends ForgeFlowingFluid> FluidBuilder<T, S> fluid(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory) {
        return this.fluid(this.self(), name, stillTexture, flowingTexture, fluidFactory);
    }

    public <T extends ForgeFlowingFluid> FluidBuilder<T, S> fluid(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, FluidBuilder.FluidTypeFactory typeFactory, NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory) {
        return this.fluid(this.self(), name, stillTexture, flowingTexture, typeFactory, fluidFactory);
    }

    public <T extends ForgeFlowingFluid> FluidBuilder<T, S> fluid(String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullSupplier<FluidType> fluidType, NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory) {
        return this.fluid(this.self(), name, stillTexture, flowingTexture, fluidType, fluidFactory);
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent) {
        return this.fluid(parent, this.currentName());
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent, FluidBuilder.FluidTypeFactory typeFactory) {
        return this.fluid(parent, this.currentName(), typeFactory);
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent, NonNullSupplier<FluidType> fluidType) {
        return this.fluid(parent, this.currentName(), fluidType);
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return this.fluid(parent, this.currentName(), stillTexture, flowingTexture);
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent, ResourceLocation stillTexture, ResourceLocation flowingTexture, FluidBuilder.FluidTypeFactory typeFactory) {
        return this.fluid(parent, this.currentName(), stillTexture, flowingTexture, typeFactory);
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullSupplier<FluidType> fluidType) {
        return this.fluid(parent, this.currentName(), stillTexture, flowingTexture, fluidType);
    }

    public <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> fluid(P parent, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory) {
        return this.fluid(parent, this.currentName(), stillTexture, flowingTexture, fluidFactory);
    }

    public <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> fluid(P parent, ResourceLocation stillTexture, ResourceLocation flowingTexture, FluidBuilder.FluidTypeFactory typeFactory, NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory) {
        return this.fluid(parent, this.currentName(), stillTexture, flowingTexture, typeFactory, fluidFactory);
    }

    public <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> fluid(P parent, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullSupplier<FluidType> fluidType, NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory) {
        return this.fluid(parent, this.currentName(), stillTexture, flowingTexture, fluidType, fluidFactory);
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent, String name) {
        return this.fluid(parent, name, new ResourceLocation(this.getModid(), "block/" + this.currentName() + "_still"), new ResourceLocation(this.getModid(), "block/" + this.currentName() + "_flow"));
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent, String name, FluidBuilder.FluidTypeFactory typeFactory) {
        return this.fluid(parent, name, new ResourceLocation(this.getModid(), "block/" + this.currentName() + "_still"), new ResourceLocation(this.getModid(), "block/" + this.currentName() + "_flow"), typeFactory);
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent, String name, NonNullSupplier<FluidType> fluidType) {
        return this.fluid(parent, name, new ResourceLocation(this.getModid(), "block/" + this.currentName() + "_still"), new ResourceLocation(this.getModid(), "block/" + this.currentName() + "_flow"), fluidType);
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent, String name, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return this.entry(name, callback -> FluidBuilder.create(this, parent, name, callback, stillTexture, flowingTexture));
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent, String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, FluidBuilder.FluidTypeFactory typeFactory) {
        return this.entry(name, callback -> FluidBuilder.create(this, parent, name, callback, stillTexture, flowingTexture, typeFactory));
    }

    public <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> fluid(P parent, String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullSupplier<FluidType> fluidType) {
        return this.entry(name, callback -> FluidBuilder.create(this, parent, name, callback, stillTexture, flowingTexture, fluidType));
    }

    public <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> fluid(P parent, String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory) {
        return this.entry(name, callback -> FluidBuilder.create(this, parent, name, callback, stillTexture, flowingTexture, fluidFactory));
    }

    public <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> fluid(P parent, String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, FluidBuilder.FluidTypeFactory typeFactory, NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory) {
        return this.entry(name, callback -> FluidBuilder.create(this, parent, name, callback, stillTexture, flowingTexture, typeFactory, fluidFactory));
    }

    public <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> fluid(P parent, String name, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullSupplier<FluidType> fluidType, NonNullFunction<ForgeFlowingFluid.Properties, T> fluidFactory) {
        return this.entry(name, callback -> FluidBuilder.create(this, parent, name, callback, stillTexture, flowingTexture, fluidType, fluidFactory));
    }

    public <T extends AbstractContainerMenu, SC extends Screen> MenuBuilder<T, SC, S> menu(MenuBuilder.MenuFactory<T> factory, NonNullSupplier<MenuBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.menu((Object)this.currentName(), factory, screenFactory);
    }

    public <T extends AbstractContainerMenu, SC extends Screen> MenuBuilder<T, SC, S> menu(String name, MenuBuilder.MenuFactory<T> factory, NonNullSupplier<MenuBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.menu(this.self(), name, factory, screenFactory);
    }

    public <T extends AbstractContainerMenu, SC extends Screen, P> MenuBuilder<T, SC, P> menu(P parent, MenuBuilder.MenuFactory<T> factory, NonNullSupplier<MenuBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.menu(parent, this.currentName(), factory, screenFactory);
    }

    public <T extends AbstractContainerMenu, SC extends Screen, P> MenuBuilder<T, SC, P> menu(P parent, String name, MenuBuilder.MenuFactory<T> factory, NonNullSupplier<MenuBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.entry(name, callback -> new MenuBuilder((AbstractRegistrate<?>)this, parent, name, (BuilderCallback)callback, factory, screenFactory));
    }

    public <T extends AbstractContainerMenu, SC extends Screen> MenuBuilder<T, SC, S> menu(MenuBuilder.ForgeMenuFactory<T> factory, NonNullSupplier<MenuBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.menu((Object)this.currentName(), factory, screenFactory);
    }

    public <T extends AbstractContainerMenu, SC extends Screen> MenuBuilder<T, SC, S> menu(String name, MenuBuilder.ForgeMenuFactory<T> factory, NonNullSupplier<MenuBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.menu(this.self(), name, factory, screenFactory);
    }

    public <T extends AbstractContainerMenu, SC extends Screen, P> MenuBuilder<T, SC, P> menu(P parent, MenuBuilder.ForgeMenuFactory<T> factory, NonNullSupplier<MenuBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.menu(parent, this.currentName(), factory, screenFactory);
    }

    public <T extends AbstractContainerMenu, SC extends Screen, P> MenuBuilder<T, SC, P> menu(P parent, String name, MenuBuilder.ForgeMenuFactory<T> factory, NonNullSupplier<MenuBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.entry(name, callback -> new MenuBuilder((AbstractRegistrate<?>)this, parent, name, (BuilderCallback)callback, factory, screenFactory));
    }

    public <T extends Enchantment> EnchantmentBuilder<T, S> enchantment(EnchantmentCategory type, EnchantmentBuilder.EnchantmentFactory<T> factory) {
        return this.enchantment(this.self(), type, factory);
    }

    public <T extends Enchantment> EnchantmentBuilder<T, S> enchantment(String name, EnchantmentCategory type, EnchantmentBuilder.EnchantmentFactory<T> factory) {
        return this.enchantment(this.self(), name, type, factory);
    }

    public <T extends Enchantment, P> EnchantmentBuilder<T, P> enchantment(P parent, EnchantmentCategory type, EnchantmentBuilder.EnchantmentFactory<T> factory) {
        return this.enchantment(parent, this.currentName(), type, factory);
    }

    public <T extends Enchantment, P> EnchantmentBuilder<T, P> enchantment(P parent, String name, EnchantmentCategory type, EnchantmentBuilder.EnchantmentFactory<T> factory) {
        return this.entry(name, callback -> EnchantmentBuilder.create(this, parent, name, callback, type, factory));
    }

    public NoConfigBuilder<CreativeModeTab, CreativeModeTab, S> defaultCreativeTab() {
        return this.defaultCreativeTab(this.self());
    }

    public NoConfigBuilder<CreativeModeTab, CreativeModeTab, S> defaultCreativeTab(String name) {
        return this.defaultCreativeTab(this.self(), name);
    }

    public <P> NoConfigBuilder<CreativeModeTab, CreativeModeTab, P> defaultCreativeTab(P parent) {
        return this.defaultCreativeTab(parent, this.currentName());
    }

    public <P> NoConfigBuilder<CreativeModeTab, CreativeModeTab, P> defaultCreativeTab(P parent, String name) {
        return this.defaultCreativeTab(parent, name, tab -> {});
    }

    public NoConfigBuilder<CreativeModeTab, CreativeModeTab, S> defaultCreativeTab(Consumer<CreativeModeTab.Builder> config) {
        return this.defaultCreativeTab(this.self(), config);
    }

    public NoConfigBuilder<CreativeModeTab, CreativeModeTab, S> defaultCreativeTab(String name, Consumer<CreativeModeTab.Builder> config) {
        return this.defaultCreativeTab(this.self(), name, config);
    }

    public <P> NoConfigBuilder<CreativeModeTab, CreativeModeTab, P> defaultCreativeTab(P parent, Consumer<CreativeModeTab.Builder> config) {
        return this.defaultCreativeTab(parent, this.currentName(), config);
    }

    public <P> NoConfigBuilder<CreativeModeTab, CreativeModeTab, P> defaultCreativeTab(P parent, String name, Consumer<CreativeModeTab.Builder> config) {
        this.defaultCreativeModeTab = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation(this.modid, name));
        return this.generic(parent, name, Registries.f_279569_, () -> {
            CreativeModeTab.Builder builder = CreativeModeTab.builder().m_257737_(() -> this.getAll(Registries.f_256913_).stream().findFirst().map(ItemEntry::cast).map(ItemProviderEntry::asStack).orElse(new ItemStack((ItemLike)Items.f_41852_))).m_257941_((Component)this.addLang("itemGroup", this.defaultCreativeModeTab.m_135782_(), RegistrateLangProvider.toEnglishName(name)));
            config.accept(builder);
            return builder.m_257652_();
        });
    }

    public String getModid() {
        return this.modid;
    }

    private final class Registration<R, T extends R> {
        private final ResourceLocation name;
        private final ResourceKey<? extends Registry<R>> type;
        private final NonNullSupplier<? extends T> creator;
        private final RegistryEntry<T> delegate;
        private final List<NonNullConsumer<? super T>> callbacks = new ArrayList<NonNullConsumer<? super T>>();

        Registration(ResourceLocation name, ResourceKey<? extends Registry<R>> type, NonNullSupplier<? extends T> creator, NonNullFunction<RegistryObject<T>, ? extends RegistryEntry<T>> entryFactory) {
            this.name = name;
            this.type = type;
            this.creator = creator.lazy();
            this.delegate = entryFactory.apply(RegistryObject.create((ResourceLocation)name, (ResourceLocation)type.m_135782_(), (String)AbstractRegistrate.this.getModid()));
        }

        void register(RegisterEvent event) {
            Object entry = this.creator.get();
            event.register(this.type, rh -> rh.register(this.name, entry));
            this.delegate.updateReference(event);
            this.callbacks.forEach(c -> c.accept(entry));
            this.callbacks.clear();
        }

        void addRegisterCallback(NonNullConsumer<? super T> callback) {
            Preconditions.checkNotNull(callback, (Object)"Callback must not be null");
            this.callbacks.add(callback);
        }

        public ResourceLocation getName() {
            return this.name;
        }

        public ResourceKey<? extends Registry<R>> getType() {
            return this.type;
        }

        public NonNullSupplier<? extends T> getCreator() {
            return this.creator;
        }

        public RegistryEntry<T> getDelegate() {
            return this.delegate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Registration)) {
                return false;
            }
            Registration other = (Registration)o;
            ResourceLocation this$name = this.getName();
            ResourceLocation other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            ResourceKey<Registry<R>> this$type = this.getType();
            ResourceKey<Registry<R>> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            NonNullSupplier<T> this$creator = this.getCreator();
            NonNullSupplier<T> other$creator = other.getCreator();
            if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
                return false;
            }
            RegistryEntry<T> this$delegate = this.getDelegate();
            RegistryEntry<T> other$delegate = other.getDelegate();
            if (this$delegate == null ? other$delegate != null : !((Object)this$delegate).equals(other$delegate)) {
                return false;
            }
            List<NonNullConsumer<T>> this$callbacks = this.callbacks;
            List<NonNullConsumer<? super T>> other$callbacks = other.callbacks;
            return !(this$callbacks == null ? other$callbacks != null : !((Object)this$callbacks).equals(other$callbacks));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ResourceLocation $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            ResourceKey<Registry<R>> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            NonNullSupplier<T> $creator = this.getCreator();
            result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
            RegistryEntry<T> $delegate = this.getDelegate();
            result = result * 59 + ($delegate == null ? 43 : ((Object)$delegate).hashCode());
            List<NonNullConsumer<T>> $callbacks = this.callbacks;
            result = result * 59 + ($callbacks == null ? 43 : ((Object)$callbacks).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractRegistrate.Registration(name=" + this.getName() + ", type=" + this.getType() + ", creator=" + this.getCreator() + ", delegate=" + this.getDelegate() + ", callbacks=" + this.callbacks + ")";
        }
    }
}

