/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.set;

import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.misc.BlockAndItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class ColorSetModification {
    private static final String DEFAULT_KEY = "default";
    public static final Codec<ColorSetModification> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.simpleMap((Codec)Codec.STRING, BlockAndItem.CODEC, (Keyable)ColorSetModification.makeKeys()).fieldOf("colors").forGetter(ColorSetModification::toStringMap), (App)Codec.BOOL.optionalFieldOf("replace", (Object)false).orElse((Object)false).forGetter(cs -> cs.replace), (App)ResourceLocation.f_135803_.fieldOf("id").forGetter(cs -> cs.id)).apply((Applicative)instance, ColorSetModification::new));
    private final Map<DyeColor, BlockAndItem> colorsMap = new HashMap<DyeColor, BlockAndItem>();
    private final ResourceLocation id;
    private final boolean replace;

    private static Keyable makeKeys() {
        final List list = Streams.concat((Stream[])new Stream[]{Stream.of(DEFAULT_KEY), Arrays.stream(DyeColor.values()).map(DyeColor::m_7912_)}).toList();
        return new Keyable(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return list.stream().map(arg_0 -> ops.createString(arg_0));
            }
        };
    }

    private ColorSetModification(Map<String, BlockAndItem> colorsMap, boolean replace, ResourceLocation id) {
        this.replace = replace;
        this.id = id;
        for (Map.Entry<String, BlockAndItem> entry : colorsMap.entrySet()) {
            String key = entry.getKey();
            DyeColor color = key.equals(DEFAULT_KEY) ? null : DyeColor.m_41057_((String)key, null);
            this.colorsMap.put(color, entry.getValue());
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean replace() {
        return this.replace;
    }

    public boolean hasItems() {
        return this.colorsMap.values().stream().anyMatch(bi -> bi.item() != null);
    }

    public boolean hasBlocks() {
        return this.colorsMap.values().stream().anyMatch(bi -> bi.block() != null);
    }

    public Set<Map.Entry<DyeColor, BlockAndItem>> entrySet() {
        return this.colorsMap.entrySet();
    }

    private Map<String, BlockAndItem> toStringMap() {
        HashMap<String, BlockAndItem> map = new HashMap<String, BlockAndItem>();
        for (Map.Entry<DyeColor, BlockAndItem> entry : this.colorsMap.entrySet()) {
            String key = entry.getKey() != null ? entry.getKey().m_7912_() : DEFAULT_KEY;
            map.put(key, entry.getValue());
        }
        return map;
    }
}

