/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.musicbox.common.content.networking;

import com.dannbrown.deltaboxlib.common.registrate.network.NetworkChannelHandler;
import com.dannbrown.deltaboxlib.common.registrate.network.NetworkDirection;
import com.dannbrown.deltaboxlib.common.registrate.network.NetworkPacket;
import com.dannbrown.deltaboxlib.common.registrate.util.DeltaboxUtil;
import com.dannbrown.musicbox.common.init.ModContent;
import com.dannbrown.musicbox.common.lib.client.ClientAudioManager;
import com.dannbrown.musicbox.common.lib.main.FileSound;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0006B+\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0002\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0006J\u0017\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0018\u0010\b\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0017R\u0018\u0010\n\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0018R\u0016\u0010\f\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0019R\u0016\u0010\u000e\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/dannbrown/musicbox/common/content/networking/PlayCustomDiscS2CPacket;", "Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkPacket;", "<init>", "()V", "Lnet/minecraft/network/FriendlyByteBuf;", "buffer", "(Lnet/minecraft/network/FriendlyByteBuf;)V", "Lnet/minecraft/core/BlockPos;", "blockPos", "", "discUrl", "", "discRadius", "", "pitch", "(Lnet/minecraft/core/BlockPos;Ljava/lang/String;IF)V", "buf", "", "writeToBuffer", "Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkChannelHandler$Context;", "context", "handle", "(Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkChannelHandler$Context;)V", "Lnet/minecraft/core/BlockPos;", "Ljava/lang/String;", "I", "F", "musicbox-forge"})
@SourceDebugExtension(value={"SMAP\nPlayCustomDiscS2CPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayCustomDiscS2CPacket.kt\ncom/dannbrown/musicbox/common/content/networking/PlayCustomDiscS2CPacket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class PlayCustomDiscS2CPacket
implements NetworkPacket {
    @Nullable
    private BlockPos blockPos;
    @Nullable
    private String discUrl;
    private int discRadius;
    private float pitch;

    public PlayCustomDiscS2CPacket() {
        this.pitch = 1.0f;
    }

    public PlayCustomDiscS2CPacket(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this();
        this.blockPos = buffer.m_130135_();
        this.discUrl = buffer.m_130136_(Short.MAX_VALUE);
        this.discRadius = buffer.readInt();
        this.pitch = buffer.readFloat();
    }

    public PlayCustomDiscS2CPacket(@NotNull BlockPos blockPos, @NotNull String discUrl, int discRadius, float pitch) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)discUrl, (String)"discUrl");
        this();
        this.blockPos = blockPos;
        this.discUrl = discUrl;
        this.discRadius = discRadius;
        this.pitch = pitch;
    }

    public /* synthetic */ PlayCustomDiscS2CPacket(BlockPos blockPos, String string, int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            f = 1.0f;
        }
        this(blockPos, string, n, f);
    }

    public void writeToBuffer(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        BlockPos blockPos = this.blockPos;
        if (blockPos != null) {
            BlockPos it = blockPos;
            boolean bl = false;
            buf.m_130064_(it);
        }
        String string = this.discUrl;
        Intrinsics.checkNotNull((Object)string);
        buf.m_130070_(string);
        buf.writeInt(this.discRadius);
        buf.writeFloat(this.pitch);
    }

    public void handle(@NotNull NetworkChannelHandler.Context context) {
        Minecraft client;
        String fileNameWithExtension;
        String fileName;
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                    DeltaboxUtil.INSTANCE.getLOGGER().warn("PlayCustomDiscS2CPacket received on the server side!");
                    return;
                }
                DeltaboxUtil.INSTANCE.getLOGGER().info("Received packet to play custom disc");
                if (this.blockPos == null) {
                    DeltaboxUtil.INSTANCE.getLOGGER().warn("Received invalid PlayCustomDiscS2CPacket, blockPos is null!");
                    return;
                }
                fileName = DigestUtils.sha256Hex((String)this.discUrl);
                fileNameWithExtension = fileName + ".ogg";
                client = Minecraft.m_91087_();
                FileSound currentSound = ModContent.INSTANCE.getPlayingSounds().get(this.blockPos);
                if (currentSound != null) {
                    DeltaboxUtil.INSTANCE.getLOGGER().info("Stopping current sound in " + this.blockPos);
                    client.m_91106_().m_120399_((SoundInstance)currentSound);
                    Map<BlockPos, FileSound> map = ModContent.INSTANCE.getPlayingSounds();
                    BlockPos blockPos = this.blockPos;
                    TypeIntrinsics.asMutableMap(map).remove(blockPos);
                }
                if (this.discUrl == null) break block10;
                String string = this.discUrl;
                Intrinsics.checkNotNull((Object)string);
                if (!(((CharSequence)string).length() == 0)) break block11;
            }
            DeltaboxUtil.INSTANCE.getLOGGER().warn("Received invalid PlayCustomDiscS2CPacket, discUrl is null!");
            return;
        }
        if (Intrinsics.areEqual((Object)ModContent.INSTANCE.getOngoingDownloads().get(this.blockPos), (Object)true)) {
            DeltaboxUtil.INSTANCE.getLOGGER().warn("Download already in progress for " + this.blockPos + ", allowing new download but will play the first to finish.");
        } else {
            Map<BlockPos, Boolean> map = ModContent.INSTANCE.getOngoingDownloads();
            BlockPos blockPos = this.blockPos;
            Intrinsics.checkNotNull((Object)blockPos);
            map.put(blockPos, true);
        }
        this.pitch = this.pitch <= 0.0f ? 1.0f : ((double)this.pitch >= 2.0 ? 2.0f : this.pitch);
        File file = ClientAudioManager.INSTANCE.fileNameToFile(fileNameWithExtension);
        Intrinsics.checkNotNull((Object)file);
        if (!file.exists() && client.f_91074_ != null) {
            LocalPlayer localPlayer = client.f_91074_;
            Intrinsics.checkNotNull((Object)localPlayer);
            localPlayer.m_213846_((Component)Component.m_237115_((String)"gui.musicbox.custom_record.downloading"));
            String string = this.discUrl;
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNull((Object)fileName);
            ClientAudioManager.INSTANCE.downloadAudio(string, fileName).thenAccept(arg_0 -> PlayCustomDiscS2CPacket.handle$lambda$2(arg_0 -> PlayCustomDiscS2CPacket.handle$lambda$1(this, client, fileName, arg_0), arg_0));
        } else {
            Map<BlockPos, Boolean> map = ModContent.INSTANCE.getOngoingDownloads();
            BlockPos blockPos = this.blockPos;
            Intrinsics.checkNotNull((Object)blockPos);
            map.remove(blockPos);
            Intrinsics.checkNotNull((Object)fileName);
            BlockPos blockPos2 = this.blockPos;
            Intrinsics.checkNotNull((Object)blockPos2);
            FileSound newFileSound = new FileSound(fileName, blockPos2, this.discRadius, this.pitch);
            Map<BlockPos, FileSound> map2 = ModContent.INSTANCE.getPlayingSounds();
            BlockPos blockPos3 = this.blockPos;
            Intrinsics.checkNotNull((Object)blockPos3);
            map2.put(blockPos3, newFileSound);
            client.m_91106_().m_120367_((SoundInstance)newFileSound);
            DeltaboxUtil.INSTANCE.getLOGGER().info("Playing sound " + fileName + " in " + this.blockPos + ", radius " + this.discRadius + ", pitch " + this.pitch);
        }
    }

    private static final Unit handle$lambda$1(PlayCustomDiscS2CPacket this$0, Minecraft $client, String $fileName, Boolean result) {
        Map<BlockPos, Boolean> map = ModContent.INSTANCE.getOngoingDownloads();
        BlockPos blockPos = this$0.blockPos;
        Intrinsics.checkNotNull((Object)blockPos);
        map.remove(blockPos);
        if (result.booleanValue()) {
            LocalPlayer localPlayer = $client.f_91074_;
            Intrinsics.checkNotNull((Object)localPlayer);
            localPlayer.m_213846_((Component)Component.m_237115_((String)"gui.musicbox.custom_record.downloading_success"));
            if (ModContent.INSTANCE.getPlayingSounds().get(this$0.blockPos) == null) {
                Intrinsics.checkNotNull((Object)$fileName);
                BlockPos blockPos2 = this$0.blockPos;
                Intrinsics.checkNotNull((Object)blockPos2);
                FileSound newFileSound = new FileSound($fileName, blockPos2, this$0.discRadius, this$0.pitch);
                Map<BlockPos, FileSound> map2 = ModContent.INSTANCE.getPlayingSounds();
                BlockPos blockPos3 = this$0.blockPos;
                Intrinsics.checkNotNull((Object)blockPos3);
                map2.put(blockPos3, newFileSound);
                $client.m_91106_().m_120367_((SoundInstance)newFileSound);
                DeltaboxUtil.INSTANCE.getLOGGER().info("Playing sound " + $fileName + " in " + this$0.blockPos + ", radius " + this$0.discRadius + ", pitch " + this$0.pitch);
            } else {
                DeltaboxUtil.INSTANCE.getLOGGER().warn("Sound already playing at " + this$0.blockPos + ", not playing the new sound.");
            }
        } else {
            LocalPlayer localPlayer = $client.f_91074_;
            Intrinsics.checkNotNull((Object)localPlayer);
            localPlayer.m_213846_((Component)Component.m_237115_((String)"gui.musicbox.custom_record.downloading_error"));
        }
        return Unit.INSTANCE;
    }

    private static final void handle$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

