/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.musicbox.common.content.networking;

import com.dannbrown.deltaboxlib.common.registrate.network.NetworkChannelHandler;
import com.dannbrown.deltaboxlib.common.registrate.network.NetworkPacket;
import com.dannbrown.deltaboxlib.common.registrate.util.DeltaboxUtil;
import com.dannbrown.musicbox.common.content.items.DiscVariant;
import com.dannbrown.musicbox.common.init.ModConfig;
import com.dannbrown.musicbox.common.init.ModItems;
import com.dannbrown.musicbox.common.lib.main.YoutubeUtils;
import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0006B;\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0002\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0006J\u0017\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0019R\u0016\u0010\f\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\u001bR\u0016\u0010\u000e\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u001cR\u0016\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/dannbrown/musicbox/common/content/networking/SaveDiscUrlC2SPacket;", "Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkPacket;", "<init>", "()V", "Lnet/minecraft/network/FriendlyByteBuf;", "buf", "(Lnet/minecraft/network/FriendlyByteBuf;)V", "", "urlName", "", "discLength", "discName", "discRadius", "", "locked", "", "pitch", "(Ljava/lang/String;ILjava/lang/String;IZF)V", "", "writeToBuffer", "Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkChannelHandler$Context;", "context", "handle", "(Lcom/dannbrown/deltaboxlib/common/registrate/network/NetworkChannelHandler$Context;)V", "discUrl", "Ljava/lang/String;", "discDuration", "I", "Z", "F", "musicbox-forge"})
public final class SaveDiscUrlC2SPacket
implements NetworkPacket {
    @Nullable
    private String discUrl;
    private int discDuration;
    @Nullable
    private String discName;
    private int discRadius;
    private boolean locked;
    private float pitch;

    public SaveDiscUrlC2SPacket() {
        this.pitch = 1.0f;
    }

    public SaveDiscUrlC2SPacket(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this();
        this.discUrl = buf.m_130136_(Short.MAX_VALUE);
        this.discDuration = buf.readInt();
        byte[] byArray = buf.m_130052_();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readByteArray(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        this.discName = new String(byArray2, charset);
        this.discRadius = (int)buf.readLong();
        this.locked = buf.readBoolean();
        this.pitch = buf.readFloat();
    }

    public SaveDiscUrlC2SPacket(@NotNull String urlName, int discLength, @NotNull String discName, int discRadius, boolean locked, float pitch) {
        Intrinsics.checkNotNullParameter((Object)urlName, (String)"urlName");
        Intrinsics.checkNotNullParameter((Object)discName, (String)"discName");
        this();
        this.discUrl = urlName;
        this.discDuration = discLength;
        this.discName = discName;
        this.discRadius = discRadius;
        this.locked = locked;
        this.pitch = pitch;
    }

    public /* synthetic */ SaveDiscUrlC2SPacket(String string, int n, String string2, int n2, boolean bl, float f, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x20) != 0) {
            f = 1.0f;
        }
        this(string, n, string2, n2, bl, f);
    }

    public void writeToBuffer(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        String string = this.discUrl;
        Intrinsics.checkNotNull((Object)string);
        buf.m_130070_(string);
        buf.writeInt(this.discDuration);
        String string2 = this.discName;
        Intrinsics.checkNotNull((Object)string2);
        String string3 = string2;
        byte[] byArray = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        buf.m_130087_(byArray);
        buf.writeLong((long)this.discRadius);
        buf.writeBoolean(this.locked);
        buf.writeFloat(this.pitch);
    }

    public void handle(@NotNull NetworkChannelHandler.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Player player = context.getSender();
        DeltaboxUtil.INSTANCE.getLOGGER().info("Received packet to save disc URL");
        if (player != null) {
            ItemStack stackInHand = player.m_21120_(player.f_20912_);
            if (!stackInHand.m_150930_(ModItems.INSTANCE.getCUSTOM_RECORD().get()) || this.discUrl == null) {
                player.m_5661_((Component)Component.m_237115_((String)"gui.musicbox.custom_record.no_record"), true);
                return;
            }
            int durationToWrite = this.discDuration <= 0 ? 0 : this.discDuration;
            try {
                new URL(this.discUrl).toURI();
            }
            catch (Exception e) {
                player.m_5661_((Component)Component.m_237115_((String)"gui.musicbox.custom_record.url_invalid"), true);
                return;
            }
            String string = this.discUrl;
            Intrinsics.checkNotNull((Object)string);
            if (!YoutubeUtils.INSTANCE.isYoutubeVideo(string)) {
                player.m_5661_((Component)Component.m_237115_((String)"gui.musicbox.custom_record.youtube_invalid"), true);
                return;
            }
            String string2 = this.discUrl;
            Intrinsics.checkNotNull((Object)string2);
            if (string2.length() > 200) {
                player.m_5661_((Component)Component.m_237115_((String)"gui.musicbox.custom_record.url_too_long"), true);
                return;
            }
            int maxRadius = ((Number)ModConfig.INSTANCE.getMAX_DISC_RADIUS().get()).intValue();
            if (this.discRadius <= 0) {
                player.m_5661_((Component)Component.m_237115_((String)"gui.musicbox.custom_record.radius_too_small"), true);
                return;
            }
            if (this.discRadius > maxRadius) {
                Object[] e = new Object[]{maxRadius};
                player.m_5661_((Component)Component.m_237110_((String)"gui.musicbox.custom_record.radius_too_big", (Object[])e), true);
                return;
            }
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12565_, SoundSource.PLAYERS, 1.0f, 1.0f);
            CompoundTag compoundTag = stackInHand.m_41784_();
            String string3 = this.discUrl;
            Intrinsics.checkNotNull((Object)string3);
            compoundTag.m_128359_("song_url", YoutubeUtils.INSTANCE.removeUrlParameters(string3));
            stackInHand.m_41784_().m_128405_("song_duration", durationToWrite);
            CompoundTag compoundTag2 = stackInHand.m_41784_();
            String string4 = this.discName;
            if (string4 == null) {
                string4 = "";
            }
            compoundTag2.m_128359_("song_name", string4);
            stackInHand.m_41784_().m_128405_("song_radius", this.discRadius);
            stackInHand.m_41784_().m_128379_("song_locked", this.locked);
            if (this.locked) {
                stackInHand.m_41784_().m_128359_("song_owner", player.m_36316_().getName());
            }
            int texture = stackInHand.m_41784_().m_128451_("song_texture");
            if (!this.locked || texture == 0) {
                stackInHand.m_41784_().m_128405_("song_texture", DiscVariant.Companion.random().toInt());
            }
            String string5 = this.discUrl;
            Intrinsics.checkNotNull((Object)string5);
            Float f = YoutubeUtils.INSTANCE.getPitchFromUrl(string5);
            float urlPitch = f != null ? f.floatValue() : this.pitch;
            stackInHand.m_41784_().m_128350_("song_pitch", urlPitch);
            CharSequence charSequence = this.discName;
            if (!(charSequence == null || charSequence.length() == 0)) {
                String string6 = this.discName;
                if (string6 == null) {
                    string6 = "";
                }
                stackInHand.m_41714_((Component)Component.m_237113_((String)string6));
            }
            player.m_21008_(player.f_20912_, stackInHand);
            player.m_5661_((Component)Component.m_237115_((String)"gui.musicbox.custom_record.disc_saved"), true);
            DeltaboxUtil.INSTANCE.getLOGGER().info("Saved disc details to item, " + this.discName + ", " + this.discUrl + ", " + this.discDuration + ", " + this.discRadius + ", " + this.locked + ", " + urlPitch);
        } else {
            DeltaboxUtil.INSTANCE.getLOGGER().error("Player was null when trying to save disc details");
        }
    }
}

