/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.musicbox.common.datagen;

import com.dannbrown.deltaboxlib.common.registrate.util.DeltaboxUtil;
import com.dannbrown.musicbox.common.datagen.AddDiscModifier;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J+\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0017R\u001c\u0010\u001a\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/dannbrown/musicbox/common/datagen/DiscLootProvider;", "Lnet/minecraft/data/DataProvider;", "", "Lcom/dannbrown/musicbox/common/datagen/AddDiscModifier;", "discs", "Lnet/minecraft/data/PackOutput;", "packOutput", "<init>", "(Ljava/util/List;Lnet/minecraft/data/PackOutput;)V", "", "getName", "()Ljava/lang/String;", "Lnet/minecraft/data/CachedOutput;", "cachedOutput", "Ljava/util/concurrent/CompletableFuture;", "run", "(Lnet/minecraft/data/CachedOutput;)Ljava/util/concurrent/CompletableFuture;", "Ljava/nio/file/Path;", "path", "disc", "saveDiscData", "(Lnet/minecraft/data/CachedOutput;Ljava/nio/file/Path;Lcom/dannbrown/musicbox/common/datagen/AddDiscModifier;)Ljava/util/concurrent/CompletableFuture;", "Ljava/util/List;", "Lnet/minecraft/data/PackOutput;", "Lnet/minecraft/data/PackOutput$PathProvider;", "kotlin.jvm.PlatformType", "pathProvider", "Lnet/minecraft/data/PackOutput$PathProvider;", "musicbox-forge"})
@SourceDebugExtension(value={"SMAP\nDiscLootProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiscLootProvider.kt\ncom/dannbrown/musicbox/common/datagen/DiscLootProvider\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,46:1\n37#2,2:47\n*S KotlinDebug\n*F\n+ 1 DiscLootProvider.kt\ncom/dannbrown/musicbox/common/datagen/DiscLootProvider\n*L\n30#1:47,2\n*E\n"})
public final class DiscLootProvider
implements DataProvider {
    @NotNull
    private final List<AddDiscModifier> discs;
    @NotNull
    private final PackOutput packOutput;
    private final PackOutput.PathProvider pathProvider;

    public DiscLootProvider(@NotNull List<AddDiscModifier> discs, @NotNull PackOutput packOutput) {
        Intrinsics.checkNotNullParameter(discs, (String)"discs");
        Intrinsics.checkNotNullParameter((Object)packOutput, (String)"packOutput");
        this.discs = discs;
        this.packOutput = packOutput;
        this.pathProvider = this.packOutput.m_245269_(PackOutput.Target.DATA_PACK, "loot_modifiers");
    }

    @NotNull
    public String m_6055_() {
        return "Disc Loot Datagen for: musicbox";
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cachedOutput) {
        Intrinsics.checkNotNullParameter((Object)cachedOutput, (String)"cachedOutput");
        List futures = new ArrayList();
        for (AddDiscModifier disc : this.discs) {
            String string = DeltaboxUtil.INSTANCE.asId(disc.getName());
            String string2 = disc.getLootTableId().m_135815_();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            String discName = "add_" + string + "_to_" + DeltaboxUtil.INSTANCE.asId(string2);
            Path discPath = this.pathProvider.m_245731_(DeltaboxUtil.INSTANCE.resourceLocation("musicbox", discName));
            Intrinsics.checkNotNull((Object)discPath);
            futures.add(this.saveDiscData(cachedOutput, discPath, disc));
        }
        Collection $this$toTypedArray$iv = futures;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"allOf(...)");
        return completableFuture;
    }

    private final CompletableFuture<?> saveDiscData(CachedOutput cachedOutput, Path path, AddDiscModifier disc) {
        CompletableFuture completableFuture;
        try {
            JsonObject jsonObject = ((JsonElement)AddDiscModifier.Companion.getCODEC().get().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)disc).getOrThrow(false, DiscLootProvider::saveDiscData$lambda$0)).getAsJsonObject();
            completableFuture = DataProvider.m_253162_((CachedOutput)cachedOutput, (JsonElement)((JsonElement)jsonObject), (Path)path);
        }
        catch (IOException ioException) {
            DeltaboxUtil.INSTANCE.getLOGGER().error("Couldn't save disc loot at {}", (Object)path, (Object)ioException);
            throw ioException;
        }
        return completableFuture;
    }

    private static final void saveDiscData$lambda$0(String it) {
    }
}

