/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.musicbox.common.lib.executable;

import com.dannbrown.musicbox.common.lib.executable.DownloadManager;
import com.dannbrown.musicbox.common.lib.main.Manager;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u0016\u0010\r\u001a\u0004\u0018\u00010\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\t8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000bR\u001a\u0010\u0011\u001a\u00020\t8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000b\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/dannbrown/musicbox/common/lib/executable/FFmpeg;", "", "<init>", "()V", "", "checkForExecutable", "", "checkForUpdates", "()Z", "", "FILENAME", "Ljava/lang/String;", "Ljava/io/File;", "DIRECTORY", "Ljava/io/File;", "REPOSITORY_FILE", "REPOSITORY_NAME", "HARDCODED_VERSION", "getHARDCODED_VERSION", "()Ljava/lang/String;", "musicbox-forge"})
public final class FFmpeg {
    @NotNull
    public static final FFmpeg INSTANCE;
    @NotNull
    private static final String FILENAME;
    @Nullable
    private static final File DIRECTORY;
    @NotNull
    private static final String REPOSITORY_FILE;
    @NotNull
    private static final String REPOSITORY_NAME = "Tyrrrz/FFmpegBin";
    @NotNull
    private static final String HARDCODED_VERSION;

    private FFmpeg() {
    }

    @NotNull
    public final String getHARDCODED_VERSION() {
        return HARDCODED_VERSION;
    }

    public final void checkForExecutable() throws IOException, URISyntaxException {
        if (DIRECTORY == null) {
            return;
        }
        DownloadManager.INSTANCE.checkForFile(FILENAME, DIRECTORY, REPOSITORY_FILE, REPOSITORY_NAME);
    }

    public final boolean checkForUpdates() {
        return false;
    }

    static {
        File file;
        INSTANCE = new FFmpeg();
        FILENAME = "ffmpeg" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        if (Manager.INSTANCE.getPATH() != null) {
            Path path = Manager.INSTANCE.getPATH();
            Intrinsics.checkNotNull((Object)path);
            file = path.resolve("ffmpeg").toFile();
        } else {
            file = null;
        }
        DIRECTORY = file;
        String string = "ffmpeg-%s-x64.zip";
        Object[] objectArray = new Object[]{SystemUtils.IS_OS_LINUX ? "linux" : (SystemUtils.IS_OS_MAC ? "osx" : "windows")};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        REPOSITORY_FILE = string2;
        HARDCODED_VERSION = "7.0.2";
    }
}

