/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.musicbox.common.lib.main;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/dannbrown/musicbox/common/lib/main/YoutubeUtils;", "", "<init>", "()V", "", "url", "", "isYoutubeVideo", "(Ljava/lang/String;)Z", "removeUrlParameters", "(Ljava/lang/String;)Ljava/lang/String;", "", "getPitchFromUrl", "(Ljava/lang/String;)Ljava/lang/Float;", "Ljava/util/regex/Pattern;", "YOUTUBE_VIDEO_REGEX", "Ljava/util/regex/Pattern;", "musicbox-forge"})
public final class YoutubeUtils {
    @NotNull
    public static final YoutubeUtils INSTANCE = new YoutubeUtils();
    @NotNull
    private static final Pattern YOUTUBE_VIDEO_REGEX;

    private YoutubeUtils() {
    }

    public final boolean isYoutubeVideo(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Matcher matcher = YOUTUBE_VIDEO_REGEX.matcher(url);
        return matcher.find();
    }

    @NotNull
    public final String removeUrlParameters(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Matcher matcher = YOUTUBE_VIDEO_REGEX.matcher(url);
        if (matcher.find()) {
            String videoId = matcher.group(6);
            return "https://www.youtube.com/watch?v=" + videoId;
        }
        return url;
    }

    @Nullable
    public final Float getPitchFromUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Pattern pitchRegex = Pattern.compile("pitch=([0-9]*\\.?[0-9]+)");
        Matcher matcher = pitchRegex.matcher(url);
        if (matcher.find()) {
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            float pitch = Float.parseFloat(string);
            return pitch > 2.0f ? Float.valueOf(2.0f) : (pitch < 0.5f ? Float.valueOf(0.5f) : Float.valueOf(pitch));
        }
        return null;
    }

    static {
        Pattern pattern = Pattern.compile("^((?:https?:)?//)?((?:www|m)\\.)?((?:youtube(-nocookie)?\\.com|youtu.be))(\\/(?:[\\w\\-]+\\?v=|embed\\/|v\\/|watch\\?v=)?)([\\w\\-]+)(\\S+)?$", 2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        YOUTUBE_VIDEO_REGEX = pattern;
    }
}

