/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.tool;

import com.klikli_dev.occultism.registry.OccultismTags;
import com.klikli_dev.occultism.util.EntityUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SoulGemItem
extends Item {
    public SoulGemItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43724_() != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        ItemStack itemStack = context.m_43722_();
        Level level = context.m_43725_();
        Direction facing = context.m_43719_();
        BlockPos pos = context.m_8083_();
        if (itemStack.m_41784_().m_128441_("entityData")) {
            if (!level.f_46443_) {
                CompoundTag entityData = itemStack.m_41783_().m_128469_("entityData");
                itemStack.m_41783_().m_128473_("entityData");
                EntityType<?> type = EntityUtil.entityTypeFromNbt(entityData);
                facing = facing == null ? Direction.UP : facing;
                BlockPos spawnPos = pos.m_7949_();
                if (!level.m_8055_(spawnPos).m_60812_((BlockGetter)level, spawnPos).m_83281_()) {
                    spawnPos = spawnPos.m_121945_(facing);
                }
                MutableComponent customName = null;
                if (entityData.m_128441_("CustomName")) {
                    customName = Component.Serializer.m_130701_((String)entityData.m_128461_("CustomName"));
                }
                entityData.m_128473_("Pos");
                CompoundTag wrapper = new CompoundTag();
                wrapper.m_128365_("EntityTag", (Tag)entityData);
                Entity entity = type.m_20615_(level);
                entity.m_20258_(entityData);
                entity.m_19890_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
                level.m_7967_(entity);
                player.m_6674_(context.m_43724_());
                player.f_36095_.m_38946_();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (!target.m_6084_()) {
            return InteractionResult.PASS;
        }
        if (target.m_9236_().f_46443_) {
            return InteractionResult.PASS;
        }
        if (target instanceof Player) {
            return InteractionResult.FAIL;
        }
        if (stack.m_41784_().m_128441_("entityData")) {
            return InteractionResult.FAIL;
        }
        if (target.m_6095_().m_204039_(OccultismTags.Entities.SOUL_GEM_DENY_LIST)) {
            player.m_213846_((Component)Component.m_237115_((String)(this.m_5524_() + ".message.entity_type_denied")));
            return InteractionResult.FAIL;
        }
        stack.m_41783_().m_128365_("entityData", (Tag)target.serializeNBT());
        player.m_6674_(hand);
        player.m_21008_(hand, stack);
        target.m_142687_(Entity.RemovalReason.DISCARDED);
        player.f_36095_.m_38946_();
        return InteractionResult.SUCCESS;
    }

    public String m_5671_(ItemStack stack) {
        return stack.m_41784_().m_128441_("entityData") ? this.m_5524_() : this.m_5524_() + "_empty";
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41784_().m_128441_("entityData")) {
            EntityType<?> type = EntityUtil.entityTypeFromNbt(stack.m_41783_().m_128469_("entityData"));
            tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".tooltip_filled"), (Object[])new Object[]{type.m_20676_()}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip_empty")));
        }
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag tag = super.getShareTag(stack);
        if (tag != null && (tag = tag.m_6426_()).m_128441_("entityData")) {
            CompoundTag entityData = tag.m_128469_("entityData");
            String[] toRemove = (String[])entityData.m_128431_().stream().filter(key -> !key.equals("id")).toArray(String[]::new);
            Arrays.stream(toRemove).forEach(arg_0 -> ((CompoundTag)entityData).m_128473_(arg_0));
        }
        return tag;
    }
}

